/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDataToken;

public class AuthenticationToken
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final long serialVersionUID = 1L;
    private transient Supplier<String> tokenSupplier;

    public AuthenticationToken() {
    }

    public AuthenticationToken(String token) {
        this(() -> token);
    }

    public AuthenticationToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public void close() throws IOException {
    }

    public String getAuthMethodName() {
        return "token";
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        return new AuthenticationDataToken(this.tokenSupplier);
    }

    public void configure(String encodedAuthParamString) {
        if (encodedAuthParamString.startsWith("token:")) {
            this.tokenSupplier = () -> encodedAuthParamString.substring("token:".length());
        } else if (encodedAuthParamString.startsWith("file:")) {
            URI filePath = URI.create(encodedAuthParamString);
            this.tokenSupplier = () -> {
                try {
                    return new String(Files.readAllBytes(Paths.get(filePath)), Charsets.UTF_8).trim();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read token from file", e);
                }
            };
        } else {
            this.tokenSupplier = () -> encodedAuthParamString;
        }
    }

    public void configure(Map<String, String> authParams) {
    }

    public void start() throws PulsarClientException {
    }
}

