/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarConnectorId;
import org.apache.pulsar.sql.presto.PulsarConnectorUtils;
import org.apache.pulsar.sql.presto.PulsarHandleResolver;
import org.apache.pulsar.sql.presto.PulsarInternalColumn;
import org.apache.pulsar.sql.presto.PulsarSchemaHandlers;
import org.apache.pulsar.sql.presto.PulsarTableHandle;
import org.apache.pulsar.sql.presto.PulsarTableLayoutHandle;

public class PulsarMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final PulsarAdmin pulsarAdmin;
    private final PulsarConnectorConfig pulsarConnectorConfig;
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final Logger log = Logger.get(PulsarMetadata.class);

    @Inject
    public PulsarMetadata(PulsarConnectorId connectorId, PulsarConnectorConfig pulsarConnectorConfig) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        try {
            this.pulsarAdmin = pulsarConnectorConfig.getPulsarAdmin();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        LinkedList<String> prestoSchemas = new LinkedList<String>();
        try {
            List<String> tenants = this.pulsarAdmin.tenants().getTenants();
            for (String tenant : tenants) {
                prestoSchemas.addAll(this.pulsarAdmin.namespaces().getNamespaces(tenant).stream().map(namespace -> PulsarConnectorUtils.rewriteNamespaceDelimiterIfNeeded(namespace, this.pulsarConnectorConfig)).collect(Collectors.toList()));
            }
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Failed to get schemas from pulsar: Unauthorized");
            }
            throw new RuntimeException("Failed to get schemas from pulsar: " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        return prestoSchemas;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return new PulsarTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), tableName.getTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        PulsarTableHandle handle = PulsarHandleResolver.convertTableHandle(table);
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new PulsarTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        SchemaTableName schemaTableName = PulsarHandleResolver.convertTableHandle(table).toSchemaTableName();
        ConnectorTableMetadata connectorTableMetadata = this.getTableMetadata(schemaTableName, true);
        if (connectorTableMetadata == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            connectorTableMetadata = new ConnectorTableMetadata(schemaTableName, (List)builder.build());
        }
        return connectorTableMetadata;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        String schemaNameOrNull;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (schemaName.isPresent() && !(schemaNameOrNull = schemaName.get()).equals(INFORMATION_SCHEMA)) {
            List<String> pulsarTopicList = null;
            try {
                pulsarTopicList = this.pulsarAdmin.topics().getList(PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(schemaNameOrNull, this.pulsarConnectorConfig));
            }
            catch (PulsarAdminException e) {
                if (e.getStatusCode() == 404) {
                    log.warn("Schema " + schemaNameOrNull + " does not exsit");
                    return builder.build();
                }
                if (e.getStatusCode() == 401) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get tables/topics in %s: Unauthorized", schemaNameOrNull));
                }
                throw new RuntimeException("Failed to get tables/topics in " + schemaNameOrNull + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
            }
            if (pulsarTopicList != null) {
                pulsarTopicList.stream().map(topic -> TopicName.get((String)topic).getPartitionedTopicName()).distinct().forEach(topic -> builder.add((Object)new SchemaTableName(schemaNameOrNull, TopicName.get((String)topic).getLocalName())));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PulsarTableHandle pulsarTableHandle = PulsarHandleResolver.convertTableHandle(tableHandle);
        ConnectorTableMetadata tableMetaData = this.getTableMetadata(pulsarTableHandle.toSchemaTableName(), false);
        if (tableMetaData == null) {
            return new HashMap<String, ColumnHandle>();
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        tableMetaData.getColumns().forEach(columnMetadata -> {
            PulsarColumnMetadata pulsarColumnMetadata = (PulsarColumnMetadata)((Object)columnMetadata);
            PulsarColumnHandle pulsarColumnHandle = new PulsarColumnHandle(this.connectorId, pulsarColumnMetadata.getNameWithCase(), pulsarColumnMetadata.getType(), pulsarColumnMetadata.isHidden(), pulsarColumnMetadata.isInternal(), pulsarColumnMetadata.getFieldNames(), pulsarColumnMetadata.getPositionIndices(), pulsarColumnMetadata.getHandleKeyValueType());
            columnHandles.put((Object)columnMetadata.getName(), (Object)pulsarColumnHandle);
        });
        PulsarInternalColumn.getInternalFields().forEach(pulsarInternalColumn -> {
            PulsarColumnHandle pulsarColumnHandle = pulsarInternalColumn.getColumnHandle(this.connectorId, false);
            columnHandles.put((Object)pulsarColumnHandle.getName(), (Object)pulsarColumnHandle);
        });
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        PulsarHandleResolver.convertTableHandle(tableHandle);
        return PulsarHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = !prefix.getTable().isPresent() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)new SchemaTableName((String)prefix.getSchema().get(), (String)prefix.getTable().get()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata connectorTableMetadata = this.getTableMetadata(tableName, true);
            if (connectorTableMetadata == null) continue;
            columns.put((Object)tableName, (Object)connectorTableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName, boolean withInternalColumns) {
        SchemaInfo schemaInfo;
        List<String> topics;
        if (schemaTableName.getSchemaName().equals(INFORMATION_SCHEMA)) {
            return null;
        }
        String namespace = PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(schemaTableName.getSchemaName(), this.pulsarConnectorConfig);
        TopicName topicName = TopicName.get((String)String.format("%s/%s", namespace, schemaTableName.getTableName()));
        try {
            topics = !PulsarConnectorUtils.isPartitionedTopic(topicName, this.pulsarAdmin) ? this.pulsarAdmin.topics().getList(namespace) : this.pulsarAdmin.topics().getPartitionedTopicList(namespace);
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema " + namespace + " does not exist");
            }
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get topics in schema %s: Unauthorized", namespace));
            }
            throw new RuntimeException("Failed to get topics in schema " + namespace + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        if (!topics.contains(topicName.toString())) {
            log.error("Table %s not found", new Object[]{String.format("%s/%s", namespace, schemaTableName.getTableName())});
            throw new TableNotFoundException(schemaTableName);
        }
        try {
            schemaInfo = this.pulsarAdmin.schemas().getSchemaInfo(String.format("%s/%s", namespace, schemaTableName.getTableName()));
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                schemaInfo = PulsarSchemaHandlers.defaultSchema();
            }
            if (e.getStatusCode() == 401) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get pulsar topic schema information for topic %s/%s: Unauthorized", namespace, schemaTableName.getTableName()));
            }
            throw new RuntimeException("Failed to get pulsar topic schema information for topic " + String.format("%s/%s", namespace, schemaTableName.getTableName()) + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        List<ColumnMetadata> handles = PulsarMetadata.getPulsarColumns(topicName, schemaInfo, withInternalColumns, PulsarColumnHandle.HandleKeyValueType.NONE);
        return new ConnectorTableMetadata(schemaTableName, handles);
    }

    static List<ColumnMetadata> getPulsarColumns(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        SchemaType schemaType = schemaInfo.getType();
        if (schemaType.isStruct()) {
            return PulsarMetadata.getPulsarColumnsFromStructSchema(topicName, schemaInfo, withInternalColumns, handleKeyValueType);
        }
        if (schemaType.isPrimitive()) {
            return PulsarMetadata.getPulsarColumnsFromPrimitiveSchema(topicName, schemaInfo, withInternalColumns, handleKeyValueType);
        }
        if (schemaType.equals((Object)SchemaType.KEY_VALUE)) {
            return PulsarMetadata.getPulsarColumnsFromKeyValueSchema(topicName, schemaInfo, withInternalColumns);
        }
        throw new IllegalArgumentException("Unsupported schema : " + schemaInfo);
    }

    static List<ColumnMetadata> getPulsarColumnsFromPrimitiveSchema(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        PulsarColumnMetadata valueColumn = new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, "__value__"), PulsarMetadata.convertPulsarType(schemaInfo.getType()), "The value of the message with primitive type schema", null, false, false, new String[0], new Integer[0], handleKeyValueType);
        builder.add((Object)valueColumn);
        if (withInternalColumns) {
            PulsarInternalColumn.getInternalFields().stream().forEach(pulsarInternalColumn -> builder.add((Object)pulsarInternalColumn.getColumnMetadata(false)));
        }
        return builder.build();
    }

    static List<ColumnMetadata> getPulsarColumnsFromStructSchema(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        Schema schema;
        String schemaJson = new String(schemaInfo.getSchema());
        if (StringUtils.isBlank((CharSequence)schemaJson)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            schema = PulsarConnectorUtils.parseSchema(schemaJson);
        }
        catch (SchemaParseException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(PulsarMetadata.getColumns(null, schema, new HashSet<String>(), new Stack<String>(), new Stack<Integer>(), handleKeyValueType));
        if (withInternalColumns) {
            PulsarInternalColumn.getInternalFields().stream().forEach(pulsarInternalColumn -> builder.add((Object)pulsarInternalColumn.getColumnMetadata(false)));
        }
        return builder.build();
    }

    static List<ColumnMetadata> getPulsarColumnsFromKeyValueSchema(TopicName topicName, SchemaInfo schemaInfo, boolean withInternalColumns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
        SchemaInfo keySchemaInfo = (SchemaInfo)kvSchemaInfo.getKey();
        List<ColumnMetadata> keyColumnMetadataList = PulsarMetadata.getPulsarColumns(topicName, keySchemaInfo, false, PulsarColumnHandle.HandleKeyValueType.KEY);
        builder.addAll(keyColumnMetadataList);
        SchemaInfo valueSchemaInfo = (SchemaInfo)kvSchemaInfo.getValue();
        List<ColumnMetadata> valueColumnMetadataList = PulsarMetadata.getPulsarColumns(topicName, valueSchemaInfo, false, PulsarColumnHandle.HandleKeyValueType.VALUE);
        builder.addAll(valueColumnMetadataList);
        if (withInternalColumns) {
            PulsarInternalColumn.getInternalFields().forEach(pulsarInternalColumn -> builder.add((Object)pulsarInternalColumn.getColumnMetadata(false)));
        }
        return builder.build();
    }

    @VisibleForTesting
    static Type convertPulsarType(SchemaType pulsarType) {
        switch (pulsarType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case INT8: {
                return TinyintType.TINYINT;
            }
            case INT16: {
                return SmallintType.SMALLINT;
            }
            case INT32: {
                return IntegerType.INTEGER;
            }
            case INT64: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case NONE: 
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIME: {
                return TimeType.TIME;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
        }
        log.error("Cannot convert type: %s", new Object[]{pulsarType});
        return null;
    }

    @VisibleForTesting
    static List<PulsarColumnMetadata> getColumns(String fieldName, Schema fieldSchema, Set<String> fieldTypes, Stack<String> fieldNames, Stack<Integer> positionIndices, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        LinkedList<PulsarColumnMetadata> columnMetadataList = new LinkedList<PulsarColumnMetadata>();
        if (PulsarMetadata.isPrimitiveType(fieldSchema.getType())) {
            columnMetadataList.add(new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, fieldName), PulsarMetadata.convertType(fieldSchema.getType(), fieldSchema.getLogicalType()), null, null, false, false, fieldNames.toArray(new String[fieldNames.size()]), positionIndices.toArray(new Integer[positionIndices.size()]), handleKeyValueType));
        } else if (fieldSchema.getType() == Schema.Type.UNION) {
            boolean canBeNull = false;
            for (Schema type : fieldSchema.getTypes()) {
                if (PulsarMetadata.isPrimitiveType(type.getType())) {
                    if (type.getType() != Schema.Type.NULL) {
                        PulsarColumnMetadata columnMetadata = !canBeNull ? new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, fieldName), PulsarMetadata.convertType(type.getType(), type.getLogicalType()), null, null, false, false, fieldNames.toArray(new String[fieldNames.size()]), positionIndices.toArray(new Integer[positionIndices.size()]), handleKeyValueType) : new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, fieldName), PulsarMetadata.convertType(type.getType(), type.getLogicalType()), "field can be null", null, false, false, fieldNames.toArray(new String[fieldNames.size()]), positionIndices.toArray(new Integer[positionIndices.size()]), handleKeyValueType);
                        columnMetadataList.add(columnMetadata);
                        continue;
                    }
                    canBeNull = true;
                    continue;
                }
                List<PulsarColumnMetadata> columns = PulsarMetadata.getColumns(fieldName, type, fieldTypes, fieldNames, positionIndices, handleKeyValueType);
                columnMetadataList.addAll(columns);
            }
        } else if (fieldSchema.getType() == Schema.Type.RECORD) {
            if (!fieldTypes.contains(fieldSchema.getFullName())) {
                fieldTypes.add(fieldSchema.getFullName());
                List fields = fieldSchema.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field = (Schema.Field)fields.get(i);
                    fieldNames.push(field.name());
                    positionIndices.push(i);
                    List<PulsarColumnMetadata> columns = fieldName == null ? PulsarMetadata.getColumns(field.name(), field.schema(), fieldTypes, fieldNames, positionIndices, handleKeyValueType) : PulsarMetadata.getColumns(String.format("%s.%s", fieldName, field.name()), field.schema(), fieldTypes, fieldNames, positionIndices, handleKeyValueType);
                    positionIndices.pop();
                    fieldNames.pop();
                    columnMetadataList.addAll(columns);
                }
                fieldTypes.remove(fieldSchema.getFullName());
            } else {
                log.debug("Already seen type: %s", new Object[]{fieldSchema.getFullName()});
            }
        } else if (fieldSchema.getType() != Schema.Type.ARRAY && fieldSchema.getType() != Schema.Type.MAP) {
            if (fieldSchema.getType() == Schema.Type.ENUM) {
                PulsarColumnMetadata columnMetadata = new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, fieldName), PulsarMetadata.convertType(fieldSchema.getType(), fieldSchema.getLogicalType()), null, null, false, false, fieldNames.toArray(new String[fieldNames.size()]), positionIndices.toArray(new Integer[positionIndices.size()]), handleKeyValueType);
                columnMetadataList.add(columnMetadata);
            } else if (fieldSchema.getType() != Schema.Type.FIXED) {
                log.error("Unknown column type: {}", new Object[]{fieldSchema});
            }
        }
        return columnMetadataList;
    }

    @VisibleForTesting
    static Type convertType(Schema.Type avroType, LogicalType logicalType) {
        switch (avroType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case INT: {
                if (logicalType == LogicalTypes.timeMillis()) {
                    return TimeType.TIME;
                }
                if (logicalType == LogicalTypes.date()) {
                    return DateType.DATE;
                }
                return IntegerType.INTEGER;
            }
            case LONG: {
                if (logicalType == LogicalTypes.timestampMillis()) {
                    return TimestampType.TIMESTAMP;
                }
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case ENUM: {
                return VarcharType.VARCHAR;
            }
        }
        log.error("Cannot convert type: %s", new Object[]{avroType});
        return null;
    }

    @VisibleForTesting
    static boolean isPrimitiveType(Schema.Type type) {
        return Schema.Type.NULL == type || Schema.Type.BOOLEAN == type || Schema.Type.INT == type || Schema.Type.LONG == type || Schema.Type.FLOAT == type || Schema.Type.DOUBLE == type || Schema.Type.BYTES == type || Schema.Type.STRING == type;
    }
}

