/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarSchemaHandlers;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.SchemaHandler;

public class KeyValueSchemaHandler
implements SchemaHandler {
    private static final Logger log = Logger.get(KeyValueSchemaHandler.class);
    private final List<PulsarColumnHandle> columnHandles;
    private final SchemaHandler keySchemaHandler;
    private final SchemaHandler valueSchemaHandler;
    private KeyValueEncodingType keyValueEncodingType;

    public KeyValueSchemaHandler(TopicName topicName, PulsarConnectorConfig pulsarConnectorConfig, SchemaInfo schemaInfo, List<PulsarColumnHandle> columnHandles) {
        this.columnHandles = columnHandles;
        KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
        this.keySchemaHandler = PulsarSchemaHandlers.newPulsarSchemaHandler(topicName, pulsarConnectorConfig, (SchemaInfo)kvSchemaInfo.getKey(), columnHandles, PulsarSqlSchemaInfoProvider.Type.Key);
        this.valueSchemaHandler = PulsarSchemaHandlers.newPulsarSchemaHandler(topicName, pulsarConnectorConfig, (SchemaInfo)kvSchemaInfo.getValue(), columnHandles, PulsarSqlSchemaInfoProvider.Type.Value);
        this.keyValueEncodingType = KeyValueSchemaInfo.decodeKeyValueEncodingType(schemaInfo);
    }

    @VisibleForTesting
    KeyValueSchemaHandler(SchemaHandler keySchemaHandler, SchemaHandler valueSchemaHandler, List<PulsarColumnHandle> columnHandles) {
        this.keySchemaHandler = keySchemaHandler;
        this.valueSchemaHandler = valueSchemaHandler;
        this.columnHandles = columnHandles;
    }

    @Override
    public Object deserialize(ByteBuf keyPayload, ByteBuf dataPayload, byte[] schemaVersion) {
        ByteBuf valueByteBuf;
        ByteBuf keyByteBuf;
        if (Objects.equals(this.keyValueEncodingType, KeyValueEncodingType.INLINE)) {
            dataPayload.resetReaderIndex();
            int keyLength = dataPayload.readInt();
            keyByteBuf = dataPayload.readSlice(keyLength);
            int valueLength = dataPayload.readInt();
            valueByteBuf = dataPayload.readSlice(valueLength);
        } else {
            keyByteBuf = keyPayload;
            valueByteBuf = dataPayload;
        }
        Object keyObj = this.keySchemaHandler.deserialize(keyByteBuf, schemaVersion);
        Object valueObj = this.valueSchemaHandler.deserialize(valueByteBuf, schemaVersion);
        return new KeyValue(keyObj, valueObj);
    }

    @Override
    public Object extractField(int index, Object currentRecord) {
        PulsarColumnHandle pulsarColumnHandle = this.columnHandles.get(index);
        KeyValue keyValue = (KeyValue)currentRecord;
        if (pulsarColumnHandle.isKey()) {
            return this.keySchemaHandler.extractField(index, keyValue.getKey());
        }
        if (pulsarColumnHandle.isValue()) {
            return this.valueSchemaHandler.extractField(index, keyValue.getValue());
        }
        return null;
    }
}

