/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.UnaryOperator;
import org.apache.pulsar.client.impl.PulsarClientImpl;

abstract class HandlerState {
    protected final PulsarClientImpl client;
    protected final String topic;
    private static final AtomicReferenceFieldUpdater<HandlerState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(HandlerState.class, State.class, "state");
    private volatile State state = null;

    public HandlerState(PulsarClientImpl client, String topic) {
        this.client = client;
        this.topic = topic;
        STATE_UPDATER.set(this, State.Uninitialized);
    }

    protected boolean changeToReadyState() {
        if (STATE_UPDATER.get(this) == State.Ready) {
            return true;
        }
        return STATE_UPDATER.compareAndSet(this, State.Uninitialized, State.Ready) || STATE_UPDATER.compareAndSet(this, State.Connecting, State.Ready) || STATE_UPDATER.compareAndSet(this, State.RegisteringSchema, State.Ready);
    }

    protected boolean changeToRegisteringSchemaState() {
        return STATE_UPDATER.compareAndSet(this, State.Ready, State.RegisteringSchema);
    }

    protected State getState() {
        return STATE_UPDATER.get(this);
    }

    protected boolean changeToConnecting() {
        if (STATE_UPDATER.get(this) == State.Connecting) {
            return true;
        }
        return STATE_UPDATER.compareAndSet(this, State.Uninitialized, State.Connecting) || STATE_UPDATER.compareAndSet(this, State.Ready, State.Connecting) || STATE_UPDATER.compareAndSet(this, State.RegisteringSchema, State.Connecting);
    }

    protected void setState(State s) {
        STATE_UPDATER.set(this, s);
    }

    abstract String getHandlerName();

    protected State getAndUpdateState(UnaryOperator<State> updater) {
        return STATE_UPDATER.getAndUpdate(this, updater);
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    static enum State {
        Uninitialized,
        Connecting,
        Ready,
        Closing,
        Closed,
        Terminated,
        Failed,
        RegisteringSchema,
        ProducerFenced;

    }
}

