/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.json;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;
import org.apache.pulsar.sql.presto.PulsarRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonRowDecoder;

public class PulsarJsonRowDecoderFactory
implements PulsarRowDecoderFactory {
    private TypeManager typeManager;
    private static final Logger log = Logger.get(PulsarJsonRowDecoderFactory.class);

    public PulsarJsonRowDecoderFactory(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    @Override
    public PulsarJsonRowDecoder createRowDecoder(TopicName topicName, SchemaInfo schemaInfo, Set<DecoderColumnHandle> columns) {
        return new PulsarJsonRowDecoder((GenericJsonSchema)GenericJsonSchema.of(schemaInfo), columns);
    }

    @Override
    public List<ColumnMetadata> extractColumnMetadata(TopicName topicName, SchemaInfo schemaInfo, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        List<ColumnMetadata> columnMetadata;
        Schema schema;
        String schemaJson = new String(schemaInfo.getSchema());
        if (StringUtils.isBlank((CharSequence)schemaJson)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            schema = GenericJsonSchema.of(schemaInfo).getAvroSchema();
        }
        catch (SchemaParseException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " does not have a valid schema");
        }
        try {
            columnMetadata = schema.getFields().stream().map(field -> new PulsarColumnMetadata(PulsarColumnMetadata.getColumnName(handleKeyValueType, field.name()), this.parseJsonPrestoType(field.name(), field.schema()), field.schema().toString(), null, false, false, handleKeyValueType, new PulsarColumnMetadata.DecoderExtraInfo(field.name(), null, null))).collect(Collectors.toList());
        }
        catch (StackOverflowError e) {
            log.warn((Throwable)e, "Topic " + topicName.toString() + " extractColumnMetadata failed.");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Topic " + topicName.toString() + " schema may contains cyclic definitions.", (Throwable)e);
        }
        return columnMetadata;
    }

    private Type parseJsonPrestoType(String fieldname, Schema schema) {
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        switch (type) {
            case STRING: 
            case ENUM: {
                return VarcharType.createUnboundedVarcharType();
            }
            case NULL: {
                throw new UnsupportedOperationException(String.format("field '%s' NULL type code should not be reached \uff0cplease check the schema or report the bug.", fieldname));
            }
            case FIXED: 
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    return VarcharType.createUnboundedVarcharType();
                }
                return VarbinaryType.VARBINARY;
            }
            case INT: {
                if (logicalType == LogicalTypes.timeMillis()) {
                    return TimeType.TIME;
                }
                if (logicalType == LogicalTypes.date()) {
                    return DateType.DATE;
                }
                return IntegerType.INTEGER;
            }
            case LONG: {
                if (logicalType == LogicalTypes.timestampMillis()) {
                    return TimestampType.TIMESTAMP;
                }
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case ARRAY: {
                return new ArrayType(this.parseJsonPrestoType(fieldname, schema.getElementType()));
            }
            case MAP: {
                TypeSignature valueType = this.parseJsonPrestoType(fieldname, schema.getValueType()).getTypeSignature();
                return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
            }
            case RECORD: {
                if (schema.getFields().size() > 0) {
                    return RowType.from((List)((List)schema.getFields().stream().map(field -> new RowType.Field(Optional.of(field.name()), this.parseJsonPrestoType(field.name(), field.schema()))).collect(ImmutableList.toImmutableList())));
                }
                throw new UnsupportedOperationException(String.format("field '%s' of record type has no fields, please check schema definition. ", fieldname));
            }
            case UNION: {
                for (Schema nestType : schema.getTypes()) {
                    if (nestType.getType() == Schema.Type.NULL) continue;
                    return this.parseJsonPrestoType(fieldname, nestType);
                }
                throw new UnsupportedOperationException(String.format("field '%s' of UNION type must contains not NULL type.", fieldname));
            }
        }
        throw new UnsupportedOperationException(String.format("Can't convert from schema type '%s' (%s) to presto type.", schema.getType(), schema.getFullName()));
    }
}

