/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryMBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheDefaultEvictionPolicy;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheDisabled;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheEvictionPolicy;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheManager;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheImpl;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeEntryCacheManagerImpl
implements EntryCacheManager {
    private volatile long maxSize;
    private volatile long evictionTriggerThreshold;
    private volatile double cacheEvictionWatermark;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final ConcurrentMap<String, EntryCache> caches = Maps.newConcurrentMap();
    private final EntryCacheEvictionPolicy evictionPolicy;
    private final AtomicBoolean evictionInProgress = new AtomicBoolean(false);
    private final ManagedLedgerFactoryImpl mlFactory;
    protected final ManagedLedgerFactoryMBeanImpl mlFactoryMBean;
    protected static final double MB = 1048576.0;
    private static final double evictionTriggerThresholdPercent = 0.98;
    private static final Logger log = LoggerFactory.getLogger(RangeEntryCacheManagerImpl.class);

    public RangeEntryCacheManagerImpl(ManagedLedgerFactoryImpl factory) {
        this.maxSize = factory.getConfig().getMaxCacheSize();
        this.evictionTriggerThreshold = (long)((double)this.maxSize * 0.98);
        this.cacheEvictionWatermark = factory.getConfig().getCacheEvictionWatermark();
        this.evictionPolicy = new EntryCacheDefaultEvictionPolicy();
        this.mlFactory = factory;
        this.mlFactoryMBean = factory.getMbean();
        log.info("Initialized managed-ledger entry cache of {} Mb", (Object)((double)this.maxSize / 1048576.0));
    }

    @Override
    public EntryCache getEntryCache(ManagedLedgerImpl ml) {
        if (this.maxSize == 0L) {
            return new EntryCacheDisabled(ml);
        }
        RangeEntryCacheImpl newEntryCache = new RangeEntryCacheImpl(this, ml, this.mlFactory.getConfig().isCopyEntriesInCache());
        EntryCache currentEntryCache = this.caches.putIfAbsent(ml.getName(), newEntryCache);
        if (currentEntryCache != null) {
            return currentEntryCache;
        }
        return newEntryCache;
    }

    @Override
    public void updateCacheSizeAndThreshold(long maxSize) {
        this.maxSize = maxSize;
        this.evictionTriggerThreshold = (long)((double)maxSize * 0.98);
    }

    @Override
    public void updateCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    @Override
    public void removeEntryCache(String name) {
        EntryCache entryCache = (EntryCache)this.caches.remove(name);
        if (entryCache == null) {
            return;
        }
        long size = entryCache.getSize();
        entryCache.clear();
        if (log.isDebugEnabled()) {
            log.debug("Removed cache for {} - Size: {} -- Current Size: {}", new Object[]{name, (double)size / 1048576.0, (double)this.currentSize.get() / 1048576.0});
        }
    }

    boolean hasSpaceInCache() {
        long currentSize = this.currentSize.get();
        if (currentSize > this.evictionTriggerThreshold && this.evictionInProgress.compareAndSet(false, true)) {
            this.mlFactory.getScheduledExecutor().execute((Runnable)SafeRun.safeRun(() -> {
                long sizeToEvict = currentSize - (long)((double)this.maxSize * this.cacheEvictionWatermark);
                long startTime = System.nanoTime();
                log.info("Triggering cache eviction. total size: {} Mb -- Need to discard: {} Mb", (Object)((double)currentSize / 1048576.0), (Object)((double)sizeToEvict / 1048576.0));
                try {
                    this.evictionPolicy.doEviction(Lists.newArrayList(this.caches.values()), sizeToEvict);
                    long endTime = System.nanoTime();
                    double durationMs = (double)TimeUnit.NANOSECONDS.toMicros(endTime - startTime) / 1000.0;
                    log.info("Eviction completed. Removed {} Mb in {} ms", (Object)((double)(currentSize - this.currentSize.get()) / 1048576.0), (Object)durationMs);
                }
                finally {
                    this.mlFactoryMBean.recordCacheEviction();
                    this.evictionInProgress.set(false);
                }
            }));
        }
        return currentSize < this.maxSize;
    }

    void entryAdded(long size) {
        this.mlFactoryMBean.recordCacheInsertion();
        this.currentSize.addAndGet(size);
    }

    void entriesRemoved(long size, int count) {
        this.mlFactoryMBean.recordNumberOfCacheEntriesEvicted(count);
        this.currentSize.addAndGet(-size);
    }

    @Override
    public long getSize() {
        return this.currentSize.get();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    @Override
    public void clear() {
        this.caches.values().forEach(EntryCache::clear);
    }

    public static Entry create(long ledgerId, long entryId, ByteBuf data) {
        return EntryImpl.create(ledgerId, entryId, data);
    }

    public static EntryImpl create(LedgerEntry ledgerEntry, ManagedLedgerInterceptor interceptor) {
        ManagedLedgerInterceptor.PayloadProcessorHandle processorHandle = null;
        if (interceptor != null) {
            ByteBuf duplicateBuffer = ledgerEntry.getEntryBuffer().retainedDuplicate();
            processorHandle = interceptor.processPayloadBeforeEntryCache(duplicateBuffer);
            if (processorHandle != null) {
                ledgerEntry = LedgerEntryImpl.create((long)ledgerEntry.getLedgerId(), (long)ledgerEntry.getEntryId(), (long)ledgerEntry.getLength(), (ByteBuf)processorHandle.getProcessedPayload());
            } else {
                duplicateBuffer.release();
            }
        }
        EntryImpl returnEntry = EntryImpl.create(ledgerEntry);
        if (processorHandle != null) {
            processorHandle.release();
            ledgerEntry.close();
        }
        return returnEntry;
    }
}

