/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheEvictionPolicy;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCacheDefaultEvictionPolicy
implements EntryCacheEvictionPolicy {
    private static final double PercentOfSizeToConsiderForEviction = 0.5;
    private static final Logger log = LoggerFactory.getLogger(EntryCacheDefaultEvictionPolicy.class);

    @Override
    public void doEviction(List<EntryCache> caches, long sizeToFree) {
        long cachesToEvictTotalSize;
        EntryCache entryCache;
        Preconditions.checkArgument((sizeToFree > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((!caches.isEmpty() ? 1 : 0) != 0);
        caches.sort(Collections.reverseOrder());
        long totalSize = 0L;
        for (EntryCache cache : caches) {
            totalSize += cache.getSize();
        }
        ArrayList cachesToEvict = Lists.newArrayList();
        long sizeToConsiderForEviction = (long)((double)totalSize * 0.5);
        log.debug("Need to gather at least {} from caches", (Object)sizeToConsiderForEviction);
        int cacheIdx = 0;
        for (cachesToEvictTotalSize = 0L; cachesToEvictTotalSize < sizeToConsiderForEviction; cachesToEvictTotalSize += entryCache.getSize()) {
            Preconditions.checkArgument((cacheIdx < caches.size() ? 1 : 0) != 0);
            entryCache = caches.get(cacheIdx++);
            cachesToEvict.add(entryCache);
            log.debug("Added cache {} with size {}", (Object)entryCache.getName(), (Object)entryCache.getSize());
        }
        int evictedEntries = 0;
        long evictedSize = 0L;
        for (EntryCache entryCache2 : cachesToEvict) {
            long singleCacheSizeToFree = (long)((double)sizeToFree * ((double)entryCache2.getSize() / (double)cachesToEvictTotalSize));
            if (singleCacheSizeToFree == 0L) continue;
            Pair<Integer, Long> evicted = entryCache2.evictEntries(singleCacheSizeToFree);
            evictedEntries += ((Integer)evicted.getLeft()).intValue();
            evictedSize += ((Long)evicted.getRight()).longValue();
        }
        log.info("Completed cache eviction. Removed {} entries from {} caches. ({} Mb)", new Object[]{evictedEntries, cachesToEvict.size(), (double)evictedSize / 1048576.0});
    }
}

