/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.StampedLock;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedCursorContainer
implements Iterable<ManagedCursor> {
    private final CursorType cursorType;
    private final ArrayList<Item> heap = Lists.newArrayList();
    private final ConcurrentMap<String, Item> cursors = new ConcurrentSkipListMap<String, Item>();
    private final StampedLock rwLock = new StampedLock();

    public ManagedCursorContainer() {
        this.cursorType = CursorType.DurableCursor;
    }

    public ManagedCursorContainer(CursorType cursorType) {
        this.cursorType = cursorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ManagedCursor cursor) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = new Item(cursor, this.heap.size());
            this.cursors.put(cursor.getName(), item);
            if (this.shouldTrackInHeap(cursor)) {
                this.heap.add(item);
                this.siftUp(item);
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    private boolean shouldTrackInHeap(ManagedCursor cursor) {
        return CursorType.ALL.equals((Object)this.cursorType) || cursor.isDurable() && CursorType.DurableCursor.equals((Object)this.cursorType) || !cursor.isDurable() && CursorType.NonDurableCursor.equals((Object)this.cursorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionImpl getSlowestReadPositionForActiveCursors() {
        long stamp = this.rwLock.readLock();
        try {
            PositionImpl positionImpl = this.heap.isEmpty() ? null : (PositionImpl)this.heap.get((int)0).cursor.getReadPosition();
            return positionImpl;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionImpl getSlowestMarkDeletedPositionForActiveCursors() {
        long stamp = this.rwLock.readLock();
        try {
            PositionImpl positionImpl = this.heap.isEmpty() ? null : (PositionImpl)this.heap.get((int)0).cursor.getMarkDeletedPosition();
            return positionImpl;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedCursor get(String name) {
        long stamp = this.rwLock.readLock();
        try {
            Item item = (Item)this.cursors.get(name);
            ManagedCursor managedCursor = item != null ? item.cursor : null;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursor(String name) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.remove(name);
            if (item != null && this.shouldTrackInHeap(item.cursor)) {
                Item lastItem = this.heap.get(this.heap.size() - 1);
                this.swap(item, lastItem);
                this.heap.remove(item.idx);
                this.siftDown(lastItem);
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<PositionImpl, PositionImpl> cursorUpdated(ManagedCursor cursor, Position newPosition) {
        Preconditions.checkNotNull((Object)cursor);
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.get(cursor.getName());
            if (item == null) {
                Pair<PositionImpl, PositionImpl> pair = null;
                return pair;
            }
            if (this.shouldTrackInHeap(item.cursor)) {
                PositionImpl previousSlowestConsumer = this.heap.get((int)0).position;
                item.position = (PositionImpl)newPosition;
                if (item.idx == 0 || this.getParent((Item)item).position.compareTo(item.position) <= 0) {
                    this.siftDown(item);
                } else {
                    this.siftUp(item);
                }
                PositionImpl newSlowestConsumer = this.heap.get((int)0).position;
                Pair pair = Pair.of((Object)previousSlowestConsumer, (Object)newSlowestConsumer);
                return pair;
            }
            Pair<PositionImpl, PositionImpl> pair = null;
            return pair;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionImpl getSlowestReaderPosition() {
        long stamp = this.rwLock.readLock();
        try {
            PositionImpl positionImpl = this.heap.isEmpty() ? null : this.heap.get((int)0).position;
            return positionImpl;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedCursor getSlowestReader() {
        long stamp = this.rwLock.readLock();
        try {
            ManagedCursor managedCursor = this.heap.isEmpty() ? null : this.heap.get((int)0).cursor;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = this.cursors.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = this.cursors.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDurableCursors() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = this.heap.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = this.heap.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return !isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long stamp = this.rwLock.readLock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (Item item : this.cursors.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(item.cursor);
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    @Override
    public Iterator<ManagedCursor> iterator() {
        final Iterator it = this.cursors.entrySet().iterator();
        return new Iterator<ManagedCursor>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ManagedCursor next() {
                return ((Item)((Map.Entry)it.next()).getValue()).cursor;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Cannot remove ManagedCursor form container");
            }
        };
    }

    private void siftUp(Item item) {
        Item parent = this.getParent(item);
        while (item.idx > 0 && parent.position.compareTo(item.position) > 0) {
            this.swap(item, parent);
            parent = this.getParent(item);
        }
    }

    private void siftDown(Item item) {
        while (true) {
            Item left;
            Item j = null;
            Item right = this.getRight(item);
            if (right != null && right.position.compareTo(item.position) < 0) {
                left = this.getLeft(item);
                j = left != null && left.position.compareTo(right.position) < 0 ? left : right;
            } else {
                left = this.getLeft(item);
                if (left != null && left.position.compareTo(item.position) < 0) {
                    j = left;
                }
            }
            if (j == null) break;
            this.swap(item, j);
        }
    }

    private void swap(Item item1, Item item2) {
        int idx1 = item1.idx;
        int idx2 = item2.idx;
        this.heap.set(idx2, item1);
        this.heap.set(idx1, item2);
        item1.idx = idx2;
        item2.idx = idx1;
    }

    private Item getParent(Item item) {
        return this.heap.get((item.idx - 1) / 2);
    }

    private Item getLeft(Item item) {
        int i = item.idx * 2 + 1;
        return i < this.heap.size() ? this.heap.get(i) : null;
    }

    private Item getRight(Item item) {
        int i = item.idx * 2 + 2;
        return i < this.heap.size() ? this.heap.get(i) : null;
    }

    public static enum CursorType {
        DurableCursor,
        NonDurableCursor,
        ALL;

    }

    private static class Item {
        final ManagedCursor cursor;
        PositionImpl position;
        int idx;

        Item(ManagedCursor cursor, int idx) {
            this.cursor = cursor;
            this.position = (PositionImpl)cursor.getMarkDeletedPosition();
            this.idx = idx;
        }
    }
}

