/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface LedgerOffloader {
    public static final String METADATA_SOFTWARE_VERSION_KEY = "S3ManagedLedgerOffloaderSoftwareVersion";
    public static final String METADATA_SOFTWARE_GITSHA_KEY = "S3ManagedLedgerOffloaderSoftwareGitSha";

    public String getOffloadDriverName();

    default public Map<String, String> getOffloadDriverMetadata() {
        return Collections.emptyMap();
    }

    public CompletableFuture<Void> offload(ReadHandle var1, UUID var2, Map<String, String> var3);

    default public CompletableFuture<OffloadHandle> streamingOffload(ManagedLedger ml, UUID uid, long beginLedger, long beginEntry, Map<String, String> driverMetadata) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ReadHandle> readOffloaded(long var1, UUID var3, Map<String, String> var4);

    public CompletableFuture<Void> deleteOffloaded(long var1, UUID var3, Map<String, String> var4);

    default public CompletableFuture<ReadHandle> readOffloaded(long ledgerId, MLDataFormats.OffloadContext ledgerContext, Map<String, String> offloadDriverMetadata) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Void> deleteOffloaded(UUID uid, Map<String, String> offloadDriverMetadata) {
        throw new UnsupportedOperationException();
    }

    public OffloadPoliciesImpl getOffloadPolicies();

    public void close();

    public static interface OffloadHandle {
        public Position lastOffered();

        public CompletableFuture<Position> lastOfferedAsync();

        public OfferEntryResult offerEntry(Entry var1);

        public CompletableFuture<OfferEntryResult> offerEntryAsync(Entry var1);

        public CompletableFuture<OffloadResult> getOffloadResultAsync();

        public boolean close();

        default public CompletableFuture<Boolean> asyncClose() {
            return CompletableFuture.completedFuture(this.close());
        }

        public static enum OfferEntryResult {
            SUCCESS,
            FAIL_BUFFER_FULL,
            FAIL_SEGMENT_CLOSED,
            FAIL_NOT_CONSECUTIVE;

        }
    }

    public static class OffloadResult {
        public final long beginLedger;
        public final long beginEntry;
        public final long endLedger;
        public final long endEntry;

        public OffloadResult(long beginLedger, long beginEntry, long endLedger, long endEntry) {
            this.beginLedger = beginLedger;
            this.beginEntry = beginEntry;
            this.endLedger = endLedger;
            this.endEntry = endEntry;
        }

        public String toString() {
            return "LedgerOffloader.OffloadResult(beginLedger=" + this.beginLedger + ", beginEntry=" + this.beginEntry + ", endLedger=" + this.endLedger + ", endEntry=" + this.endEntry + ")";
        }
    }
}

