/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Strings;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AutoClusterFailoverBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.net.ServiceURI;
import org.apache.pulsar.common.util.Runnables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoClusterFailover
implements ServiceUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(AutoClusterFailover.class);
    private PulsarClientImpl pulsarClient;
    private volatile String currentPulsarServiceUrl;
    private final String primary;
    private final List<String> secondary;
    private final AutoClusterFailoverBuilder.FailoverPolicy failoverPolicy;
    private Authentication primaryAuthentication;
    private final Map<String, Authentication> secondaryAuthentications;
    private String primaryTlsTrustCertsFilePath;
    private final Map<String, String> secondaryTlsTrustCertsFilePaths;
    private String primaryTlsTrustStorePath;
    private Map<String, String> secondaryTlsTrustStorePaths;
    private String primaryTlsTrustStorePassword;
    private Map<String, String> secondaryTlsTrustStorePasswords;
    private final long failoverDelayNs;
    private final long switchBackDelayNs;
    private final ScheduledExecutorService executor;
    private long recoverTimestamp;
    private long failedTimestamp;
    private final long intervalMs;
    private static final int TIMEOUT = 30000;

    private AutoClusterFailover(AutoClusterFailoverBuilderImpl builder) {
        this.primary = builder.primary;
        this.secondary = builder.secondary;
        this.failoverPolicy = builder.failoverPolicy;
        this.secondaryAuthentications = builder.secondaryAuthentications;
        this.secondaryTlsTrustCertsFilePaths = builder.secondaryTlsTrustCertsFilePaths;
        this.secondaryTlsTrustStorePaths = builder.secondaryTlsTrustStorePaths;
        this.secondaryTlsTrustStorePasswords = builder.secondaryTlsTrustStorePasswords;
        this.failoverDelayNs = builder.failoverDelayNs;
        this.switchBackDelayNs = builder.switchBackDelayNs;
        this.currentPulsarServiceUrl = builder.primary;
        this.recoverTimestamp = -1L;
        this.failedTimestamp = -1L;
        this.intervalMs = builder.checkIntervalMs;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-service-provider"));
    }

    public void initialize(PulsarClient client) {
        this.pulsarClient = (PulsarClientImpl)client;
        ClientConfigurationData config = this.pulsarClient.getConfiguration();
        if (config != null) {
            this.primaryAuthentication = config.getAuthentication();
            this.primaryTlsTrustCertsFilePath = config.getTlsTrustCertsFilePath();
            this.primaryTlsTrustStorePath = config.getTlsTrustStorePath();
            this.primaryTlsTrustStorePassword = config.getTlsTrustStorePassword();
        }
        this.executor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(() -> {
            if (this.currentPulsarServiceUrl.equals(this.primary)) {
                this.probeAndUpdateServiceUrl(this.secondary, this.secondaryAuthentications, this.secondaryTlsTrustCertsFilePaths, this.secondaryTlsTrustStorePaths, this.secondaryTlsTrustStorePasswords);
            } else {
                this.probeAndUpdateServiceUrl(this.primary, this.primaryAuthentication, this.primaryTlsTrustCertsFilePath, this.primaryTlsTrustStorePath, this.primaryTlsTrustStorePassword);
                this.probeAndCheckSwitchBack(this.primary, this.primaryAuthentication, this.primaryTlsTrustCertsFilePath, this.primaryTlsTrustStorePath, this.primaryTlsTrustStorePassword);
            }
        }), this.intervalMs, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    public String getServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    public void close() {
        this.executor.shutdown();
    }

    boolean probeAvailable(String url) {
        try {
            URI uri = ServiceURI.create((String)url).getUri();
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(uri.getHost(), uri.getPort()), 30000);
            socket.close();
            return true;
        }
        catch (Exception e) {
            log.warn("Failed to probe available, url: {}", (Object)url, (Object)e);
            return false;
        }
    }

    private static long nanosToMillis(long nanos) {
        return Math.max(0L, Math.round((double)nanos / 1000000.0));
    }

    private void updateServiceUrl(String target, Authentication authentication, String tlsTrustCertsFilePath, String tlsTrustStorePath, String tlsTrustStorePassword) {
        try {
            if (!Strings.isNullOrEmpty((String)tlsTrustCertsFilePath)) {
                this.pulsarClient.updateTlsTrustCertsFilePath(tlsTrustCertsFilePath);
            }
            if (authentication != null) {
                this.pulsarClient.updateAuthentication(authentication);
            }
            if (!Strings.isNullOrEmpty((String)tlsTrustStorePath)) {
                this.pulsarClient.updateTlsTrustStorePathAndPassword(tlsTrustStorePath, tlsTrustStorePassword);
            }
            this.pulsarClient.updateServiceUrl(target);
            this.currentPulsarServiceUrl = target;
        }
        catch (IOException e) {
            log.error("Current Pulsar service is {}, failed to switch back to {} ", new Object[]{this.currentPulsarServiceUrl, target, e});
        }
    }

    private void probeAndUpdateServiceUrl(List<String> targetServiceUrls, Map<String, Authentication> authentications, Map<String, String> tlsTrustCertsFilePaths, Map<String, String> tlsTrustStorePaths, Map<String, String> tlsTrustStorePasswords) {
        if (this.probeAvailable(this.currentPulsarServiceUrl)) {
            this.failedTimestamp = -1L;
            return;
        }
        long currentTimestamp = System.nanoTime();
        if (this.failedTimestamp == -1L) {
            this.failedTimestamp = currentTimestamp;
        } else if (currentTimestamp - this.failedTimestamp >= this.failoverDelayNs) {
            for (String targetServiceUrl : targetServiceUrls) {
                if (this.probeAvailable(targetServiceUrl)) {
                    log.info("Current Pulsar service is {}, it has been down for {} ms, switch to the service {}. The current service down at {}", new Object[]{this.currentPulsarServiceUrl, AutoClusterFailover.nanosToMillis(currentTimestamp - this.failedTimestamp), targetServiceUrl, this.failedTimestamp});
                    this.updateServiceUrl(targetServiceUrl, authentications != null ? authentications.get(targetServiceUrl) : null, tlsTrustCertsFilePaths != null ? tlsTrustCertsFilePaths.get(targetServiceUrl) : null, tlsTrustStorePaths != null ? tlsTrustStorePaths.get(targetServiceUrl) : null, tlsTrustStorePasswords != null ? tlsTrustStorePasswords.get(targetServiceUrl) : null);
                    this.failedTimestamp = -1L;
                    break;
                }
                log.warn("Current Pulsar service is {}, it has been down for {} ms. Failed to switch to service {}, because it is not available, continue to probe next pulsar service.", new Object[]{this.currentPulsarServiceUrl, AutoClusterFailover.nanosToMillis(currentTimestamp - this.failedTimestamp), targetServiceUrl});
            }
        }
    }

    private void probeAndUpdateServiceUrl(String targetServiceUrl, Authentication authentication, String tlsTrustCertsFilePath, String tlsTrustStorePath, String tlsTrustStorePassword) {
        if (this.probeAvailable(this.currentPulsarServiceUrl)) {
            this.failedTimestamp = -1L;
            return;
        }
        long currentTimestamp = System.nanoTime();
        if (this.failedTimestamp == -1L) {
            this.failedTimestamp = currentTimestamp;
        } else if (currentTimestamp - this.failedTimestamp >= this.failoverDelayNs) {
            if (this.probeAvailable(targetServiceUrl)) {
                log.info("Current Pulsar service is {}, it has been down for {} ms, switch to the service {}. The current service down at {}", new Object[]{this.currentPulsarServiceUrl, AutoClusterFailover.nanosToMillis(currentTimestamp - this.failedTimestamp), targetServiceUrl, this.failedTimestamp});
                this.updateServiceUrl(targetServiceUrl, authentication, tlsTrustCertsFilePath, tlsTrustStorePath, tlsTrustStorePassword);
                this.failedTimestamp = -1L;
            } else {
                log.error("Current Pulsar service is {}, it has been down for {} ms. Failed to switch to service {}, because it is not available", new Object[]{this.currentPulsarServiceUrl, AutoClusterFailover.nanosToMillis(currentTimestamp - this.failedTimestamp), targetServiceUrl});
            }
        }
    }

    private void probeAndCheckSwitchBack(String target, Authentication authentication, String tlsTrustCertsFilePath, String tlsTrustStorePath, String tlsTrustStorePassword) {
        long currentTimestamp = System.nanoTime();
        if (!this.probeAvailable(target)) {
            this.recoverTimestamp = -1L;
            return;
        }
        if (this.recoverTimestamp == -1L) {
            this.recoverTimestamp = currentTimestamp;
        } else if (currentTimestamp - this.recoverTimestamp >= this.switchBackDelayNs) {
            log.info("Current Pulsar service is secondary: {}, the primary service: {} has been recover for {} ms, switch back to the primary service", new Object[]{this.currentPulsarServiceUrl, target, AutoClusterFailover.nanosToMillis(currentTimestamp - this.recoverTimestamp)});
            this.updateServiceUrl(target, authentication, tlsTrustCertsFilePath, tlsTrustStorePath, tlsTrustStorePassword);
            this.recoverTimestamp = -1L;
        }
    }

    public static AutoClusterFailoverBuilder builder() {
        return new AutoClusterFailoverBuilderImpl();
    }

    public PulsarClientImpl getPulsarClient() {
        return this.pulsarClient;
    }

    public String getCurrentPulsarServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    public String getPrimary() {
        return this.primary;
    }

    public List<String> getSecondary() {
        return this.secondary;
    }

    public AutoClusterFailoverBuilder.FailoverPolicy getFailoverPolicy() {
        return this.failoverPolicy;
    }

    public Authentication getPrimaryAuthentication() {
        return this.primaryAuthentication;
    }

    public Map<String, Authentication> getSecondaryAuthentications() {
        return this.secondaryAuthentications;
    }

    public String getPrimaryTlsTrustCertsFilePath() {
        return this.primaryTlsTrustCertsFilePath;
    }

    public Map<String, String> getSecondaryTlsTrustCertsFilePaths() {
        return this.secondaryTlsTrustCertsFilePaths;
    }

    public String getPrimaryTlsTrustStorePath() {
        return this.primaryTlsTrustStorePath;
    }

    public Map<String, String> getSecondaryTlsTrustStorePaths() {
        return this.secondaryTlsTrustStorePaths;
    }

    public String getPrimaryTlsTrustStorePassword() {
        return this.primaryTlsTrustStorePassword;
    }

    public Map<String, String> getSecondaryTlsTrustStorePasswords() {
        return this.secondaryTlsTrustStorePasswords;
    }

    public long getFailoverDelayNs() {
        return this.failoverDelayNs;
    }

    public long getSwitchBackDelayNs() {
        return this.switchBackDelayNs;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public long getRecoverTimestamp() {
        return this.recoverTimestamp;
    }

    public long getFailedTimestamp() {
        return this.failedTimestamp;
    }

    public long getIntervalMs() {
        return this.intervalMs;
    }

    public void setPulsarClient(PulsarClientImpl pulsarClient) {
        this.pulsarClient = pulsarClient;
    }

    public void setCurrentPulsarServiceUrl(String currentPulsarServiceUrl) {
        this.currentPulsarServiceUrl = currentPulsarServiceUrl;
    }

    public void setPrimaryAuthentication(Authentication primaryAuthentication) {
        this.primaryAuthentication = primaryAuthentication;
    }

    public void setPrimaryTlsTrustCertsFilePath(String primaryTlsTrustCertsFilePath) {
        this.primaryTlsTrustCertsFilePath = primaryTlsTrustCertsFilePath;
    }

    public void setPrimaryTlsTrustStorePath(String primaryTlsTrustStorePath) {
        this.primaryTlsTrustStorePath = primaryTlsTrustStorePath;
    }

    public void setSecondaryTlsTrustStorePaths(Map<String, String> secondaryTlsTrustStorePaths) {
        this.secondaryTlsTrustStorePaths = secondaryTlsTrustStorePaths;
    }

    public void setPrimaryTlsTrustStorePassword(String primaryTlsTrustStorePassword) {
        this.primaryTlsTrustStorePassword = primaryTlsTrustStorePassword;
    }

    public void setSecondaryTlsTrustStorePasswords(Map<String, String> secondaryTlsTrustStorePasswords) {
        this.secondaryTlsTrustStorePasswords = secondaryTlsTrustStorePasswords;
    }

    public void setRecoverTimestamp(long recoverTimestamp) {
        this.recoverTimestamp = recoverTimestamp;
    }

    public void setFailedTimestamp(long failedTimestamp) {
        this.failedTimestamp = failedTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoClusterFailover)) {
            return false;
        }
        AutoClusterFailover other = (AutoClusterFailover)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFailoverDelayNs() != other.getFailoverDelayNs()) {
            return false;
        }
        if (this.getSwitchBackDelayNs() != other.getSwitchBackDelayNs()) {
            return false;
        }
        if (this.getRecoverTimestamp() != other.getRecoverTimestamp()) {
            return false;
        }
        if (this.getFailedTimestamp() != other.getFailedTimestamp()) {
            return false;
        }
        if (this.getIntervalMs() != other.getIntervalMs()) {
            return false;
        }
        PulsarClientImpl this$pulsarClient = this.getPulsarClient();
        PulsarClientImpl other$pulsarClient = other.getPulsarClient();
        if (this$pulsarClient == null ? other$pulsarClient != null : !this$pulsarClient.equals(other$pulsarClient)) {
            return false;
        }
        String this$currentPulsarServiceUrl = this.getCurrentPulsarServiceUrl();
        String other$currentPulsarServiceUrl = other.getCurrentPulsarServiceUrl();
        if (this$currentPulsarServiceUrl == null ? other$currentPulsarServiceUrl != null : !this$currentPulsarServiceUrl.equals(other$currentPulsarServiceUrl)) {
            return false;
        }
        String this$primary = this.getPrimary();
        String other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !this$primary.equals(other$primary)) {
            return false;
        }
        List<String> this$secondary = this.getSecondary();
        List<String> other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        AutoClusterFailoverBuilder.FailoverPolicy this$failoverPolicy = this.getFailoverPolicy();
        AutoClusterFailoverBuilder.FailoverPolicy other$failoverPolicy = other.getFailoverPolicy();
        if (this$failoverPolicy == null ? other$failoverPolicy != null : !this$failoverPolicy.equals(other$failoverPolicy)) {
            return false;
        }
        Authentication this$primaryAuthentication = this.getPrimaryAuthentication();
        Authentication other$primaryAuthentication = other.getPrimaryAuthentication();
        if (this$primaryAuthentication == null ? other$primaryAuthentication != null : !this$primaryAuthentication.equals(other$primaryAuthentication)) {
            return false;
        }
        Map<String, Authentication> this$secondaryAuthentications = this.getSecondaryAuthentications();
        Map<String, Authentication> other$secondaryAuthentications = other.getSecondaryAuthentications();
        if (this$secondaryAuthentications == null ? other$secondaryAuthentications != null : !((Object)this$secondaryAuthentications).equals(other$secondaryAuthentications)) {
            return false;
        }
        String this$primaryTlsTrustCertsFilePath = this.getPrimaryTlsTrustCertsFilePath();
        String other$primaryTlsTrustCertsFilePath = other.getPrimaryTlsTrustCertsFilePath();
        if (this$primaryTlsTrustCertsFilePath == null ? other$primaryTlsTrustCertsFilePath != null : !this$primaryTlsTrustCertsFilePath.equals(other$primaryTlsTrustCertsFilePath)) {
            return false;
        }
        Map<String, String> this$secondaryTlsTrustCertsFilePaths = this.getSecondaryTlsTrustCertsFilePaths();
        Map<String, String> other$secondaryTlsTrustCertsFilePaths = other.getSecondaryTlsTrustCertsFilePaths();
        if (this$secondaryTlsTrustCertsFilePaths == null ? other$secondaryTlsTrustCertsFilePaths != null : !((Object)this$secondaryTlsTrustCertsFilePaths).equals(other$secondaryTlsTrustCertsFilePaths)) {
            return false;
        }
        String this$primaryTlsTrustStorePath = this.getPrimaryTlsTrustStorePath();
        String other$primaryTlsTrustStorePath = other.getPrimaryTlsTrustStorePath();
        if (this$primaryTlsTrustStorePath == null ? other$primaryTlsTrustStorePath != null : !this$primaryTlsTrustStorePath.equals(other$primaryTlsTrustStorePath)) {
            return false;
        }
        Map<String, String> this$secondaryTlsTrustStorePaths = this.getSecondaryTlsTrustStorePaths();
        Map<String, String> other$secondaryTlsTrustStorePaths = other.getSecondaryTlsTrustStorePaths();
        if (this$secondaryTlsTrustStorePaths == null ? other$secondaryTlsTrustStorePaths != null : !((Object)this$secondaryTlsTrustStorePaths).equals(other$secondaryTlsTrustStorePaths)) {
            return false;
        }
        String this$primaryTlsTrustStorePassword = this.getPrimaryTlsTrustStorePassword();
        String other$primaryTlsTrustStorePassword = other.getPrimaryTlsTrustStorePassword();
        if (this$primaryTlsTrustStorePassword == null ? other$primaryTlsTrustStorePassword != null : !this$primaryTlsTrustStorePassword.equals(other$primaryTlsTrustStorePassword)) {
            return false;
        }
        Map<String, String> this$secondaryTlsTrustStorePasswords = this.getSecondaryTlsTrustStorePasswords();
        Map<String, String> other$secondaryTlsTrustStorePasswords = other.getSecondaryTlsTrustStorePasswords();
        if (this$secondaryTlsTrustStorePasswords == null ? other$secondaryTlsTrustStorePasswords != null : !((Object)this$secondaryTlsTrustStorePasswords).equals(other$secondaryTlsTrustStorePasswords)) {
            return false;
        }
        ScheduledExecutorService this$executor = this.getExecutor();
        ScheduledExecutorService other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoClusterFailover;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $failoverDelayNs = this.getFailoverDelayNs();
        result = result * 59 + (int)($failoverDelayNs >>> 32 ^ $failoverDelayNs);
        long $switchBackDelayNs = this.getSwitchBackDelayNs();
        result = result * 59 + (int)($switchBackDelayNs >>> 32 ^ $switchBackDelayNs);
        long $recoverTimestamp = this.getRecoverTimestamp();
        result = result * 59 + (int)($recoverTimestamp >>> 32 ^ $recoverTimestamp);
        long $failedTimestamp = this.getFailedTimestamp();
        result = result * 59 + (int)($failedTimestamp >>> 32 ^ $failedTimestamp);
        long $intervalMs = this.getIntervalMs();
        result = result * 59 + (int)($intervalMs >>> 32 ^ $intervalMs);
        PulsarClientImpl $pulsarClient = this.getPulsarClient();
        result = result * 59 + ($pulsarClient == null ? 43 : $pulsarClient.hashCode());
        String $currentPulsarServiceUrl = this.getCurrentPulsarServiceUrl();
        result = result * 59 + ($currentPulsarServiceUrl == null ? 43 : $currentPulsarServiceUrl.hashCode());
        String $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : $primary.hashCode());
        List<String> $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        AutoClusterFailoverBuilder.FailoverPolicy $failoverPolicy = this.getFailoverPolicy();
        result = result * 59 + ($failoverPolicy == null ? 43 : $failoverPolicy.hashCode());
        Authentication $primaryAuthentication = this.getPrimaryAuthentication();
        result = result * 59 + ($primaryAuthentication == null ? 43 : $primaryAuthentication.hashCode());
        Map<String, Authentication> $secondaryAuthentications = this.getSecondaryAuthentications();
        result = result * 59 + ($secondaryAuthentications == null ? 43 : ((Object)$secondaryAuthentications).hashCode());
        String $primaryTlsTrustCertsFilePath = this.getPrimaryTlsTrustCertsFilePath();
        result = result * 59 + ($primaryTlsTrustCertsFilePath == null ? 43 : $primaryTlsTrustCertsFilePath.hashCode());
        Map<String, String> $secondaryTlsTrustCertsFilePaths = this.getSecondaryTlsTrustCertsFilePaths();
        result = result * 59 + ($secondaryTlsTrustCertsFilePaths == null ? 43 : ((Object)$secondaryTlsTrustCertsFilePaths).hashCode());
        String $primaryTlsTrustStorePath = this.getPrimaryTlsTrustStorePath();
        result = result * 59 + ($primaryTlsTrustStorePath == null ? 43 : $primaryTlsTrustStorePath.hashCode());
        Map<String, String> $secondaryTlsTrustStorePaths = this.getSecondaryTlsTrustStorePaths();
        result = result * 59 + ($secondaryTlsTrustStorePaths == null ? 43 : ((Object)$secondaryTlsTrustStorePaths).hashCode());
        String $primaryTlsTrustStorePassword = this.getPrimaryTlsTrustStorePassword();
        result = result * 59 + ($primaryTlsTrustStorePassword == null ? 43 : $primaryTlsTrustStorePassword.hashCode());
        Map<String, String> $secondaryTlsTrustStorePasswords = this.getSecondaryTlsTrustStorePasswords();
        result = result * 59 + ($secondaryTlsTrustStorePasswords == null ? 43 : ((Object)$secondaryTlsTrustStorePasswords).hashCode());
        ScheduledExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "AutoClusterFailover(pulsarClient=" + this.getPulsarClient() + ", currentPulsarServiceUrl=" + this.getCurrentPulsarServiceUrl() + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", failoverPolicy=" + this.getFailoverPolicy() + ", primaryAuthentication=" + this.getPrimaryAuthentication() + ", secondaryAuthentications=" + this.getSecondaryAuthentications() + ", primaryTlsTrustCertsFilePath=" + this.getPrimaryTlsTrustCertsFilePath() + ", secondaryTlsTrustCertsFilePaths=" + this.getSecondaryTlsTrustCertsFilePaths() + ", primaryTlsTrustStorePath=" + this.getPrimaryTlsTrustStorePath() + ", secondaryTlsTrustStorePaths=" + this.getSecondaryTlsTrustStorePaths() + ", primaryTlsTrustStorePassword=" + this.getPrimaryTlsTrustStorePassword() + ", secondaryTlsTrustStorePasswords=" + this.getSecondaryTlsTrustStorePasswords() + ", failoverDelayNs=" + this.getFailoverDelayNs() + ", switchBackDelayNs=" + this.getSwitchBackDelayNs() + ", executor=" + this.getExecutor() + ", recoverTimestamp=" + this.getRecoverTimestamp() + ", failedTimestamp=" + this.getFailedTimestamp() + ", intervalMs=" + this.getIntervalMs() + ")";
    }

    public static class AutoClusterFailoverBuilderImpl
    implements AutoClusterFailoverBuilder {
        private String primary;
        private List<String> secondary;
        private Map<String, Authentication> secondaryAuthentications = null;
        private Map<String, String> secondaryTlsTrustCertsFilePaths = null;
        private Map<String, String> secondaryTlsTrustStorePaths = null;
        private Map<String, String> secondaryTlsTrustStorePasswords = null;
        private AutoClusterFailoverBuilder.FailoverPolicy failoverPolicy = AutoClusterFailoverBuilder.FailoverPolicy.ORDER;
        private long failoverDelayNs;
        private long switchBackDelayNs;
        private long checkIntervalMs = 30000L;

        public AutoClusterFailoverBuilder primary(@NonNull String primary) {
            if (primary == null) {
                throw new NullPointerException("primary is marked non-null but is null");
            }
            this.primary = primary;
            return this;
        }

        public AutoClusterFailoverBuilder secondary(@NonNull List<String> secondary) {
            if (secondary == null) {
                throw new NullPointerException("secondary is marked non-null but is null");
            }
            this.secondary = secondary;
            return this;
        }

        public AutoClusterFailoverBuilder failoverPolicy(@NonNull AutoClusterFailoverBuilder.FailoverPolicy policy) {
            if (policy == null) {
                throw new NullPointerException("policy is marked non-null but is null");
            }
            this.failoverPolicy = policy;
            return this;
        }

        public AutoClusterFailoverBuilder secondaryAuthentication(Map<String, Authentication> authentication) {
            this.secondaryAuthentications = authentication;
            return this;
        }

        public AutoClusterFailoverBuilder secondaryTlsTrustCertsFilePath(Map<String, String> tlsTrustCertsFilePath) {
            this.secondaryTlsTrustCertsFilePaths = tlsTrustCertsFilePath;
            return this;
        }

        public AutoClusterFailoverBuilder secondaryTlsTrustStorePath(Map<String, String> tlsTrustStorePath) {
            this.secondaryTlsTrustStorePaths = tlsTrustStorePath;
            return this;
        }

        public AutoClusterFailoverBuilder secondaryTlsTrustStorePassword(Map<String, String> tlsTrustStorePassword) {
            this.secondaryTlsTrustStorePasswords = tlsTrustStorePassword;
            return this;
        }

        public AutoClusterFailoverBuilder failoverDelay(long failoverDelay, TimeUnit timeUnit) {
            this.failoverDelayNs = timeUnit.toNanos(failoverDelay);
            return this;
        }

        public AutoClusterFailoverBuilder switchBackDelay(long switchBackDelay, TimeUnit timeUnit) {
            this.switchBackDelayNs = timeUnit.toNanos(switchBackDelay);
            return this;
        }

        public AutoClusterFailoverBuilder checkInterval(long interval, TimeUnit timeUnit) {
            this.checkIntervalMs = timeUnit.toMillis(interval);
            return this;
        }

        public ServiceUrlProvider build() {
            Objects.requireNonNull(this.primary, "primary service url shouldn't be null");
            AutoClusterFailoverBuilderImpl.checkArgument(this.secondary != null && this.secondary.size() > 0, "secondary cluster service url shouldn't be null and should set at least one");
            AutoClusterFailoverBuilderImpl.checkArgument(this.failoverDelayNs > 0L, "failoverDelay should > 0");
            AutoClusterFailoverBuilderImpl.checkArgument(this.switchBackDelayNs > 0L, "switchBackDelay should > 0");
            AutoClusterFailoverBuilderImpl.checkArgument(this.checkIntervalMs > 0L, "checkInterval should > 0");
            int secondarySize = this.secondary.size();
            AutoClusterFailoverBuilderImpl.checkArgument(this.secondaryAuthentications == null || this.secondaryAuthentications.size() == secondarySize, "secondaryAuthentication should be null or size equal with secondary url size");
            AutoClusterFailoverBuilderImpl.checkArgument(this.secondaryTlsTrustCertsFilePaths == null || this.secondaryTlsTrustCertsFilePaths.size() == secondarySize, "secondaryTlsTrustCertsFilePath should be null or size equal with secondary url size");
            AutoClusterFailoverBuilderImpl.checkArgument(this.secondaryTlsTrustStorePaths == null || this.secondaryTlsTrustStorePaths.size() == secondarySize, "secondaryTlsTrustStorePath should be null or size equal with secondary url size");
            AutoClusterFailoverBuilderImpl.checkArgument(this.secondaryTlsTrustStorePasswords == null || this.secondaryTlsTrustStorePasswords.size() == secondarySize, "secondaryTlsTrustStorePassword should be null or size equal with secondary url size");
            return new AutoClusterFailover(this);
        }

        public static void checkArgument(boolean expression, @NonNull Object errorMessage) {
            if (errorMessage == null) {
                throw new NullPointerException("errorMessage is marked non-null but is null");
            }
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }
}

