/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Lists;
import io.netty.util.Recycler;
import java.util.List;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpReadEntry
implements AsyncCallbacks.ReadEntriesCallback {
    ManagedCursorImpl cursor;
    PositionImpl readPosition;
    private int count;
    private AsyncCallbacks.ReadEntriesCallback callback;
    Object ctx;
    private List<Entry> entries;
    private PositionImpl nextReadPosition;
    PositionImpl maxPosition;
    private final Recycler.Handle<OpReadEntry> recyclerHandle;
    private static final Recycler<OpReadEntry> RECYCLER = new Recycler<OpReadEntry>(){

        protected OpReadEntry newObject(Recycler.Handle<OpReadEntry> recyclerHandle) {
            return new OpReadEntry(recyclerHandle);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OpReadEntry.class);

    public static OpReadEntry create(ManagedCursorImpl cursor, PositionImpl readPositionRef, int count, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        OpReadEntry op = (OpReadEntry)RECYCLER.get();
        op.readPosition = cursor.ledger.startReadOperationOnLedger(readPositionRef, op);
        op.cursor = cursor;
        op.count = count;
        op.callback = callback;
        op.entries = Lists.newArrayList();
        if (maxPosition == null) {
            maxPosition = PositionImpl.LATEST;
        }
        op.maxPosition = maxPosition;
        op.ctx = ctx;
        op.nextReadPosition = PositionImpl.get(op.readPosition);
        return op;
    }

    @Override
    public void readEntriesComplete(List<Entry> returnedEntries, Object ctx) {
        int entriesCount = returnedEntries.size();
        long entriesSize = 0L;
        for (int i = 0; i < entriesCount; ++i) {
            entriesSize += (long)returnedEntries.get(i).getLength();
        }
        this.cursor.updateReadStats(entriesCount, entriesSize);
        PositionImpl lastPosition = (PositionImpl)returnedEntries.get(entriesCount - 1).getPosition();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Read entries succeeded batch_size={} cumulative_size={} requested_count={}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), returnedEntries.size(), this.entries.size(), this.count});
        }
        List<Entry> filteredEntries = this.cursor.filterReadEntries(returnedEntries);
        this.entries.addAll(filteredEntries);
        PositionImpl nexReadPosition = entriesCount != filteredEntries.size() ? this.cursor.getNextAvailablePosition(lastPosition) : lastPosition.getNext();
        this.updateReadPosition(nexReadPosition);
        this.checkReadCompletion();
    }

    @Override
    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.cursor.readOperationCompleted();
        if (!this.entries.isEmpty()) {
            this.cursor.ledger.getExecutor().execute((Runnable)SafeRun.safeRun(() -> {
                this.callback.readEntriesComplete(this.entries, ctx);
                this.recycle();
            }));
        } else if (this.cursor.config.isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception.getMessage()});
            Position nexReadPosition = this.cursor.getNextLedgerPosition(this.readPosition.getLedgerId());
            if (nexReadPosition == null) {
                this.callback.readEntriesFailed(exception, ctx);
                this.cursor.ledger.mbean.recordReadEntriesError();
                this.recycle();
                return;
            }
            this.updateReadPosition(nexReadPosition);
            this.checkReadCompletion();
        } else {
            if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
                log.warn("[{}][{}] read failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception});
            } else if (log.isDebugEnabled()) {
                log.debug("[{}][{}] read throttled failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition});
            }
            this.callback.readEntriesFailed(exception, ctx);
            this.cursor.ledger.mbean.recordReadEntriesError();
            this.recycle();
        }
    }

    void updateReadPosition(Position newReadPosition) {
        this.nextReadPosition = (PositionImpl)newReadPosition;
        this.cursor.setReadPosition(this.nextReadPosition);
    }

    void checkReadCompletion() {
        if (this.entries.size() < this.count && this.cursor.hasMoreEntries() && ((PositionImpl)this.cursor.getReadPosition()).compareTo(this.maxPosition) < 0) {
            if (this.nextReadPosition.getLedgerId() != this.readPosition.getLedgerId()) {
                this.cursor.ledger.startReadOperationOnLedger(this.nextReadPosition, this);
            }
            this.cursor.ledger.getExecutor().execute((Runnable)SafeRun.safeRun(() -> {
                this.readPosition = this.cursor.ledger.startReadOperationOnLedger(this.nextReadPosition, this);
                this.cursor.ledger.asyncReadEntries(this);
            }));
        } else {
            try {
                this.cursor.readOperationCompleted();
            }
            finally {
                this.cursor.ledger.getExecutor().executeOrdered((Object)this.cursor.ledger.getName(), (SafeRunnable)SafeRun.safeRun(() -> {
                    this.callback.readEntriesComplete(this.entries, this.ctx);
                    this.recycle();
                }));
            }
        }
    }

    public int getNumberOfEntriesToRead() {
        return this.count - this.entries.size();
    }

    public boolean isSlowestReader() {
        return this.cursor.ledger.getSlowestConsumer() == this.cursor;
    }

    private OpReadEntry(Recycler.Handle<OpReadEntry> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.cursor = null;
        this.readPosition = null;
        this.callback = null;
        this.ctx = null;
        this.entries = null;
        this.nextReadPosition = null;
        this.maxPosition = null;
        this.recyclerHandle.recycle((Object)this);
    }
}

