/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.DecoderErrorCode;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class PulsarAvroColumnDecoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object[])new Type[]{DoubleType.DOUBLE, TimestampType.TIMESTAMP, DateType.DATE, TimeType.TIME, VarbinaryType.VARBINARY});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;

    public PulsarAvroColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)this.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private boolean isSupportedType(Type type) {
        if (this.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            Preconditions.checkArgument((boolean)(typeParameters.get(0) instanceof VarcharType), (String)"Unsupported column type '%s' for map key", typeParameters.get(0));
            return this.isSupportedType((Type)type.getTypeParameters().get(1));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (this.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isSupportedPrimitive(Type type) {
        return type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(GenericRecord avroRecord) {
        Object avroColumnValue = PulsarAvroColumnDecoder.locateNode(avroRecord, this.columnMapping);
        return new ObjectValueProvider(avroColumnValue, this.columnType, this.columnName);
    }

    private static Object locateNode(GenericRecord element, String columnMapping) {
        Object value = element;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (value == null) {
                return null;
            }
            value = value.get(pathElement);
        }
        return value;
    }

    private static Slice getSlice(Object value, Type type, String columnName) {
        if (type instanceof VarcharType && (value instanceof CharSequence || value instanceof GenericEnumSymbol)) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
        }
        if (type instanceof VarbinaryType) {
            if (value instanceof ByteBuffer) {
                return Slices.wrappedBuffer((ByteBuffer)((ByteBuffer)value));
            }
            if (value instanceof GenericFixed) {
                return Slices.wrappedBuffer((byte[])((GenericFixed)value).bytes());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Block serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        if (type instanceof ArrayType) {
            return PulsarAvroColumnDecoder.serializeList(builder, value, type, columnName);
        }
        if (type instanceof MapType) {
            return PulsarAvroColumnDecoder.serializeMap(builder, value, type, columnName);
        }
        if (type instanceof RowType) {
            return PulsarAvroColumnDecoder.serializeRow(builder, value, type, columnName);
        }
        PulsarAvroColumnDecoder.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    private static Block serializeList(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            PulsarAvroColumnDecoder.serializeObject(blockBuilder, element, elementType, columnName);
        }
        if (parentBlockBuilder != null) {
            type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
            return null;
        }
        return blockBuilder.build();
    }

    private static void serializePrimitive(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof BooleanType) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            return;
        }
        if ((value instanceof Integer || value instanceof Long) && (type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
            return;
        }
        if (type instanceof DoubleType) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
            return;
        }
        if (type instanceof RealType) {
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
            return;
        }
        if (type instanceof VarcharType || type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, PulsarAvroColumnDecoder.getSlice(value, type, columnName));
            return;
        }
        if (type instanceof TimestampType) {
            type.writeLong(blockBuilder, ((Long)value).longValue());
            return;
        }
        throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Block serializeMap(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        Map map = (Map)value;
        List typeParameters = type.getTypeParameters();
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            keyType.writeSlice(entryBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)entry.getKey().toString()), (Type)keyType));
            PulsarAvroColumnDecoder.serializeObject(entryBuilder, entry.getValue(), valueType, columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    private static Block serializeRow(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parent block builder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder singleRowBuilder = blockBuilder.beginBlockEntry();
        GenericRecord record = (GenericRecord)value;
        List fields = ((RowType)type).getFields();
        for (RowType.Field field : fields) {
            Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
            PulsarAvroColumnDecoder.serializeObject(singleRowBuilder, record.get((String)field.getName().get()), field.getType(), columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    private static class ObjectValueProvider
    extends FieldValueProvider {
        private final Object value;
        private final Type columnType;
        private final String columnName;

        public ObjectValueProvider(Object value, Type columnType, String columnName) {
            this.value = value;
            this.columnType = columnType;
            this.columnName = columnName;
        }

        public boolean isNull() {
            return this.value == null;
        }

        public double getDouble() {
            if (this.value instanceof Double || this.value instanceof Float) {
                return ((Number)this.value).doubleValue();
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public boolean getBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public long getLong() {
            if (this.value instanceof Long || this.value instanceof Integer) {
                return ((Number)this.value).longValue();
            }
            if (this.columnType instanceof RealType) {
                return Float.floatToIntBits(((Float)this.value).floatValue());
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public Slice getSlice() {
            return PulsarAvroColumnDecoder.getSlice(this.value, this.columnType, this.columnName);
        }

        public Block getBlock() {
            return PulsarAvroColumnDecoder.serializeObject(null, this.value, this.columnType, this.columnName);
        }
    }
}

