/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core.common;

import java.util.HashMap;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageMetadataUtil;
import org.apache.pulsar.packages.management.core.exceptions.PackagesManagementException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PackageMetadataSerdeTest {
    @Test
    public void testPackageMetadataSerDe() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("testKey", "testValue");
        PackageMetadata metadata = PackageMetadata.builder().description("test package metadata serialize and deserialize flow").createTime(System.currentTimeMillis()).contact("test@apache.org").modificationTime(System.currentTimeMillis() + 1000L).properties(properties).build();
        byte[] metadataSerialized = PackageMetadataUtil.toBytes((PackageMetadata)metadata);
        try {
            PackageMetadata deSerializedMetadata = PackageMetadataUtil.fromBytes((byte[])metadataSerialized);
            Assert.assertEquals((Object)metadata, (Object)deSerializedMetadata);
        }
        catch (PackagesManagementException.MetadataFormatException e) {
            Assert.fail((String)"should not throw any exception");
        }
        try {
            byte[] failedMetadataSerialized = "wrong package metadata".getBytes();
            PackageMetadata deSerializedMetadata = PackageMetadataUtil.fromBytes((byte[])failedMetadataSerialized);
            Assert.fail((String)"should throw the metadata format exception");
        }
        catch (PackagesManagementException.MetadataFormatException metadataFormatException) {
            // empty catch block
        }
    }
}

