/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.PackagesStorageConfiguration;

public class MockedPackagesStorage
implements PackagesStorage {
    private PackagesStorageConfiguration configuration;
    private ConcurrentHashMap<String, byte[]> storage = new ConcurrentHashMap();

    MockedPackagesStorage(PackagesStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize() {
    }

    public CompletableFuture<Void> writeAsync(String path, InputStream inputStream) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            try {
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                this.storage.put(path, bytes);
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> readAsync(String path, OutputStream outputStream) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            byte[] bytes = this.storage.get(path);
            if (bytes == null) {
                future.completeExceptionally(new Exception(String.format("Path '%s' does not exist", path)));
                return;
            }
            try {
                outputStream.write(bytes);
                outputStream.flush();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> deleteAsync(String path) {
        this.storage.remove(path);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<String>> listAsync(String path) {
        return CompletableFuture.completedFuture(this.storage.keySet().stream().filter(s -> s.startsWith(path)).map(s -> s.substring(path.length())).map(s -> s.split("/")[1]).distinct().collect(Collectors.toList()));
    }

    public CompletableFuture<Boolean> existAsync(String path) {
        return CompletableFuture.completedFuture(this.storage.keySet().stream().filter(s -> s.startsWith(path)).collect(Collectors.toList())).thenApply(paths -> !paths.isEmpty());
    }

    public CompletableFuture<Void> closeAsync() {
        this.storage.clear();
        return CompletableFuture.completedFuture(null);
    }
}

