/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core.common;

import org.apache.pulsar.packages.management.core.common.PackageName;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PackageNameTest {
    @DataProvider(name="packageNames")
    public static Object[][] packageNamesProvider() {
        return new Object[][]{{"function", "f-tenant", "f-ns", "f-name", "f-version"}, {"sink", "s-tenant", "s-ns", "s-name", "s-version"}, {"source", "s-tenant", "s-ns", "s-name", "s-version"}};
    }

    @Test(dataProvider="packageNames")
    public void testPartName(String type, String tenant, String ns, String name, String version) {
        PackageName packageName = PackageName.get((String)type, (String)tenant, (String)ns, (String)name, (String)version);
        Assert.assertEquals((String)packageName.getPkgType().toString(), (String)type);
        Assert.assertEquals((String)packageName.getTenant(), (String)tenant);
        Assert.assertEquals((String)packageName.getNamespace(), (String)ns);
        Assert.assertEquals((String)packageName.getName(), (String)name);
        Assert.assertEquals((String)packageName.getVersion(), (String)version);
        Assert.assertEquals((String)packageName.toString(), (String)(type + "://" + tenant + "/" + ns + "/" + name + "@" + version));
        String longName = tenant + "/" + ns + "/" + name;
        PackageName packageName1 = PackageName.get((String)type, (String)longName, (String)version);
        Assert.assertEquals((String)packageName1.getPkgType().toString(), (String)type);
        Assert.assertEquals((String)packageName.getTenant(), (String)tenant);
        Assert.assertEquals((String)packageName.getNamespace(), (String)ns);
        Assert.assertEquals((String)packageName1.getName(), (String)name);
        Assert.assertEquals((String)packageName1.getVersion(), (String)version);
        Assert.assertEquals((String)packageName1.toString(), (String)(type + "://" + tenant + "/" + ns + "/" + name + "@" + version));
        String fullName = type + "://" + tenant + "/" + ns + "/" + name + "@" + version;
        PackageName packageName2 = PackageName.get((String)fullName);
        Assert.assertEquals((String)packageName2.getPkgType().toString(), (String)type);
        Assert.assertEquals((String)packageName.getTenant(), (String)tenant);
        Assert.assertEquals((String)packageName.getNamespace(), (String)ns);
        Assert.assertEquals((String)packageName2.getName(), (String)name);
        Assert.assertEquals((String)packageName2.getVersion(), (String)version);
        Assert.assertEquals((String)packageName2.toString(), (String)(type + "://" + tenant + "/" + ns + "/" + name + "@" + version));
    }

    @Test
    public void testPackageNameErrors() {
        try {
            PackageName.get((String)"function:///public/default/test-error@v1");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"functions", (String)"public", (String)"default", (String)"test-error", (String)"v1");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"functions://public/default/test-error@v1");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"function", (String)"public/default", (String)"default", (String)"test-error", (String)"v1");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"function", (String)"public/default/name@v1", (String)"");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"function://public/default/name#v1");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            PackageName.get((String)"function://public/default/test-error-version/v2");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        PackageName name = PackageName.get((String)"function://public/default/test");
        Assert.assertEquals((String)"function://public/default/test@latest", (String)name.toString());
    }
}

