/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.packages.management.core.MockedPackagesStorageProvider;
import org.apache.pulsar.packages.management.core.PackagesManagement;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.PackagesStorageConfiguration;
import org.apache.pulsar.packages.management.core.PackagesStorageProvider;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.apache.pulsar.packages.management.core.common.PackageName;
import org.apache.pulsar.packages.management.core.exceptions.PackagesManagementException;
import org.apache.pulsar.packages.management.core.impl.DefaultPackagesStorageConfiguration;
import org.apache.pulsar.packages.management.core.impl.PackagesManagementImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PackagesManagementImplTest {
    private static PackagesStorage storage;
    private static PackagesManagement packagesManagement;

    @BeforeClass
    public static void setup() throws IOException {
        PackagesStorageProvider storageProvider = PackagesStorageProvider.newProvider((String)MockedPackagesStorageProvider.class.getName());
        DefaultPackagesStorageConfiguration packagesStorageConfiguration = new DefaultPackagesStorageConfiguration();
        storage = storageProvider.getStorage((PackagesStorageConfiguration)packagesStorageConfiguration);
        packagesManagement = new PackagesManagementImpl();
        packagesManagement.initialize(storage);
    }

    @AfterClass(alwaysRun=true)
    public static void teardown() throws ExecutionException, InterruptedException {
        storage.closeAsync().get();
    }

    @Test
    public void testPackagesManagementFlow() {
        PackageName packageName;
        block74: {
            block73: {
                PackageMetadata metadata;
                block72: {
                    Throwable throwable;
                    block69: {
                        block68: {
                            block67: {
                                block66: {
                                    block65: {
                                        block64: {
                                            packageName = PackageName.get((String)"function://tenant/ns/non-existent-package@v1");
                                            try {
                                                packagesManagement.getMeta(packageName).get();
                                            }
                                            catch (Exception e) {
                                                if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block64;
                                                Assert.fail((String)"should not throw any exception");
                                            }
                                        }
                                        PackageMetadata failedUpdateMetadata = PackageMetadata.builder().description("Failed update package metadata").build();
                                        try {
                                            packagesManagement.updateMeta(packageName, failedUpdateMetadata).get();
                                        }
                                        catch (Exception e) {
                                            if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block65;
                                            Assert.fail((String)"should not throw any exception");
                                        }
                                    }
                                    try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                                        packagesManagement.download(packageName, (OutputStream)outputStream).get();
                                    }
                                    catch (Exception e) {
                                        if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block66;
                                        Assert.fail((String)"should not throw any exception");
                                    }
                                }
                                try {
                                    packagesManagement.delete(packageName).get();
                                }
                                catch (Exception e) {
                                    if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block67;
                                    Assert.fail((String)"should not throw any exception");
                                }
                            }
                            try {
                                packagesManagement.list(packageName).get();
                            }
                            catch (Exception e) {
                                if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block68;
                                Assert.fail((String)"should not throw any exception");
                            }
                        }
                        try {
                            packagesManagement.list(packageName.getPkgType(), packageName.getTenant(), packageName.getNamespace()).get();
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block69;
                            Assert.fail((String)"should not throw any exception");
                        }
                    }
                    metadata = PackageMetadata.builder().contact("test@apache.org").description("A mocked test package").createTime(System.currentTimeMillis()).build();
                    try {
                        throwable = null;
                        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(metadata.toBytes());){
                            packagesManagement.upload(packageName, metadata, (InputStream)inputStream).get();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)"should not throw any exception");
                    }
                    try {
                        PackageMetadata getPackageMetadata = (PackageMetadata)packagesManagement.getMeta(packageName).get();
                        Assert.assertEquals((Object)metadata, (Object)getPackageMetadata);
                    }
                    catch (Exception e) {
                        Assert.fail((String)"should not throw any exception");
                    }
                    try {
                        throwable = null;
                        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                            packagesManagement.download(packageName, (OutputStream)outputStream).get();
                            PackageMetadata getPackage = PackageMetadata.fromBytes((byte[])outputStream.toByteArray());
                            Assert.assertEquals((Object)metadata, (Object)getPackage);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)"should not throw any exception");
                    }
                    metadata.setModificationTime(System.currentTimeMillis());
                    try {
                        packagesManagement.updateMeta(packageName, metadata).get();
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block72;
                        Assert.fail((String)"should not throw any exception");
                    }
                }
                try {
                    PackageMetadata updatedMetadata = (PackageMetadata)packagesManagement.getMeta(packageName).get();
                    Assert.assertEquals((Object)metadata, (Object)updatedMetadata);
                }
                catch (Exception e) {
                    Assert.fail((String)"should not throw any exception");
                }
                try {
                    List versions = (List)packagesManagement.list(packageName).get();
                    Assert.assertEquals((int)1, (int)versions.size());
                    Assert.assertEquals((String)packageName.getVersion(), (String)((String)versions.get(0)));
                }
                catch (Exception e) {
                    if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block73;
                    Assert.fail((String)"should not throw any exception");
                }
            }
            try {
                List packageNames = (List)packagesManagement.list(packageName.getPkgType(), packageName.getTenant(), packageName.getNamespace()).get();
                Assert.assertEquals((int)1, (int)packageNames.size());
                Assert.assertEquals((String)packageName.getName(), (String)((String)packageNames.get(0)));
            }
            catch (Exception e) {
                if (e.getCause() instanceof PackagesManagementException.NotFoundException) break block74;
                Assert.fail((String)"should not throw any exception");
            }
        }
        try {
            packagesManagement.delete(packageName).get();
        }
        catch (Exception e) {
            Assert.fail((String)"should not throw any exception");
        }
    }
}

