/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationClient;
import org.apache.pulsar.metadata.bookkeeper.PulsarRegistrationManager;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class PulsarRegistrationClientTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarRegistrationClientTest.class);

    private static Set<BookieId> prepareNBookies(int num) {
        HashSet<BookieId> bookies = new HashSet<BookieId>();
        for (int i = 0; i < num; ++i) {
            bookies.add(new BookieSocketAddress("127.0.0.1", 3181 + i).toBookieId());
        }
        return bookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetWritableBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String ledgersRoot = "/test/ledgers-" + UUID.randomUUID();
            PulsarRegistrationManager rm = new PulsarRegistrationManager(store, ledgersRoot, (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class));
            try {
                PulsarRegistrationClient rc = new PulsarRegistrationClient((MetadataStore)store, ledgersRoot);
                try {
                    Set<BookieId> addresses = PulsarRegistrationClientTest.prepareNBookies(10);
                    ArrayList<String> children = new ArrayList<String>();
                    for (BookieId address : addresses) {
                        children.add(address.toString());
                        rm.registerBookie(address, false, new BookieServiceInfo());
                    }
                    Versioned result = (Versioned)FutureUtils.result((CompletableFuture)rc.getWritableBookies());
                    Assert.assertEquals((long)addresses.size(), (long)((Set)result.getValue()).size());
                }
                finally {
                    if (Collections.singletonList(rc).get(0) != null) {
                        rc.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rm).get(0) != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetReadonlyBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String ledgersRoot = "/test/ledgers-" + UUID.randomUUID();
            PulsarRegistrationManager rm = new PulsarRegistrationManager(store, ledgersRoot, (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class));
            try {
                PulsarRegistrationClient rc = new PulsarRegistrationClient((MetadataStore)store, ledgersRoot);
                try {
                    Set<BookieId> addresses = PulsarRegistrationClientTest.prepareNBookies(10);
                    ArrayList<String> children = new ArrayList<String>();
                    for (BookieId address : addresses) {
                        children.add(address.toString());
                        rm.registerBookie(address, true, new BookieServiceInfo());
                    }
                    Versioned result = (Versioned)FutureUtils.result((CompletableFuture)rc.getReadOnlyBookies());
                    Assert.assertEquals((long)addresses.size(), (long)((Set)result.getValue()).size());
                }
                finally {
                    if (Collections.singletonList(rc).get(0) != null) {
                        rc.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rm).get(0) != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetBookieServiceInfo(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String ledgersRoot = "/test/ledgers-" + UUID.randomUUID();
            PulsarRegistrationManager rm = new PulsarRegistrationManager(store, ledgersRoot, (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class));
            try {
                PulsarRegistrationClient rc = new PulsarRegistrationClient((MetadataStore)store, ledgersRoot);
                try {
                    ArrayList<BookieId> addresses = new ArrayList<BookieId>(PulsarRegistrationClientTest.prepareNBookies(10));
                    ArrayList<BookieServiceInfo> bookieServiceInfos = new ArrayList<BookieServiceInfo>();
                    int port = 223;
                    for (BookieId address : addresses) {
                        BookieServiceInfo info = new BookieServiceInfo();
                        BookieServiceInfo.Endpoint endpoint = new BookieServiceInfo.Endpoint();
                        endpoint.setAuth(Collections.emptyList());
                        endpoint.setExtensions(Collections.emptyList());
                        endpoint.setId("id");
                        endpoint.setHost("localhost");
                        endpoint.setPort(port++);
                        endpoint.setProtocol("bookie-rpc");
                        info.setEndpoints(Arrays.asList(endpoint));
                        bookieServiceInfos.add(info);
                        boolean readOnly = port % 2 == 0;
                        rm.registerBookie(address, readOnly, info);
                    }
                    rc.getAllBookies().join();
                    int i = 0;
                    for (BookieId address : addresses) {
                        BookieServiceInfo bookieServiceInfo = (BookieServiceInfo)((Versioned)rc.getBookieServiceInfo(address).get()).getValue();
                        this.compareBookieServiceInfo(bookieServiceInfo, (BookieServiceInfo)bookieServiceInfos.get(i++));
                    }
                }
                finally {
                    if (Collections.singletonList(rc).get(0) != null) {
                        rc.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rm).get(0) != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    private void compareBookieServiceInfo(BookieServiceInfo a, BookieServiceInfo b) {
        Assert.assertEquals((Object)a.getProperties(), (Object)b.getProperties());
        Assert.assertEquals((long)a.getEndpoints().size(), (long)b.getEndpoints().size());
        for (int i = 0; i < a.getEndpoints().size(); ++i) {
            BookieServiceInfo.Endpoint e1 = (BookieServiceInfo.Endpoint)a.getEndpoints().get(i);
            BookieServiceInfo.Endpoint e2 = (BookieServiceInfo.Endpoint)b.getEndpoints().get(i);
            Assert.assertEquals((Object)e1.getHost(), (Object)e2.getHost());
            Assert.assertEquals((long)e1.getPort(), (long)e2.getPort());
            Assert.assertEquals((Object)e1.getId(), (Object)e2.getId());
            Assert.assertEquals((Object)e1.getProtocol(), (Object)e2.getProtocol());
            Assert.assertEquals((Object)e1.getExtensions(), (Object)e2.getExtensions());
            Assert.assertEquals((Object)e1.getAuth(), (Object)e2.getAuth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetAllBookies(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String ledgersRoot = "/test/ledgers-" + UUID.randomUUID();
            PulsarRegistrationManager rm = new PulsarRegistrationManager(store, ledgersRoot, (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class));
            try {
                PulsarRegistrationClient rc = new PulsarRegistrationClient((MetadataStore)store, ledgersRoot);
                try {
                    Set<BookieId> addresses = PulsarRegistrationClientTest.prepareNBookies(10);
                    ArrayList<String> children = new ArrayList<String>();
                    for (BookieId address : addresses) {
                        children.add(address.toString());
                        boolean isReadOnly = children.size() % 2 == 0;
                        rm.registerBookie(address, isReadOnly, new BookieServiceInfo());
                    }
                    Versioned result = (Versioned)FutureUtils.result((CompletableFuture)rc.getAllBookies());
                    Assert.assertEquals((long)addresses.size(), (long)((Set)result.getValue()).size());
                }
                finally {
                    if (Collections.singletonList(rc).get(0) != null) {
                        rc.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rm).get(0) != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    @Test(dataProvider="impl")
    public void testWatchWritableBookiesSuccess(String provider, Supplier<String> urlSupplier) throws Exception {
        this.testWatchBookiesSuccess(provider, urlSupplier, true);
    }

    @Test(dataProvider="impl")
    public void testWatchReadonlyBookiesSuccess(String provider, Supplier<String> urlSupplier) throws Exception {
        this.testWatchBookiesSuccess(provider, urlSupplier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWatchBookiesSuccess(String provider, Supplier<String> urlSupplier, boolean isWritable) throws Exception {
        MetadataStoreExtended store = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String ledgersRoot = "/test/ledgers-" + UUID.randomUUID();
            PulsarRegistrationManager rm = new PulsarRegistrationManager(store, ledgersRoot, (AbstractConfiguration)Mockito.mock(AbstractConfiguration.class));
            try {
                PulsarRegistrationClient rc = new PulsarRegistrationClient((MetadataStore)store, ledgersRoot);
                try {
                    ConcurrentLinkedQueue updates = new ConcurrentLinkedQueue();
                    ConcurrentHashMap bookies = new ConcurrentHashMap();
                    RegistrationClient.RegistrationListener listener = b -> {
                        updates.add(b);
                        ((Set)b.getValue()).forEach(x -> bookies.put(x, true));
                    };
                    int BOOKIES = 10;
                    Set<BookieId> addresses = PulsarRegistrationClientTest.prepareNBookies(BOOKIES);
                    if (isWritable) {
                        FutureUtils.result((CompletableFuture)rc.watchWritableBookies(listener));
                    } else {
                        FutureUtils.result((CompletableFuture)rc.watchReadOnlyBookies(listener));
                    }
                    for (BookieId address : addresses) {
                        rm.registerBookie(address, !isWritable, new BookieServiceInfo());
                    }
                    Awaitility.await().untilAsserted(() -> {
                        Assert.assertFalse((boolean)updates.isEmpty());
                        Assert.assertEquals((long)BOOKIES, (long)bookies.size());
                    });
                }
                finally {
                    if (Collections.singletonList(rc).get(0) != null) {
                        rc.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(rm).get(0) != null) {
                    rm.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

