/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerAuditorManager;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class PulsarLedgerAuditorManagerTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(PulsarLedgerAuditorManagerTest.class);
    private static final int managerVersion = 43981;
    private MetadataStoreExtended store1;
    private MetadataStoreExtended store2;
    private String ledgersRootPath;

    private void methodSetup(Supplier<String> urlSupplier) throws Exception {
        this.ledgersRootPath = "/ledgers-" + UUID.randomUUID();
        this.store1 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.store2 = MetadataStoreExtended.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
    }

    @AfterMethod(alwaysRun=true)
    public final void methodCleanup() throws Exception {
        if (this.store1 != null) {
            this.store1.close();
            this.store1 = null;
        }
        if (this.store2 != null) {
            this.store2.close();
            this.store2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testSimple(String provider, Supplier<String> urlSupplier) throws Exception {
        if (provider.equals("Memory") || provider.equals("RocksDB")) {
            return;
        }
        this.methodSetup(urlSupplier);
        PulsarLedgerAuditorManager lam1 = new PulsarLedgerAuditorManager(this.store1, this.ledgersRootPath);
        Assert.assertNull((Object)lam1.getCurrentAuditor());
        lam1.tryToBecomeAuditor("bookie-1:3181", auditorEvent -> log.info("---- LAM-1 - Received auditor event: {}", auditorEvent));
        Assert.assertEquals((Object)BookieId.parse((String)"bookie-1:3181"), (Object)lam1.getCurrentAuditor());
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            PulsarLedgerAuditorManager lam2 = new PulsarLedgerAuditorManager(this.store2, this.ledgersRootPath);
            Assert.assertEquals((Object)BookieId.parse((String)"bookie-1:3181"), (Object)lam2.getCurrentAuditor());
            CountDownLatch latch = new CountDownLatch(1);
            executor.execute(() -> PulsarLedgerAuditorManagerTest.lambda$testSimple$2((LedgerAuditorManager)lam2, latch));
            Assert.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)BookieId.parse((String)"bookie-1:3181"), (Object)lam1.getCurrentAuditor());
            Assert.assertEquals((Object)BookieId.parse((String)"bookie-1:3181"), (Object)lam2.getCurrentAuditor());
            lam1.close();
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)BookieId.parse((String)"bookie-2:3181"), (Object)lam2.getCurrentAuditor());
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    private static /* synthetic */ void lambda$testSimple$2(LedgerAuditorManager lam2, CountDownLatch latch) {
        try {
            lam2.tryToBecomeAuditor("bookie-2:3181", auditorEvent -> log.info("---- LAM-2 - Received auditor event: {}", auditorEvent));
            latch.countDown();
        }
        catch (Exception e) {
            log.error("---- Failed to become auditor", (Throwable)e);
        }
    }
}

