/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.pulsar.metadata.BaseMetadataStoreTest;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.assertj.core.util.Lists;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataStoreTest
extends BaseMetadataStoreTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyStoreTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key").join()));
            Assert.assertFalse((boolean)((Boolean)store.exists("/non-existing-key/child").join()));
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key").join()).isPresent());
            Assert.assertFalse((boolean)((Optional)store.get("/non-existing-key/child").join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key").join()), Collections.emptyList());
            Assert.assertEquals((Collection)((Collection)store.getChildren("/non-existing-key/child").join()), Collections.emptyList());
            try {
                store.delete("/non-existing-key", Optional.empty()).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.NotFoundException.class);
            }
            try {
                store.delete("/non-existing-key", Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                Assert.assertTrue((MetadataStoreException.NotFoundException.class.isInstance(e.getCause()) || MetadataStoreException.BadVersionException.class.isInstance(e.getCause()) ? 1 : 0) != 0);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void insertionTestWithExpectedVersion(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key1 = this.newKey();
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(0L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-1".getBytes(), Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            store.put(key1, "value-1".getBytes(), Optional.of(-1L)).join();
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            Optional optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)0L);
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(-1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            try {
                store.put(key1, "value-2".getBytes(), Optional.of(1L)).join();
                Assert.fail((String)"Should have failed");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
            }
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-1".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)0L);
            store.put(key1, "value-2".getBytes(), Optional.of(0L)).join();
            Assert.assertTrue((boolean)((Boolean)store.exists(key1).join()));
            optRes = (Optional)store.get(key1).join();
            Assert.assertTrue((boolean)optRes.isPresent());
            Assert.assertEquals((byte[])((GetResult)optRes.get()).getValue(), (byte[])"value-2".getBytes());
            Assert.assertEquals((long)((GetResult)optRes.get()).getStat().getVersion(), (long)1L);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void getChildrenTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            int i;
            String key = this.newKey();
            int n = 10;
            ArrayList<String> expectedChildren = new ArrayList<String>();
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.emptyList());
            for (i = 0; i < n; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add("c-" + i);
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
            for (i = 0; i < n; ++i) {
                store.put(key + "/c-0/cc-" + i, new byte[0], Optional.empty()).join();
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), expectedChildren);
            for (i = 0; i < n; ++i) {
                store.deleteRecursive(key + "/c-" + i).join();
            }
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.emptyList());
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void navigateChildrenTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key = this.newKey();
            store.put(key + "/c-0/cc-1", new byte[0], Optional.empty()).join();
            store.put(key + "/c-0/cc-2/ccc-1", new byte[0], Optional.empty()).join();
            Assert.assertEquals((Collection)((Collection)store.getChildren(key).join()), Collections.singletonList("c-0"));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key + "/c-0").join()), (Collection)Lists.newArrayList((Object[])new String[]{"cc-1", "cc-2"}));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key + "/c-0/cc-2").join()), (Collection)Lists.newArrayList((Object[])new String[]{"ccc-1"}));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void deletionTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String key = this.newKey();
            int n = 10;
            ArrayList<String> expectedChildren = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                store.put(key + "/c-" + i, new byte[0], Optional.empty()).join();
                expectedChildren.add("c-" + i);
            }
            try {
                store.delete(key, Optional.empty()).join();
                Assert.fail((String)"The key has children");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            for (int i = 0; i < n; ++i) {
                try {
                    store.delete(key + "/c-" + i, Optional.of(1L)).join();
                    Assert.fail((String)"The key has children");
                }
                catch (CompletionException e) {
                    MetadataStoreTest.assertException(e, MetadataStoreException.BadVersionException.class);
                }
                store.delete(key + "/c-" + i, Optional.empty()).join();
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void emptyKeyTest(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            try {
                store.delete("", Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.getChildren("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.get("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.exists("").join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
            try {
                store.put("", new byte[0], Optional.empty()).join();
                Assert.fail((String)"The key cannot be empty");
            }
            catch (CompletionException e) {
                MetadataStoreTest.assertException(e, MetadataStoreException.class);
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void notificationListeners(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            LinkedBlockingDeque notifications = new LinkedBlockingDeque();
            store.registerListener(n -> notifications.add(n));
            String key1 = this.newKey();
            Assert.assertFalse((boolean)((Optional)store.get(key1).join()).isPresent());
            Stat stat = (Stat)store.put(key1, "value-1".getBytes(), Optional.empty()).join();
            Assert.assertTrue((boolean)((Optional)store.get(key1).join()).isPresent());
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.emptyList());
            Assert.assertEquals((long)stat.getVersion(), (long)0L);
            Notification n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            stat = (Stat)store.put(key1, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Modified);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertEquals((long)stat.getVersion(), (long)1L);
            String key1Child = key1 + "/xx";
            Assert.assertFalse((boolean)((Optional)store.get(key1Child).join()).isPresent());
            store.put(key1Child, "value-2".getBytes(), Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Created);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
            Assert.assertTrue((boolean)((Boolean)store.exists(key1Child).join()));
            Assert.assertEquals((Collection)((Collection)store.getChildren(key1).join()), Collections.singletonList("xx"));
            store.delete(key1Child, Optional.empty()).join();
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.Deleted);
            Assert.assertEquals((String)n2.getPath(), (String)key1Child);
            n2 = (Notification)notifications.poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)n2);
            Assert.assertEquals((Object)n2.getType(), (Object)NotificationType.ChildrenChanged);
            Assert.assertEquals((String)n2.getPath(), (String)key1);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testDeleteRecursive(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String prefix = this.newKey();
            String key1 = this.newKey();
            store.put(prefix + key1, "value-1".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1/x1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c1/x2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c2/y2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + key1 + "/c3", "value".getBytes(), Optional.of(-1L)).join();
            String key2 = this.newKey();
            store.put(prefix + key2, "value-2".getBytes(), Optional.of(-1L)).join();
            store.deleteRecursive(prefix + key1).join();
            Assert.assertEquals((Collection)((Collection)store.getChildren(prefix).join()), Collections.singletonList(key2.substring(1)));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testDeleteUnusedDirectories(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String prefix = this.newKey();
            store.put(prefix + "/a1/b1/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + "/a1/b1/c2", "value".getBytes(), Optional.of(-1L)).join();
            store.put(prefix + "/a1/b2/c1", "value".getBytes(), Optional.of(-1L)).join();
            store.delete(prefix + "/a1/b1/c1", Optional.empty()).join();
            store.delete(prefix + "/a1/b1/c2", Optional.empty()).join();
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1/b1").join()));
            store.delete(prefix + "/a1/b2/c1", Optional.empty()).join();
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1/b2").join()));
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix + "/a1").join()));
            this.zks.checkContainers();
            Assert.assertFalse((boolean)((Boolean)store.exists(prefix).join()));
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    @Test(dataProvider="impl")
    public void testPersistent(String provider, Supplier<String> urlSupplier) throws Exception {
        String metadataUrl = urlSupplier.get();
        MetadataStore store = MetadataStoreFactory.create((String)metadataUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        byte[] data = "testPersistent".getBytes(StandardCharsets.UTF_8);
        String key = this.newKey() + "/a/b/c";
        store.put(key, data, Optional.of(-1L)).join();
        store.close();
        store = MetadataStoreFactory.create((String)metadataUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        Optional result = (Optional)store.get(key).get();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((byte[])((GetResult)result.get()).getValue(), (byte[])data);
        store.close();
    }

    @Test(dataProvider="impl")
    public void testConcurrentPutGetOneKey(String provider, Supplier<String> urlSupplier) throws Exception {
        final MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        byte[] data = new byte[]{0};
        final String path = this.newKey();
        final int maxValue = 100;
        store.put(path, data, Optional.of(-1L)).join();
        final AtomicInteger successWrites = new AtomicInteger(0);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                GetResult readResult;
                byte value;
                while ((value = (byte)((readResult = (GetResult)((Optional)store.get(path).get()).get()).getValue()[0] + 1)) <= maxValue) {
                    CompletionStage putResult = store.put(path, new byte[]{value}, Optional.of(readResult.getStat().getVersion())).thenRun(successWrites::incrementAndGet);
                    try {
                        ((CompletableFuture)putResult).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.info("Put value {} success:{}. ", (Object)value, (Object)(!((CompletableFuture)putResult).isCompletedExceptionally() ? 1 : 0));
                }
            }
        };
        CompletionStage t1 = CompletableFuture.completedFuture(null).thenRunAsync(task);
        CompletionStage t2 = CompletableFuture.completedFuture(null).thenRunAsync(task);
        task.run();
        ((CompletableFuture)t1).join();
        ((CompletableFuture)t2).join();
        Assert.assertFalse((boolean)((CompletableFuture)t1).isCompletedExceptionally());
        Assert.assertFalse((boolean)((CompletableFuture)t2).isCompletedExceptionally());
        Assert.assertEquals((int)successWrites.get(), (int)maxValue);
        Assert.assertEquals((int)((GetResult)((Optional)store.get(path).get()).get()).getValue()[0], (int)maxValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testConcurrentPut(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String k = this.newKey();
            CompletableFuture<Void> f1 = CompletableFuture.runAsync(() -> store.put(k, new byte[0], Optional.of(-1L)).join());
            CompletableFuture<Void> f2 = CompletableFuture.runAsync(() -> store.put(k, new byte[0], Optional.of(-1L)).join());
            Awaitility.await().until(() -> f1.isDone() && f2.isDone());
            Assert.assertTrue((f1.isCompletedExceptionally() && !f2.isCompletedExceptionally() || !f1.isCompletedExceptionally() && f2.isCompletedExceptionally() ? 1 : 0) != 0);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testConcurrentDelete(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            String k = this.newKey();
            store.put(k, new byte[0], Optional.of(-1L)).join();
            CompletableFuture<Void> f1 = CompletableFuture.runAsync(() -> store.delete(k, Optional.empty()).join());
            CompletableFuture<Void> f2 = CompletableFuture.runAsync(() -> store.delete(k, Optional.empty()).join());
            Awaitility.await().until(() -> f1.isDone() && f2.isDone());
            Assert.assertTrue((f1.isCompletedExceptionally() && !f2.isCompletedExceptionally() || !f1.isCompletedExceptionally() && f2.isCompletedExceptionally() ? 1 : 0) != 0);
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="impl")
    public void testGetChildren(String provider, Supplier<String> urlSupplier) throws Exception {
        MetadataStore store = MetadataStoreFactory.create((String)urlSupplier.get(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        try {
            store.put("/a/a-1", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            store.put("/a/a-2", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            store.put("/b/c/b/1", "value1".getBytes(StandardCharsets.UTF_8), Optional.empty()).join();
            List subPaths = (List)store.getChildren("/").get();
            HashSet expectedSet = "ZooKeeper".equals(provider) ? Sets.newHashSet((Object[])new String[]{"a", "b", "zookeeper"}) : Sets.newHashSet((Object[])new String[]{"a", "b"});
            for (String subPath : subPaths) {
                Assert.assertTrue((boolean)expectedSet.contains(subPath));
            }
            List subPaths2 = (List)store.getChildren("/a").get();
            HashSet expectedSet2 = Sets.newHashSet((Object[])new String[]{"a-1", "a-2"});
            for (String subPath : subPaths2) {
                Assert.assertTrue((boolean)expectedSet2.contains(subPath));
            }
            List subPaths3 = (List)store.getChildren("/b").get();
            HashSet expectedSet3 = Sets.newHashSet((Object[])new String[]{"c"});
            for (String subPath : subPaths3) {
                Assert.assertTrue((boolean)expectedSet3.contains(subPath));
            }
        }
        finally {
            if (Collections.singletonList(store).get(0) != null) {
                store.close();
            }
        }
    }
}

