/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata;

import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.launcher.EtcdClusterFactory;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.metadata.TestZKServer;
import org.apache.pulsar.tests.TestRetrySupport;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class BaseMetadataStoreTest
extends TestRetrySupport {
    protected TestZKServer zks;
    protected EtcdCluster etcdCluster;

    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        this.zks = new TestZKServer();
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() throws Exception {
        this.markCurrentSetupNumberCleaned();
        if (this.zks != null) {
            this.zks.close();
            this.zks = null;
        }
        if (this.etcdCluster != null) {
            this.etcdCluster.close();
            this.etcdCluster = null;
        }
    }

    private static String createTempFolder() {
        File temp = Files.newTemporaryFolder();
        temp.deleteOnExit();
        return temp.getAbsolutePath();
    }

    @DataProvider(name="impl")
    public Object[][] implementations() {
        return new Object[][]{{"ZooKeeper", BaseMetadataStoreTest.stringSupplier(() -> this.zks.getConnectionString())}, {"Memory", BaseMetadataStoreTest.stringSupplier(() -> "memory:" + UUID.randomUUID())}, {"RocksDB", BaseMetadataStoreTest.stringSupplier(() -> "rocksdb:" + BaseMetadataStoreTest.createTempFolder())}, {"Etcd", BaseMetadataStoreTest.stringSupplier(() -> "etcd:" + this.getEtcdClusterConnectString())}};
    }

    private synchronized String getEtcdClusterConnectString() {
        if (this.etcdCluster == null) {
            this.etcdCluster = EtcdClusterFactory.buildCluster((String)"test", (int)1, (boolean)false);
            this.etcdCluster.start();
        }
        return this.etcdCluster.getClientEndpoints().stream().map(URI::toString).collect(Collectors.joining(","));
    }

    public static Supplier<String> stringSupplier(Supplier<String> supplier) {
        return supplier;
    }

    protected String newKey() {
        return "/key-" + System.nanoTime();
    }

    static void assertException(CompletionException e, Class<?> clazz) {
        BaseMetadataStoreTest.assertException(e.getCause(), clazz);
    }

    static void assertException(Throwable t, Class<?> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(t), (String)String.format("Exception %s is not of type %s", t.getClass(), clazz));
    }

    public static void assertEqualsAndRetry(Supplier<Object> actual, Object expected, Object expectedAndRetry) throws Exception {
        BaseMetadataStoreTest.assertEqualsAndRetry(actual, expected, expectedAndRetry, 5, 100L);
    }

    public static void assertEqualsAndRetry(Supplier<Object> actual, Object expected, Object expectedAndRetry, int retryCount, long intSleepTimeInMillis) throws Exception {
        Assert.assertTrue((boolean)BaseMetadataStoreTest.retryStrategically(__ -> {
            if (actual.get().equals(expectedAndRetry)) {
                return false;
            }
            Assert.assertEquals(actual.get(), (Object)expected);
            return true;
        }, retryCount, intSleepTimeInMillis));
    }

    public static boolean retryStrategically(Predicate<Void> predicate, int retryCount, long intSleepTimeInMillis) throws Exception {
        for (int i = 0; i < retryCount; ++i) {
            if (predicate.test(null)) {
                return true;
            }
            Thread.sleep(intSleepTimeInMillis + intSleepTimeInMillis * (long)i);
        }
        return false;
    }
}

