/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.mongodb;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class MongoConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final long DEFAULT_BATCH_TIME_MS = 1000L;
    @FieldDoc(required=true, defaultValue="", help="The uri of mongodb that the connector connects to (see: https://docs.mongodb.com/manual/reference/connection-string/)")
    private String mongoUri;
    @FieldDoc(defaultValue="", help="The database name to which the collection belongs and which must be watched for the source connector (required for the sink connector)")
    private String database;
    @FieldDoc(defaultValue="", help="The collection name where the messages are written or which is watched for the source connector (required for the sink connector)")
    private String collection;
    @FieldDoc(defaultValue="100", help="The batch size of write to or read from the database")
    private int batchSize = 100;
    @FieldDoc(defaultValue="1000", help="The batch operation interval in milliseconds")
    private long batchTimeMs = 1000L;

    public static MongoConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        MongoConfig cfg = (MongoConfig)mapper.readValue(new File(yamlFile), MongoConfig.class);
        return cfg;
    }

    public static MongoConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MongoConfig cfg = (MongoConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), MongoConfig.class);
        return cfg;
    }

    public void validate(boolean dbRequired, boolean collectionRequired) {
        if (StringUtils.isEmpty((CharSequence)this.getMongoUri()) || dbRequired && StringUtils.isEmpty((CharSequence)this.getDatabase()) || collectionRequired && StringUtils.isEmpty((CharSequence)this.getCollection())) {
            throw new IllegalArgumentException("Required property not set.");
        }
        Preconditions.checkArgument((this.getBatchSize() > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
        Preconditions.checkArgument((this.getBatchTimeMs() > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
    }

    public String getMongoUri() {
        return this.mongoUri;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public MongoConfig setMongoUri(String mongoUri) {
        this.mongoUri = mongoUri;
        return this;
    }

    public MongoConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public MongoConfig setCollection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public MongoConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoConfig)) {
            return false;
        }
        MongoConfig other = (MongoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        String this$mongoUri = this.getMongoUri();
        String other$mongoUri = other.getMongoUri();
        if (this$mongoUri == null ? other$mongoUri != null : !this$mongoUri.equals(other$mongoUri)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        String $mongoUri = this.getMongoUri();
        result = result * 59 + ($mongoUri == null ? 43 : $mongoUri.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        return result;
    }

    public String toString() {
        return "MongoConfig(mongoUri=" + this.getMongoUri() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ", batchSize=" + this.getBatchSize() + ", batchTimeMs=" + this.getBatchTimeMs() + ")";
    }
}

