/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class KafkaSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of host and port pairs that are the addresses of the Kafka brokers that a Kafka client connects to initially bootstrap itself")
    private String bootstrapServers;
    @FieldDoc(required=false, defaultValue="", help="Protocol used to communicate with kafka brokers.")
    private String securityProtocol;
    @FieldDoc(required=false, defaultValue="", help="SASL mechanism used for kafka client connections.")
    private String saslMechanism;
    @FieldDoc(required=false, defaultValue="", help="JAAS login context parameters for SASL connections in the format used by JAAS configuration files.")
    private String saslJaasConfig;
    @FieldDoc(required=false, defaultValue="", help="The list of protocols enabled for SSL connections.")
    private String sslEnabledProtocols;
    @FieldDoc(required=false, defaultValue="", help="The endpoint identification algorithm to validate server hostname using server certificate.")
    private String sslEndpointIdentificationAlgorithm;
    @FieldDoc(required=false, defaultValue="", help="The location of the trust store file.")
    private String sslTruststoreLocation;
    @FieldDoc(required=false, defaultValue="", help="The password for the trust store file.")
    private String sslTruststorePassword;
    @FieldDoc(required=true, defaultValue="", help="The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent.")
    private String acks;
    @FieldDoc(defaultValue="16384L", help="The batch size that Kafka producer will attempt to batch records together before sending them to brokers.")
    private long batchSize = 16384L;
    @FieldDoc(defaultValue="1048576L", help="The maximum size of a Kafka request in bytes.")
    private long maxRequestSize = 0x100000L;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic that is used for Pulsar moving messages to.")
    private String topic;
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.StringSerializer", help="The serializer class for Kafka producer to serialize keys.")
    private String keySerializerClass = "org.apache.kafka.common.serialization.StringSerializer";
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.ByteArraySerializer", help="The serializer class for Kafka producer to serialize values. You typically shouldn't care this. Since the serializer will be set by a specific implementation of `KafkaAbstractSink`.")
    private String valueSerializerClass = "org.apache.kafka.common.serialization.ByteArraySerializer";
    @FieldDoc(defaultValue="", help="The producer config properties to be passed to Producer. Note that other properties specified in the connector config file take precedence over this config.")
    private Map<String, Object> producerConfigProperties;

    public static KafkaSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSinkConfig)mapper.readValue(new File(yamlFile), KafkaSinkConfig.class);
    }

    public static KafkaSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSinkConfig.class);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public String getSaslJaasConfig() {
        return this.saslJaasConfig;
    }

    public String getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public String getSslEndpointIdentificationAlgorithm() {
        return this.sslEndpointIdentificationAlgorithm;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public String getAcks() {
        return this.acks;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeySerializerClass() {
        return this.keySerializerClass;
    }

    public String getValueSerializerClass() {
        return this.valueSerializerClass;
    }

    public Map<String, Object> getProducerConfigProperties() {
        return this.producerConfigProperties;
    }

    public KafkaSinkConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSinkConfig setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    public KafkaSinkConfig setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this;
    }

    public KafkaSinkConfig setSaslJaasConfig(String saslJaasConfig) {
        this.saslJaasConfig = saslJaasConfig;
        return this;
    }

    public KafkaSinkConfig setSslEnabledProtocols(String sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
        return this;
    }

    public KafkaSinkConfig setSslEndpointIdentificationAlgorithm(String sslEndpointIdentificationAlgorithm) {
        this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
        return this;
    }

    public KafkaSinkConfig setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
        return this;
    }

    public KafkaSinkConfig setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return this;
    }

    public KafkaSinkConfig setAcks(String acks) {
        this.acks = acks;
        return this;
    }

    public KafkaSinkConfig setBatchSize(long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public KafkaSinkConfig setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public KafkaSinkConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSinkConfig setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
        return this;
    }

    public KafkaSinkConfig setValueSerializerClass(String valueSerializerClass) {
        this.valueSerializerClass = valueSerializerClass;
        return this;
    }

    public KafkaSinkConfig setProducerConfigProperties(Map<String, Object> producerConfigProperties) {
        this.producerConfigProperties = producerConfigProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSinkConfig)) {
            return false;
        }
        KafkaSinkConfig other = (KafkaSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getMaxRequestSize() != other.getMaxRequestSize()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$securityProtocol = this.getSecurityProtocol();
        String other$securityProtocol = other.getSecurityProtocol();
        if (this$securityProtocol == null ? other$securityProtocol != null : !this$securityProtocol.equals(other$securityProtocol)) {
            return false;
        }
        String this$saslMechanism = this.getSaslMechanism();
        String other$saslMechanism = other.getSaslMechanism();
        if (this$saslMechanism == null ? other$saslMechanism != null : !this$saslMechanism.equals(other$saslMechanism)) {
            return false;
        }
        String this$saslJaasConfig = this.getSaslJaasConfig();
        String other$saslJaasConfig = other.getSaslJaasConfig();
        if (this$saslJaasConfig == null ? other$saslJaasConfig != null : !this$saslJaasConfig.equals(other$saslJaasConfig)) {
            return false;
        }
        String this$sslEnabledProtocols = this.getSslEnabledProtocols();
        String other$sslEnabledProtocols = other.getSslEnabledProtocols();
        if (this$sslEnabledProtocols == null ? other$sslEnabledProtocols != null : !this$sslEnabledProtocols.equals(other$sslEnabledProtocols)) {
            return false;
        }
        String this$sslEndpointIdentificationAlgorithm = this.getSslEndpointIdentificationAlgorithm();
        String other$sslEndpointIdentificationAlgorithm = other.getSslEndpointIdentificationAlgorithm();
        if (this$sslEndpointIdentificationAlgorithm == null ? other$sslEndpointIdentificationAlgorithm != null : !this$sslEndpointIdentificationAlgorithm.equals(other$sslEndpointIdentificationAlgorithm)) {
            return false;
        }
        String this$sslTruststoreLocation = this.getSslTruststoreLocation();
        String other$sslTruststoreLocation = other.getSslTruststoreLocation();
        if (this$sslTruststoreLocation == null ? other$sslTruststoreLocation != null : !this$sslTruststoreLocation.equals(other$sslTruststoreLocation)) {
            return false;
        }
        String this$sslTruststorePassword = this.getSslTruststorePassword();
        String other$sslTruststorePassword = other.getSslTruststorePassword();
        if (this$sslTruststorePassword == null ? other$sslTruststorePassword != null : !this$sslTruststorePassword.equals(other$sslTruststorePassword)) {
            return false;
        }
        String this$acks = this.getAcks();
        String other$acks = other.getAcks();
        if (this$acks == null ? other$acks != null : !this$acks.equals(other$acks)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keySerializerClass = this.getKeySerializerClass();
        String other$keySerializerClass = other.getKeySerializerClass();
        if (this$keySerializerClass == null ? other$keySerializerClass != null : !this$keySerializerClass.equals(other$keySerializerClass)) {
            return false;
        }
        String this$valueSerializerClass = this.getValueSerializerClass();
        String other$valueSerializerClass = other.getValueSerializerClass();
        if (this$valueSerializerClass == null ? other$valueSerializerClass != null : !this$valueSerializerClass.equals(other$valueSerializerClass)) {
            return false;
        }
        Map<String, Object> this$producerConfigProperties = this.getProducerConfigProperties();
        Map<String, Object> other$producerConfigProperties = other.getProducerConfigProperties();
        return !(this$producerConfigProperties == null ? other$producerConfigProperties != null : !((Object)this$producerConfigProperties).equals(other$producerConfigProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $batchSize = this.getBatchSize();
        result = result * 59 + (int)($batchSize >>> 32 ^ $batchSize);
        long $maxRequestSize = this.getMaxRequestSize();
        result = result * 59 + (int)($maxRequestSize >>> 32 ^ $maxRequestSize);
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $securityProtocol = this.getSecurityProtocol();
        result = result * 59 + ($securityProtocol == null ? 43 : $securityProtocol.hashCode());
        String $saslMechanism = this.getSaslMechanism();
        result = result * 59 + ($saslMechanism == null ? 43 : $saslMechanism.hashCode());
        String $saslJaasConfig = this.getSaslJaasConfig();
        result = result * 59 + ($saslJaasConfig == null ? 43 : $saslJaasConfig.hashCode());
        String $sslEnabledProtocols = this.getSslEnabledProtocols();
        result = result * 59 + ($sslEnabledProtocols == null ? 43 : $sslEnabledProtocols.hashCode());
        String $sslEndpointIdentificationAlgorithm = this.getSslEndpointIdentificationAlgorithm();
        result = result * 59 + ($sslEndpointIdentificationAlgorithm == null ? 43 : $sslEndpointIdentificationAlgorithm.hashCode());
        String $sslTruststoreLocation = this.getSslTruststoreLocation();
        result = result * 59 + ($sslTruststoreLocation == null ? 43 : $sslTruststoreLocation.hashCode());
        String $sslTruststorePassword = this.getSslTruststorePassword();
        result = result * 59 + ($sslTruststorePassword == null ? 43 : $sslTruststorePassword.hashCode());
        String $acks = this.getAcks();
        result = result * 59 + ($acks == null ? 43 : $acks.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keySerializerClass = this.getKeySerializerClass();
        result = result * 59 + ($keySerializerClass == null ? 43 : $keySerializerClass.hashCode());
        String $valueSerializerClass = this.getValueSerializerClass();
        result = result * 59 + ($valueSerializerClass == null ? 43 : $valueSerializerClass.hashCode());
        Map<String, Object> $producerConfigProperties = this.getProducerConfigProperties();
        result = result * 59 + ($producerConfigProperties == null ? 43 : ((Object)$producerConfigProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSinkConfig(bootstrapServers=" + this.getBootstrapServers() + ", securityProtocol=" + this.getSecurityProtocol() + ", saslMechanism=" + this.getSaslMechanism() + ", saslJaasConfig=" + this.getSaslJaasConfig() + ", sslEnabledProtocols=" + this.getSslEnabledProtocols() + ", sslEndpointIdentificationAlgorithm=" + this.getSslEndpointIdentificationAlgorithm() + ", sslTruststoreLocation=" + this.getSslTruststoreLocation() + ", sslTruststorePassword=" + this.getSslTruststorePassword() + ", acks=" + this.getAcks() + ", batchSize=" + this.getBatchSize() + ", maxRequestSize=" + this.getMaxRequestSize() + ", topic=" + this.getTopic() + ", keySerializerClass=" + this.getKeySerializerClass() + ", valueSerializerClass=" + this.getValueSerializerClass() + ", producerConfigProperties=" + this.getProducerConfigProperties() + ")";
    }
}

