/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class KafkaSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of host and port pairs that are the addresses of the Kafka brokers that a Kafka client connects to initially bootstrap itself")
    private String bootstrapServers;
    @FieldDoc(required=true, defaultValue="", help="The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent.")
    private String acks;
    @FieldDoc(defaultValue="16384L", help="The batch size that Kafka producer will attempt to batch records together before sending them to brokers.")
    private long batchSize = 16384L;
    @FieldDoc(defaultValue="1048576L", help="The maximum size of a Kafka request in bytes.")
    private long maxRequestSize = 0x100000L;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic that is used for Pulsar moving messages to.")
    private String topic;
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.StringSerializer", help="The serializer class for Kafka producer to serialize keys.")
    private String keySerializerClass = "org.apache.kafka.common.serialization.StringSerializer";
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.ByteArraySerializer", help="The serializer class for Kafka producer to serialize values. You typically shouldn't care this. Since the serializer will be set by a specific implementation of `KafkaAbstractSink`.")
    private String valueSerializerClass = "org.apache.kafka.common.serialization.ByteArraySerializer";
    @FieldDoc(defaultValue="", help="The producer config properties to be passed to Producer. Note that other properties specified in the connector config file take precedence over this config.")
    private Map<String, Object> producerConfigProperties;

    public static KafkaSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSinkConfig)mapper.readValue(new File(yamlFile), KafkaSinkConfig.class);
    }

    public static KafkaSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSinkConfig.class);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getAcks() {
        return this.acks;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeySerializerClass() {
        return this.keySerializerClass;
    }

    public String getValueSerializerClass() {
        return this.valueSerializerClass;
    }

    public Map<String, Object> getProducerConfigProperties() {
        return this.producerConfigProperties;
    }

    public KafkaSinkConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSinkConfig setAcks(String acks) {
        this.acks = acks;
        return this;
    }

    public KafkaSinkConfig setBatchSize(long batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public KafkaSinkConfig setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public KafkaSinkConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSinkConfig setKeySerializerClass(String keySerializerClass) {
        this.keySerializerClass = keySerializerClass;
        return this;
    }

    public KafkaSinkConfig setValueSerializerClass(String valueSerializerClass) {
        this.valueSerializerClass = valueSerializerClass;
        return this;
    }

    public KafkaSinkConfig setProducerConfigProperties(Map<String, Object> producerConfigProperties) {
        this.producerConfigProperties = producerConfigProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSinkConfig)) {
            return false;
        }
        KafkaSinkConfig other = (KafkaSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getMaxRequestSize() != other.getMaxRequestSize()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$acks = this.getAcks();
        String other$acks = other.getAcks();
        if (this$acks == null ? other$acks != null : !this$acks.equals(other$acks)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keySerializerClass = this.getKeySerializerClass();
        String other$keySerializerClass = other.getKeySerializerClass();
        if (this$keySerializerClass == null ? other$keySerializerClass != null : !this$keySerializerClass.equals(other$keySerializerClass)) {
            return false;
        }
        String this$valueSerializerClass = this.getValueSerializerClass();
        String other$valueSerializerClass = other.getValueSerializerClass();
        if (this$valueSerializerClass == null ? other$valueSerializerClass != null : !this$valueSerializerClass.equals(other$valueSerializerClass)) {
            return false;
        }
        Map<String, Object> this$producerConfigProperties = this.getProducerConfigProperties();
        Map<String, Object> other$producerConfigProperties = other.getProducerConfigProperties();
        return !(this$producerConfigProperties == null ? other$producerConfigProperties != null : !((Object)this$producerConfigProperties).equals(other$producerConfigProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $batchSize = this.getBatchSize();
        result = result * 59 + (int)($batchSize >>> 32 ^ $batchSize);
        long $maxRequestSize = this.getMaxRequestSize();
        result = result * 59 + (int)($maxRequestSize >>> 32 ^ $maxRequestSize);
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $acks = this.getAcks();
        result = result * 59 + ($acks == null ? 43 : $acks.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keySerializerClass = this.getKeySerializerClass();
        result = result * 59 + ($keySerializerClass == null ? 43 : $keySerializerClass.hashCode());
        String $valueSerializerClass = this.getValueSerializerClass();
        result = result * 59 + ($valueSerializerClass == null ? 43 : $valueSerializerClass.hashCode());
        Map<String, Object> $producerConfigProperties = this.getProducerConfigProperties();
        result = result * 59 + ($producerConfigProperties == null ? 43 : ((Object)$producerConfigProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSinkConfig(bootstrapServers=" + this.getBootstrapServers() + ", acks=" + this.getAcks() + ", batchSize=" + this.getBatchSize() + ", maxRequestSize=" + this.getMaxRequestSize() + ", topic=" + this.getTopic() + ", keySerializerClass=" + this.getKeySerializerClass() + ", valueSerializerClass=" + this.getValueSerializerClass() + ", producerConfigProperties=" + this.getProducerConfigProperties() + ")";
    }
}

