/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.kafka.KafkaSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaAbstractSink<K, V>
implements Sink<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAbstractSink.class);
    private Producer<K, V> producer;
    private Properties props = new Properties();
    private KafkaSinkConfig kafkaSinkConfig;

    public void write(Record<byte[]> sourceRecord) {
        KeyValue<K, V> keyValue = this.extractKeyValue(sourceRecord);
        ProducerRecord record = new ProducerRecord(this.kafkaSinkConfig.getTopic(), keyValue.getKey(), keyValue.getValue());
        if (log.isDebugEnabled()) {
            log.debug("Record sending to kafka, record={}.", (Object)record);
        }
        this.producer.send(record, (metadata, exception) -> {
            if (exception == null) {
                sourceRecord.ack();
            } else {
                sourceRecord.fail();
            }
        });
    }

    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
            log.info("Kafka sink stopped.");
        }
    }

    protected Properties beforeCreateProducer(Properties props) {
        return props;
    }

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        this.kafkaSinkConfig = KafkaSinkConfig.load(config);
        Objects.requireNonNull(this.kafkaSinkConfig.getTopic(), "Kafka topic is not set");
        Objects.requireNonNull(this.kafkaSinkConfig.getBootstrapServers(), "Kafka bootstrapServers is not set");
        Objects.requireNonNull(this.kafkaSinkConfig.getAcks(), "Kafka acks mode is not set");
        if (this.kafkaSinkConfig.getBatchSize() <= 0L) {
            throw new IllegalArgumentException("Invalid Kafka Producer batchSize : " + this.kafkaSinkConfig.getBatchSize());
        }
        if (this.kafkaSinkConfig.getMaxRequestSize() <= 0L) {
            throw new IllegalArgumentException("Invalid Kafka Producer maxRequestSize : " + this.kafkaSinkConfig.getMaxRequestSize());
        }
        if (this.kafkaSinkConfig.getProducerConfigProperties() != null) {
            this.props.putAll(this.kafkaSinkConfig.getProducerConfigProperties());
        }
        this.props.put("bootstrap.servers", this.kafkaSinkConfig.getBootstrapServers());
        this.props.put("acks", this.kafkaSinkConfig.getAcks());
        this.props.put("batch.size", String.valueOf(this.kafkaSinkConfig.getBatchSize()));
        this.props.put("max.request.size", String.valueOf(this.kafkaSinkConfig.getMaxRequestSize()));
        this.props.put("key.serializer", this.kafkaSinkConfig.getKeySerializerClass());
        this.props.put("value.serializer", this.kafkaSinkConfig.getValueSerializerClass());
        this.producer = new KafkaProducer(this.beforeCreateProducer(this.props));
        log.info("Kafka sink started : {}.", (Object)this.props);
    }

    public abstract KeyValue<K, V> extractKeyValue(Record<byte[]> var1);
}

