/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class KafkaSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of host and port pairs that are the addresses of the Kafka brokers that a Kafka client connects to initially bootstrap itself")
    private String bootstrapServers;
    @FieldDoc(required=true, defaultValue="", help="A string that uniquely identifies the group of consumer processes to which this consumer belongs.")
    private String groupId;
    @FieldDoc(defaultValue="1", help="The minimum amount of data the server should return for a fetch request.")
    private long fetchMinBytes = 1L;
    @FieldDoc(defaultValue="5000", help="The frequency in milliseconds that the consumer offsets are auto-committed to Kafka if autoCommitEnabled is set to true.")
    private long autoCommitIntervalMs = 5000L;
    @FieldDoc(defaultValue="30000", help="The timeout used to detect failures when using Kafka's group management facilities.")
    private long sessionTimeoutMs = 30000L;
    @FieldDoc(defaultValue="3000", help="The interval between heartbeats to the consumer when using Kafka's group management facilities. The value must be lower than session timeout.")
    private long heartbeatIntervalMs = 3000L;
    @FieldDoc(defaultValue="true", help="If true the consumer's offset will be periodically committed in the background.")
    private boolean autoCommitEnabled = true;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic that is used for Pulsar moving messages to.")
    private String topic;
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.StringDeserializer", help="The deserializer class for Kafka consumer to deserialize keys.")
    private String keyDeserializationClass = "org.apache.kafka.common.serialization.StringDeserializer";
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.ByteArrayDeserializer", help="The deserializer class for Kafka consumer to deserialize values. You typically shouldn't care this. Since the deserializer will be set by a specific implementation of `KafkaAbstractSource`.")
    private String valueDeserializationClass = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
    @FieldDoc(defaultValue="earliest", help="The default offset reset policy.")
    private String autoOffsetReset = "earliest";
    @FieldDoc(defaultValue="", help="The consumer config properties to be passed to Consumer. Note that other properties specified in the connector config file take precedence over this config.")
    private Map<String, Object> consumerConfigProperties;

    public static KafkaSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSourceConfig)mapper.readValue(new File(yamlFile), KafkaSourceConfig.class);
    }

    public static KafkaSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSourceConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSourceConfig.class);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public long getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public long getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public long getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeyDeserializationClass() {
        return this.keyDeserializationClass;
    }

    public String getValueDeserializationClass() {
        return this.valueDeserializationClass;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public Map<String, Object> getConsumerConfigProperties() {
        return this.consumerConfigProperties;
    }

    public KafkaSourceConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSourceConfig setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public KafkaSourceConfig setFetchMinBytes(long fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
        return this;
    }

    public KafkaSourceConfig setAutoCommitIntervalMs(long autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
        return this;
    }

    public KafkaSourceConfig setSessionTimeoutMs(long sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        return this;
    }

    public KafkaSourceConfig setHeartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        return this;
    }

    public KafkaSourceConfig setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
        return this;
    }

    public KafkaSourceConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSourceConfig setKeyDeserializationClass(String keyDeserializationClass) {
        this.keyDeserializationClass = keyDeserializationClass;
        return this;
    }

    public KafkaSourceConfig setValueDeserializationClass(String valueDeserializationClass) {
        this.valueDeserializationClass = valueDeserializationClass;
        return this;
    }

    public KafkaSourceConfig setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
        return this;
    }

    public KafkaSourceConfig setConsumerConfigProperties(Map<String, Object> consumerConfigProperties) {
        this.consumerConfigProperties = consumerConfigProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceConfig)) {
            return false;
        }
        KafkaSourceConfig other = (KafkaSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchMinBytes() != other.getFetchMinBytes()) {
            return false;
        }
        if (this.getAutoCommitIntervalMs() != other.getAutoCommitIntervalMs()) {
            return false;
        }
        if (this.getSessionTimeoutMs() != other.getSessionTimeoutMs()) {
            return false;
        }
        if (this.getHeartbeatIntervalMs() != other.getHeartbeatIntervalMs()) {
            return false;
        }
        if (this.isAutoCommitEnabled() != other.isAutoCommitEnabled()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keyDeserializationClass = this.getKeyDeserializationClass();
        String other$keyDeserializationClass = other.getKeyDeserializationClass();
        if (this$keyDeserializationClass == null ? other$keyDeserializationClass != null : !this$keyDeserializationClass.equals(other$keyDeserializationClass)) {
            return false;
        }
        String this$valueDeserializationClass = this.getValueDeserializationClass();
        String other$valueDeserializationClass = other.getValueDeserializationClass();
        if (this$valueDeserializationClass == null ? other$valueDeserializationClass != null : !this$valueDeserializationClass.equals(other$valueDeserializationClass)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        Map<String, Object> this$consumerConfigProperties = this.getConsumerConfigProperties();
        Map<String, Object> other$consumerConfigProperties = other.getConsumerConfigProperties();
        return !(this$consumerConfigProperties == null ? other$consumerConfigProperties != null : !((Object)this$consumerConfigProperties).equals(other$consumerConfigProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fetchMinBytes = this.getFetchMinBytes();
        result = result * 59 + (int)($fetchMinBytes >>> 32 ^ $fetchMinBytes);
        long $autoCommitIntervalMs = this.getAutoCommitIntervalMs();
        result = result * 59 + (int)($autoCommitIntervalMs >>> 32 ^ $autoCommitIntervalMs);
        long $sessionTimeoutMs = this.getSessionTimeoutMs();
        result = result * 59 + (int)($sessionTimeoutMs >>> 32 ^ $sessionTimeoutMs);
        long $heartbeatIntervalMs = this.getHeartbeatIntervalMs();
        result = result * 59 + (int)($heartbeatIntervalMs >>> 32 ^ $heartbeatIntervalMs);
        result = result * 59 + (this.isAutoCommitEnabled() ? 79 : 97);
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keyDeserializationClass = this.getKeyDeserializationClass();
        result = result * 59 + ($keyDeserializationClass == null ? 43 : $keyDeserializationClass.hashCode());
        String $valueDeserializationClass = this.getValueDeserializationClass();
        result = result * 59 + ($valueDeserializationClass == null ? 43 : $valueDeserializationClass.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        Map<String, Object> $consumerConfigProperties = this.getConsumerConfigProperties();
        result = result * 59 + ($consumerConfigProperties == null ? 43 : ((Object)$consumerConfigProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSourceConfig(bootstrapServers=" + this.getBootstrapServers() + ", groupId=" + this.getGroupId() + ", fetchMinBytes=" + this.getFetchMinBytes() + ", autoCommitIntervalMs=" + this.getAutoCommitIntervalMs() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", heartbeatIntervalMs=" + this.getHeartbeatIntervalMs() + ", autoCommitEnabled=" + this.isAutoCommitEnabled() + ", topic=" + this.getTopic() + ", keyDeserializationClass=" + this.getKeyDeserializationClass() + ", valueDeserializationClass=" + this.getValueDeserializationClass() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", consumerConfigProperties=" + this.getConsumerConfigProperties() + ")";
    }
}

