/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.kafka.KafkaAbstractSource;
import org.apache.pulsar.io.kafka.KafkaSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="kafka", type=IOType.SOURCE, help="The KafkaBytesSource is used for moving messages from Kafka to Pulsar.", configClass=KafkaSourceConfig.class)
public class KafkaBytesSource
extends KafkaAbstractSource<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(KafkaBytesSource.class);

    @Override
    protected Properties beforeCreateConsumer(Properties props) {
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        log.info("Created kafka consumer config : {}", (Object)props);
        return props;
    }

    @Override
    public byte[] extractValue(ConsumerRecord<String, byte[]> record) {
        return (byte[])record.value();
    }
}

