/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;

class ByteBufferSchemaWrapper
implements Schema<ByteBuffer> {
    private final Supplier<SchemaInfo> original;

    public ByteBufferSchemaWrapper(Schema original) {
        this(() -> ((Schema)original).getSchemaInfo());
    }

    public ByteBufferSchemaWrapper(SchemaInfo info) {
        this(() -> info);
    }

    public ByteBufferSchemaWrapper(Supplier<SchemaInfo> original) {
        this.original = original;
    }

    public byte[] encode(ByteBuffer message) {
        return ByteBufferSchemaWrapper.getBytes(message);
    }

    public SchemaInfo getSchemaInfo() {
        return this.original.get();
    }

    public Schema<ByteBuffer> clone() {
        return new ByteBufferSchemaWrapper(this.original);
    }

    public ByteBuffer decode(byte[] bytes, byte[] schemaVersion) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.original.get().toString();
    }

    static byte[] getBytes(ByteBuffer buffer) {
        byte[] array;
        int remaining = buffer.remaining();
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && (array = buffer.array()).length == remaining) {
            return array;
        }
        buffer.mark();
        byte[] avroEncodedData = new byte[remaining];
        buffer.get(avroEncodedData);
        buffer.reset();
        return avroEncodedData;
    }
}

