/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class PulsarKafkaConnectSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(defaultValue="16384", help="Size of messages in bytes the sink will attempt to batch messages together before flush.")
    private int batchSize = 16384;
    @FieldDoc(defaultValue="2147483647L", help="Time interval in milliseconds the sink will attempt to batch messages together before flush.")
    private long lingerTimeMs = Integer.MAX_VALUE;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic name that passed to kafka sink.")
    private String topic;
    @FieldDoc(required=true, defaultValue="", help="A kafka-connector sink class to use.")
    private String kafkaConnectorSinkClass;
    @FieldDoc(defaultValue="", help="Config properties to pass to the kafka connector.")
    private Map<String, String> kafkaConnectorConfigProperties;
    @FieldDoc(required=true, defaultValue="", help="Pulsar topic to store offsets at.")
    private String offsetStorageTopic;
    @FieldDoc(defaultValue="true", help="In case of Record<KeyValue<>> data use key from KeyValue<> instead of one from Record.")
    private boolean unwrapKeyValueIfAvailable = true;

    public static PulsarKafkaConnectSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (PulsarKafkaConnectSinkConfig)mapper.readValue(new File(yamlFile), PulsarKafkaConnectSinkConfig.class);
    }

    public static PulsarKafkaConnectSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (PulsarKafkaConnectSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), PulsarKafkaConnectSinkConfig.class);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getLingerTimeMs() {
        return this.lingerTimeMs;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKafkaConnectorSinkClass() {
        return this.kafkaConnectorSinkClass;
    }

    public Map<String, String> getKafkaConnectorConfigProperties() {
        return this.kafkaConnectorConfigProperties;
    }

    public String getOffsetStorageTopic() {
        return this.offsetStorageTopic;
    }

    public boolean isUnwrapKeyValueIfAvailable() {
        return this.unwrapKeyValueIfAvailable;
    }

    public PulsarKafkaConnectSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setLingerTimeMs(long lingerTimeMs) {
        this.lingerTimeMs = lingerTimeMs;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setKafkaConnectorSinkClass(String kafkaConnectorSinkClass) {
        this.kafkaConnectorSinkClass = kafkaConnectorSinkClass;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setKafkaConnectorConfigProperties(Map<String, String> kafkaConnectorConfigProperties) {
        this.kafkaConnectorConfigProperties = kafkaConnectorConfigProperties;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
        return this;
    }

    public PulsarKafkaConnectSinkConfig setUnwrapKeyValueIfAvailable(boolean unwrapKeyValueIfAvailable) {
        this.unwrapKeyValueIfAvailable = unwrapKeyValueIfAvailable;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarKafkaConnectSinkConfig)) {
            return false;
        }
        PulsarKafkaConnectSinkConfig other = (PulsarKafkaConnectSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getLingerTimeMs() != other.getLingerTimeMs()) {
            return false;
        }
        if (this.isUnwrapKeyValueIfAvailable() != other.isUnwrapKeyValueIfAvailable()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$kafkaConnectorSinkClass = this.getKafkaConnectorSinkClass();
        String other$kafkaConnectorSinkClass = other.getKafkaConnectorSinkClass();
        if (this$kafkaConnectorSinkClass == null ? other$kafkaConnectorSinkClass != null : !this$kafkaConnectorSinkClass.equals(other$kafkaConnectorSinkClass)) {
            return false;
        }
        Map<String, String> this$kafkaConnectorConfigProperties = this.getKafkaConnectorConfigProperties();
        Map<String, String> other$kafkaConnectorConfigProperties = other.getKafkaConnectorConfigProperties();
        if (this$kafkaConnectorConfigProperties == null ? other$kafkaConnectorConfigProperties != null : !((Object)this$kafkaConnectorConfigProperties).equals(other$kafkaConnectorConfigProperties)) {
            return false;
        }
        String this$offsetStorageTopic = this.getOffsetStorageTopic();
        String other$offsetStorageTopic = other.getOffsetStorageTopic();
        return !(this$offsetStorageTopic == null ? other$offsetStorageTopic != null : !this$offsetStorageTopic.equals(other$offsetStorageTopic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarKafkaConnectSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        long $lingerTimeMs = this.getLingerTimeMs();
        result = result * 59 + (int)($lingerTimeMs >>> 32 ^ $lingerTimeMs);
        result = result * 59 + (this.isUnwrapKeyValueIfAvailable() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $kafkaConnectorSinkClass = this.getKafkaConnectorSinkClass();
        result = result * 59 + ($kafkaConnectorSinkClass == null ? 43 : $kafkaConnectorSinkClass.hashCode());
        Map<String, String> $kafkaConnectorConfigProperties = this.getKafkaConnectorConfigProperties();
        result = result * 59 + ($kafkaConnectorConfigProperties == null ? 43 : ((Object)$kafkaConnectorConfigProperties).hashCode());
        String $offsetStorageTopic = this.getOffsetStorageTopic();
        result = result * 59 + ($offsetStorageTopic == null ? 43 : $offsetStorageTopic.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarKafkaConnectSinkConfig(batchSize=" + this.getBatchSize() + ", lingerTimeMs=" + this.getLingerTimeMs() + ", topic=" + this.getTopic() + ", kafkaConnectorSinkClass=" + this.getKafkaConnectorSinkClass() + ", kafkaConnectorConfigProperties=" + this.getKafkaConnectorConfigProperties() + ", offsetStorageTopic=" + this.getOffsetStorageTopic() + ", unwrapKeyValueIfAvailable=" + this.isUnwrapKeyValueIfAvailable() + ")";
    }
}

