/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarOffsetBackingStore
implements OffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(PulsarOffsetBackingStore.class);
    private Map<ByteBuffer, ByteBuffer> data;
    private PulsarClient client;
    private String topic;
    private Producer<byte[]> producer;
    private Reader<byte[]> reader;
    private volatile CompletableFuture<Void> outstandingReadToEnd = null;

    public PulsarOffsetBackingStore(PulsarClient client) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"Pulsar Client must be provided");
        this.client = client;
    }

    public void configure(WorkerConfig workerConfig) {
        this.topic = workerConfig.getString("offset.storage.topic");
        Preconditions.checkArgument((!StringUtils.isBlank((String)this.topic) ? 1 : 0) != 0, (Object)"Offset storage topic must be specified");
        this.data = new HashMap<ByteBuffer, ByteBuffer>();
        log.info("Configure offset backing store on pulsar topic {} at cluster {}", (Object)this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readToEnd(CompletableFuture<Void> future) {
        PulsarOffsetBackingStore pulsarOffsetBackingStore = this;
        synchronized (pulsarOffsetBackingStore) {
            if (this.outstandingReadToEnd != null) {
                this.outstandingReadToEnd.whenComplete((result, cause) -> {
                    if (null != cause) {
                        future.completeExceptionally((Throwable)cause);
                    } else {
                        future.complete((Void)result);
                    }
                });
                return;
            }
            this.outstandingReadToEnd = future;
            future.whenComplete((result, cause) -> {
                PulsarOffsetBackingStore pulsarOffsetBackingStore = this;
                synchronized (pulsarOffsetBackingStore) {
                    this.outstandingReadToEnd = null;
                }
            });
        }
        this.producer.flushAsync().whenComplete((ignored, cause) -> {
            if (null != cause) {
                future.completeExceptionally((Throwable)cause);
            } else {
                this.checkAndReadNext(future);
            }
        });
    }

    private void checkAndReadNext(CompletableFuture<Void> endFuture) {
        this.reader.hasMessageAvailableAsync().whenComplete((hasMessageAvailable, cause) -> {
            if (null != cause) {
                endFuture.completeExceptionally((Throwable)cause);
            } else if (hasMessageAvailable.booleanValue()) {
                this.readNext(endFuture);
            } else {
                endFuture.complete(null);
            }
        });
    }

    private void readNext(CompletableFuture<Void> endFuture) {
        this.reader.readNextAsync().whenComplete((message, cause) -> {
            if (null != cause) {
                endFuture.completeExceptionally((Throwable)cause);
            } else {
                this.processMessage((Message<byte[]>)message);
                this.checkAndReadNext(endFuture);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(Message<byte[]> message) {
        Map<ByteBuffer, ByteBuffer> map = this.data;
        synchronized (map) {
            this.data.put(ByteBuffer.wrap(message.getKey().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap((byte[])message.getValue()));
        }
    }

    public void start() {
        try {
            this.producer = this.client.newProducer(Schema.BYTES).topic(this.topic).create();
            log.info("Successfully created producer to produce updates to topic {}", (Object)this.topic);
            this.reader = this.client.newReader(Schema.BYTES).topic(this.topic).startMessageId(MessageId.earliest).create();
            log.info("Successfully created reader to replay updates from topic {}", (Object)this.topic);
            CompletableFuture<Void> endFuture = new CompletableFuture<Void>();
            this.readToEnd(endFuture);
            endFuture.join();
        }
        catch (PulsarClientException e) {
            log.error("Failed to setup pulsar producer/reader to cluster", (Throwable)e);
            throw new RuntimeException("Failed to setup pulsar producer/reader to cluster ", e);
        }
    }

    public void stop() {
        if (null != this.producer) {
            try {
                this.producer.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close producer", (Throwable)e);
            }
        }
        if (null != this.reader) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                log.warn("Failed to close reader", (Throwable)e);
            }
        }
    }

    public Future<Map<ByteBuffer, ByteBuffer>> get(Collection<ByteBuffer> keys, Callback<Map<ByteBuffer, ByteBuffer>> callback) {
        CompletableFuture<Void> endFuture = new CompletableFuture<Void>();
        this.readToEnd(endFuture);
        return ((CompletableFuture)endFuture.thenApply(ignored -> {
            HashMap<ByteBuffer, ByteBuffer> values = new HashMap<ByteBuffer, ByteBuffer>();
            for (ByteBuffer key : keys) {
                ByteBuffer value;
                Map<ByteBuffer, ByteBuffer> map = this.data;
                synchronized (map) {
                    value = this.data.get(key);
                }
                if (null == value) continue;
                values.put(key, value);
            }
            if (null != callback) {
                callback.onCompletion(null, values);
            }
            return values;
        })).whenComplete((ignored, cause) -> {
            if (null != cause && null != callback) {
                callback.onCompletion(cause, null);
            }
        });
    }

    public Future<Void> set(Map<ByteBuffer, ByteBuffer> values, Callback<Void> callback) {
        values.forEach((key, value) -> {
            ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)key);
            byte[] keyBytes = ByteBufUtil.getBytes((ByteBuf)bb);
            bb = Unpooled.wrappedBuffer((ByteBuffer)value);
            byte[] valBytes = ByteBufUtil.getBytes((ByteBuf)bb);
            this.producer.newMessage().key(new String(keyBytes, StandardCharsets.UTF_8)).value((Object)valBytes).sendAsync();
        });
        return this.producer.flushAsync().whenComplete((ignored, cause) -> {
            if (null != callback) {
                callback.onCompletion(cause, ignored);
            }
            if (null == cause) {
                this.readToEnd(new CompletableFuture<Void>());
            }
        });
    }
}

