/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect.schema;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.io.confluent.connect.avro.AvroData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSchemaToKafkaSchema {
    private static final Logger log = LoggerFactory.getLogger(PulsarSchemaToKafkaSchema.class);
    private static final ImmutableMap<SchemaType, org.apache.kafka.connect.data.Schema> pulsarSchemaTypeToKafkaSchema;
    private static final AvroData avroData;
    private static final Cache<byte[], org.apache.kafka.connect.data.Schema> schemaCache;

    private static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static org.apache.kafka.connect.data.Schema getKafkaConnectSchema(org.apache.pulsar.client.api.Schema pulsarSchema) {
        if (pulsarSchema != null && pulsarSchema.getSchemaInfo() != null) {
            if (pulsarSchemaTypeToKafkaSchema.containsKey((Object)pulsarSchema.getSchemaInfo().getType())) {
                return (org.apache.kafka.connect.data.Schema)pulsarSchemaTypeToKafkaSchema.get((Object)pulsarSchema.getSchemaInfo().getType());
            }
            try {
                return (org.apache.kafka.connect.data.Schema)schemaCache.get((Object)pulsarSchema.getSchemaInfo().getSchema(), () -> {
                    if (pulsarSchema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
                        KeyValueSchema kvSchema = (KeyValueSchema)pulsarSchema;
                        return SchemaBuilder.map((org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getKeySchema()), (org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getValueSchema())).build();
                    }
                    Schema avroSchema = PulsarSchemaToKafkaSchema.parseAvroSchema(new String(pulsarSchema.getSchemaInfo().getSchema(), StandardCharsets.UTF_8));
                    return avroData.toConnectSchema(avroSchema);
                });
            }
            catch (ExecutionError | UncheckedExecutionException | ExecutionException ee) {
                throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Failed to convert to Kafka Schema.", ee);
            }
        }
        throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Schema is required.", null);
    }

    private static IllegalStateException logAndThrowOnUnsupportedSchema(org.apache.pulsar.client.api.Schema pulsarSchema, String prefix, Throwable cause) {
        String msg = prefix + " Pulsar Schema: " + (pulsarSchema == null || pulsarSchema.getSchemaInfo() == null ? "null" : pulsarSchema.getSchemaInfo().toString());
        log.error(msg);
        return new IllegalStateException(msg, cause);
    }

    static {
        avroData = new AvroData(1000);
        schemaCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
        pulsarSchemaTypeToKafkaSchema = ImmutableMap.builder().put((Object)SchemaType.BOOLEAN, (Object)org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).put((Object)SchemaType.INT8, (Object)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).put((Object)SchemaType.INT16, (Object)org.apache.kafka.connect.data.Schema.INT16_SCHEMA).put((Object)SchemaType.INT32, (Object)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).put((Object)SchemaType.INT64, (Object)org.apache.kafka.connect.data.Schema.INT64_SCHEMA).put((Object)SchemaType.FLOAT, (Object)org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA).put((Object)SchemaType.DOUBLE, (Object)org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA).put((Object)SchemaType.STRING, (Object)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).put((Object)SchemaType.BYTES, (Object)org.apache.kafka.connect.data.Schema.BYTES_SCHEMA).put((Object)SchemaType.DATE, (Object)Date.SCHEMA).build();
    }
}

