/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class JdbcSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="Username used to connect to the database specified by `jdbcUrl`")
    private String userName;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="Password used to connect to the database specified by `jdbcUrl`")
    private String password;
    @FieldDoc(required=true, defaultValue="", help="The JDBC url of the database this connector connects to")
    private String jdbcUrl;
    @FieldDoc(required=true, defaultValue="", help="The name of the table this connector writes messages to")
    private String tableName;
    @FieldDoc(required=false, defaultValue="", help="Fields used in update events. A comma-separated list.")
    private String nonKey;
    @FieldDoc(required=false, defaultValue="", help="Fields used in where condition of update and delete Events. A comma-separated list.")
    private String key;
    @FieldDoc(required=false, defaultValue="500", help="The jdbc operation timeout in milliseconds")
    private int timeoutMs = 500;
    @FieldDoc(required=false, defaultValue="200", help="The batch size of updates made to the database")
    private int batchSize = 200;

    public static JdbcSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (JdbcSinkConfig)mapper.readValue(new File(yamlFile), JdbcSinkConfig.class);
    }

    public static JdbcSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JdbcSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), JdbcSinkConfig.class);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNonKey() {
        return this.nonKey;
    }

    public String getKey() {
        return this.key;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public JdbcSinkConfig setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public JdbcSinkConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public JdbcSinkConfig setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public JdbcSinkConfig setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public JdbcSinkConfig setNonKey(String nonKey) {
        this.nonKey = nonKey;
        return this;
    }

    public JdbcSinkConfig setKey(String key) {
        this.key = key;
        return this;
    }

    public JdbcSinkConfig setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public JdbcSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSinkConfig)) {
            return false;
        }
        JdbcSinkConfig other = (JdbcSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$nonKey = this.getNonKey();
        String other$nonKey = other.getNonKey();
        if (this$nonKey == null ? other$nonKey != null : !this$nonKey.equals(other$nonKey)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeoutMs();
        result = result * 59 + this.getBatchSize();
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $nonKey = this.getNonKey();
        result = result * 59 + ($nonKey == null ? 43 : $nonKey.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSinkConfig(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", jdbcUrl=" + this.getJdbcUrl() + ", tableName=" + this.getTableName() + ", nonKey=" + this.getNonKey() + ", key=" + this.getKey() + ", timeoutMs=" + this.getTimeoutMs() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

