/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs2.sink.text;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.hdfs2.sink.HdfsAbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HdfsAbstractTextFileSink<K, V>
extends HdfsAbstractSink<K, V>
implements Sink<V> {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsAbstractTextFileSink.class);
    protected OutputStreamWriter writer;

    @Override
    protected void createWriter() throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.openHdfsStream()), this.getEncoding());
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
        super.close();
    }

    public void write(Record<V> record) {
        try {
            KeyValue kv = this.extractKeyValue(record);
            this.writer.write(kv.getValue().toString());
            if (this.hdfsSinkConfig.getSeparator() != '\u0000') {
                this.writer.write(this.hdfsSinkConfig.getSeparator());
            }
            this.unackedRecords.put(record);
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Unable to write to file " + this.getPath(), (Throwable)e);
            record.fail();
        }
    }

    private OutputStream openHdfsStream() throws IOException {
        if (this.hdfsSinkConfig.getCompression() != null) {
            return this.getCompressionCodec().createOutputStream((OutputStream)this.getHdfsStream());
        }
        return this.getHdfsStream();
    }
}

