/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.canal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.pulsar.io.canal.CanalAbstractSource;
import org.apache.pulsar.io.canal.CanalMessage;
import org.apache.pulsar.io.canal.CanalSourceConfig;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;

@Connector(name="canal", type=IOType.SOURCE, help="The CanalStringSource is used for syncing mysql binlog to Pulsar, easy to use presto sql search.", configClass=CanalSourceConfig.class)
public class CanalStringSource
extends CanalAbstractSource<CanalMessage> {
    private Long messageId;

    @Override
    public Long getMessageId(Message message) {
        this.messageId = message.getId();
        return this.messageId;
    }

    @Override
    public CanalMessage extractValue(List<FlatMessage> flatMessages) {
        String messages = JSON.toJSONString(flatMessages, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        CanalMessage canalMessage = new CanalMessage();
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(FixedDateFormat.FixedFormat.ISO8601_OFFSET_DATE_TIME_HHMM.getPattern());
        canalMessage.setTimestamp(dateFormat.format(date));
        canalMessage.setId(this.messageId);
        canalMessage.setMessage(messages);
        return canalMessage;
    }
}

