/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.batchdiscovery;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.pulsar.io.core.BatchSourceTriggerer;
import org.apache.pulsar.io.core.SourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class CronTriggerer
implements BatchSourceTriggerer {
    private static final Logger log = LoggerFactory.getLogger(CronTriggerer.class);
    public static final String CRON_KEY = "__CRON__";
    private String cronExpression;
    private ThreadPoolTaskScheduler scheduler;

    public void init(Map<String, Object> config, SourceContext sourceContext) {
        if (config != null && !config.containsKey(CRON_KEY)) {
            throw new IllegalArgumentException("Cron Trigger is not provided with Cron String");
        }
        this.cronExpression = (String)Objects.requireNonNull(config).get(CRON_KEY);
        this.scheduler = new ThreadPoolTaskScheduler();
        this.scheduler.setThreadNamePrefix(String.format("%s/%s/%s-cron-triggerer-", sourceContext.getTenant(), sourceContext.getNamespace(), sourceContext.getSourceName()));
        log.info("Initialized CronTrigger with expression: {}", (Object)this.cronExpression);
    }

    public void start(Consumer<String> trigger) {
        this.scheduler.initialize();
        this.scheduler.schedule(() -> trigger.accept("CRON"), (Trigger)new CronTrigger(this.cronExpression));
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }
}

