/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.source.TopicSchema;

public class PulsarCluster {
    private PulsarClient client;
    private PulsarAdmin adminClient;
    private final TopicSchema topicSchema;
    private ProducerBuilderImpl<?> producerBuilder;
    private Map<String, Producer<?>> publishProducers;
    private ThreadLocal<Map<String, Producer<?>>> tlPublishProducers;

    public PulsarCluster(PulsarClient client, PulsarAdmin adminClient, Function.ProducerSpec producerSpec) {
        this.client = client;
        this.adminClient = adminClient;
        this.topicSchema = new TopicSchema(client);
        this.producerBuilder = (ProducerBuilderImpl)client.newProducer().blockIfQueueFull(true).enableBatching(true).batchingMaxPublishDelay(1L, TimeUnit.MILLISECONDS);
        boolean useThreadLocalProducers = false;
        if (producerSpec != null) {
            if (producerSpec.getMaxPendingMessages() != 0) {
                this.producerBuilder.maxPendingMessages(producerSpec.getMaxPendingMessages());
            }
            if (producerSpec.getMaxPendingMessagesAcrossPartitions() != 0) {
                this.producerBuilder.maxPendingMessagesAcrossPartitions(producerSpec.getMaxPendingMessagesAcrossPartitions());
            }
            if (producerSpec.getBatchBuilder() != null) {
                if (producerSpec.getBatchBuilder().equals("KEY_BASED")) {
                    this.producerBuilder.batcherBuilder(BatcherBuilder.KEY_BASED);
                } else {
                    this.producerBuilder.batcherBuilder(BatcherBuilder.DEFAULT);
                }
            }
            useThreadLocalProducers = producerSpec.getUseThreadLocalProducers();
        }
        if (useThreadLocalProducers) {
            this.tlPublishProducers = new ThreadLocal();
        } else {
            this.publishProducers = new HashMap();
        }
    }

    public PulsarClient getClient() {
        return this.client;
    }

    public PulsarAdmin getAdminClient() {
        return this.adminClient;
    }

    public TopicSchema getTopicSchema() {
        return this.topicSchema;
    }

    public ProducerBuilderImpl<?> getProducerBuilder() {
        return this.producerBuilder;
    }

    public Map<String, Producer<?>> getPublishProducers() {
        return this.publishProducers;
    }

    public ThreadLocal<Map<String, Producer<?>>> getTlPublishProducers() {
        return this.tlPublishProducers;
    }
}

