/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import com.google.common.collect.EvictingQueue;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.util.RateLimiter;
import org.apache.pulsar.functions.instance.stats.ComponentStatsManager;
import org.apache.pulsar.functions.proto.InstanceCommunication;

public class SourceStatsManager
extends ComponentStatsManager {
    public static final String PULSAR_SOURCE_METRICS_PREFIX = "pulsar_source_";
    public static final String SYSTEM_EXCEPTIONS_TOTAL = "system_exceptions_total";
    public static final String SOURCE_EXCEPTIONS_TOTAL = "source_exceptions_total";
    public static final String LAST_INVOCATION = "last_invocation";
    public static final String RECEIVED_TOTAL = "received_total";
    public static final String WRITTEN_TOTAL = "written_total";
    public static final String SYSTEM_EXCEPTIONS_TOTAL_1min = "system_exceptions_total_1min";
    public static final String SOURCE_EXCEPTIONS_TOTAL_1min = "source_exceptions_total_1min";
    public static final String RECEIVED_TOTAL_1min = "received_total_1min";
    public static final String WRITTEN_TOTAL_1min = "written_total_1min";
    private final Counter statTotalRecordsReceived;
    private final Counter statTotalSysExceptions;
    private final Counter statTotalSourceExceptions;
    private final Counter statTotalWritten;
    private final Gauge statlastInvocation;
    private final Counter statTotalRecordsReceived1min;
    private final Counter statTotalSysExceptions1min;
    private final Counter statTotalSourceExceptions1min;
    private final Counter statTotalWritten1min;
    final Gauge sysExceptions;
    final Gauge sourceExceptions;
    private final Counter.Child _statTotalRecordsReceived;
    private final Counter.Child _statTotalSysExceptions;
    private final Counter.Child _statTotalSourceExceptions;
    private final Counter.Child _statTotalWritten;
    private final Gauge.Child _statlastInvocation;
    private Counter.Child _statTotalRecordsReceived1min;
    private Counter.Child _statTotalSysExceptions1min;
    private Counter.Child _statTotalSourceExceptions1min;
    private Counter.Child _statTotalWritten1min;
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions = EvictingQueue.create((int)10);
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSourceExceptions = EvictingQueue.create((int)10);
    protected final RateLimiter sysExceptionRateLimiter;
    protected final RateLimiter sourceExceptionRateLimiter;

    public SourceStatsManager(CollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        super(collectorRegistry, metricsLabels, scheduledExecutorService);
        this.statTotalRecordsReceived = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_total")).help("Total number of records received from source.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalRecordsReceived = (Counter.Child)this.statTotalRecordsReceived.labels(metricsLabels);
        this.statTotalSysExceptions = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_total")).help("Total number of system exceptions.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalSysExceptions = (Counter.Child)this.statTotalSysExceptions.labels(metricsLabels);
        this.statTotalSourceExceptions = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_total")).help("Total number of source exceptions.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalSourceExceptions = (Counter.Child)this.statTotalSourceExceptions.labels(metricsLabels);
        this.statTotalWritten = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_total")).help("Total number of records written to a Pulsar topic.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalWritten = (Counter.Child)this.statTotalWritten.labels(metricsLabels);
        this.statlastInvocation = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_last_invocation")).help("The timestamp of the last invocation of the source.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statlastInvocation = (Gauge.Child)this.statlastInvocation.labels(metricsLabels);
        this.statTotalRecordsReceived1min = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_total_1min")).help("Total number of records received from source in the last 1 minute.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(metricsLabels);
        this.statTotalSysExceptions1min = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_total_1min")).help("Total number of system exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(metricsLabels);
        this.statTotalSourceExceptions1min = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_total_1min")).help("Total number of source exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalSourceExceptions1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(metricsLabels);
        this.statTotalWritten1min = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_total_1min")).help("Total number of records written to a Pulsar topic in the last 1 minute.")).labelNames(metricsLabelNames)).register(collectorRegistry);
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(metricsLabels);
        this.sysExceptions = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_system_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from system code.")).register(collectorRegistry);
        this.sourceExceptions = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_source_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from source.")).register(collectorRegistry);
        this.sysExceptionRateLimiter = new RateLimiter(scheduledExecutorService, 5L, 1L, TimeUnit.MINUTES, null);
        this.sourceExceptionRateLimiter = new RateLimiter(scheduledExecutorService, 5L, 1L, TimeUnit.MINUTES, null);
    }

    @Override
    public void reset() {
        this.statTotalRecordsReceived1min.clear();
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(this.metricsLabels);
        this.statTotalSysExceptions1min.clear();
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(this.metricsLabels);
        this.statTotalSourceExceptions1min.clear();
        this._statTotalSourceExceptions1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(this.metricsLabels);
        this.statTotalWritten1min.clear();
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(this.metricsLabels);
    }

    @Override
    public void incrTotalReceived() {
        this._statTotalRecordsReceived.inc();
        this._statTotalRecordsReceived1min.inc();
    }

    @Override
    public void incrTotalProcessedSuccessfully() {
        this._statTotalWritten.inc();
        this._statTotalWritten1min.inc();
    }

    @Override
    public void incrSysExceptions(Throwable ex) {
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSystemExceptions.add((Object)info);
        if (this.sysExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sysExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    @Override
    public void incrUserExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSourceExceptions(Throwable ex) {
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSourceExceptions.add((Object)info);
        if (this.sourceExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sourceExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    private String[] getExceptionMetricsLabels(Throwable ex) {
        String[] exceptionMetricsLabels = Arrays.copyOf(this.metricsLabels, this.metricsLabels.length + 1);
        exceptionMetricsLabels[exceptionMetricsLabels.length - 1] = ex.getMessage() != null ? ex.getMessage() : "";
        return exceptionMetricsLabels;
    }

    @Override
    public void incrSinkExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void setLastInvocation(long ts) {
        this._statlastInvocation.set((double)ts);
    }

    @Override
    public void processTimeStart() {
    }

    @Override
    public void processTimeEnd() {
    }

    @Override
    public double getTotalProcessedSuccessfully() {
        return this._statTotalWritten.get();
    }

    @Override
    public double getTotalRecordsReceived() {
        return this._statTotalRecordsReceived.get();
    }

    @Override
    public double getTotalSysExceptions() {
        return this._statTotalSysExceptions.get();
    }

    @Override
    public double getTotalUserExceptions() {
        return 0.0;
    }

    @Override
    public double getLastInvocation() {
        return this._statlastInvocation.get();
    }

    @Override
    public double getAvgProcessLatency() {
        return 0.0;
    }

    @Override
    public double getTotalProcessedSuccessfully1min() {
        return this._statTotalWritten1min.get();
    }

    @Override
    public double getTotalRecordsReceived1min() {
        return this._statTotalRecordsReceived1min.get();
    }

    @Override
    public double getTotalSysExceptions1min() {
        return this._statTotalSysExceptions1min.get();
    }

    @Override
    public double getTotalUserExceptions1min() {
        return 0.0;
    }

    @Override
    public double getAvgProcessLatency1min() {
        return 0.0;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions() {
        return EvictingQueue.create((int)0);
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions() {
        return this.EMPTY_QUEUE;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions() {
        return this.EMPTY_QUEUE;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions() {
        return EvictingQueue.create((int)0);
    }
}

