/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.cache.ConfigurationMetadataCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.discovery.service.BrokerDiscoveryProvider;
import org.apache.pulsar.discovery.service.ServiceChannelInitializer;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryService
implements Closeable {
    private final ServiceConfig config;
    private String serviceUrl;
    private String serviceUrlTls;
    private ConfigurationMetadataCacheService configurationCacheService;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private BrokerDiscoveryProvider discoveryProvider;
    private final EventLoopGroup acceptorGroup;
    private MetadataStoreExtended localMetadataStore;
    private MetadataStoreExtended configMetadataStore;
    private PulsarResources pulsarResources;
    private final EventLoopGroup workerGroup;
    private final DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-discovery-acceptor");
    private final DefaultThreadFactory workersThreadFactory = new DefaultThreadFactory("pulsar-discovery-io");
    private final int numThreads = Runtime.getRuntime().availableProcessors();
    private Channel channelListen;
    private Channel channelListenTls;
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryService.class);

    public DiscoveryService(ServiceConfig serviceConfig) {
        Preconditions.checkNotNull((Object)serviceConfig);
        this.config = serviceConfig;
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)this.numThreads, (boolean)false, (ThreadFactory)this.workersThreadFactory);
    }

    public void start() throws Exception {
        this.localMetadataStore = this.createLocalMetadataStore();
        this.configMetadataStore = this.createConfigurationMetadataStore();
        this.pulsarResources = new PulsarResources(this.localMetadataStore, this.configMetadataStore);
        this.discoveryProvider = new BrokerDiscoveryProvider(this.config, this.pulsarResources);
        this.configurationCacheService = new ConfigurationMetadataCacheService(this.pulsarResources, null);
        ServiceConfiguration serviceConfiguration = PulsarConfigurationLoader.convertFrom((PulsarConfiguration)this.config);
        this.authenticationService = new AuthenticationService(serviceConfiguration);
        this.authorizationService = new AuthorizationService(serviceConfiguration, (ConfigurationCacheService)this.configurationCacheService);
        this.startServer();
    }

    public void startServer() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PulsarByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        bootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.config, false));
        Preconditions.checkArgument((this.config.getServicePort().isPresent() || this.config.getServicePortTls().isPresent() ? 1 : 0) != 0, (Object)"Either ServicePort or ServicePortTls should be configured.");
        if (this.config.getServicePort().isPresent()) {
            this.channelListen = bootstrap.bind(this.config.getServicePort().get().intValue()).sync().channel();
            LOG.info("Started Pulsar Discovery service on {}", (Object)this.channelListen.localAddress());
        }
        if (this.config.getServicePortTls().isPresent()) {
            ServerBootstrap tlsBootstrap = bootstrap.clone();
            tlsBootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.config, true));
            this.channelListenTls = tlsBootstrap.bind(this.config.getServicePortTls().get().intValue()).sync().channel();
            LOG.info("Started Pulsar Discovery TLS service on port {}", (Object)this.channelListenTls.localAddress());
        }
        this.serviceUrl = this.serviceUrl();
        this.serviceUrlTls = this.serviceUrlTls();
    }

    public BrokerDiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    @Override
    public void close() throws IOException {
        this.discoveryProvider.close();
        this.acceptorGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        try {
            this.localMetadataStore.close();
            this.configMetadataStore.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String host() {
        try {
            if (!this.config.isBindOnLocalhost()) {
                return InetAddress.getLocalHost().getHostName();
            }
            return "localhost";
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("failed to find host", e);
        }
    }

    public String serviceUrl() {
        if (this.config.getServicePort().isPresent()) {
            return "pulsar://" + this.host() + ":" + ((InetSocketAddress)this.channelListen.localAddress()).getPort();
        }
        return null;
    }

    public String serviceUrlTls() {
        if (this.config.getServicePortTls().isPresent()) {
            return "pulsar+ssl://" + this.host() + ":" + ((InetSocketAddress)this.channelListenTls.localAddress()).getPort();
        }
        return null;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public ServiceConfig getConfiguration() {
        return this.config;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ConfigurationCacheService getConfigurationCacheService() {
        return this.configurationCacheService;
    }

    public void setConfigurationCacheService(ConfigurationMetadataCacheService configurationCacheService) {
        this.configurationCacheService = configurationCacheService;
    }

    public MetadataStoreExtended createLocalMetadataStore() throws MetadataStoreException {
        return PulsarResources.createMetadataStore((String)this.config.getZookeeperServers(), (int)this.config.getZookeeperSessionTimeoutMs());
    }

    public MetadataStoreExtended createConfigurationMetadataStore() throws MetadataStoreException {
        return PulsarResources.createMetadataStore((String)this.config.getConfigurationStoreServers(), (int)this.config.getZookeeperSessionTimeoutMs());
    }

    public PulsarResources getPulsarResources() {
        return this.pulsarResources;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }
}

