/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.server;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.Servlet;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManager {
    private final Server server;
    private final ExecutorThreadPool webServiceExecutor;
    private final List<Handler> handlers = Lists.newArrayList();
    private final ServerConnector connector;
    private final ServerConnector connectorTls;
    private static final Logger log = LoggerFactory.getLogger(ServerManager.class);

    public ServerManager(ServiceConfig config) {
        this.webServiceExecutor = new ExecutorThreadPool();
        this.webServiceExecutor.setName("pulsar-external-web");
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        ArrayList connectors = Lists.newArrayList();
        if (config.getWebServicePort().isPresent()) {
            this.connector = new ServerConnector(this.server, 1, 1);
            this.connector.setPort(config.getWebServicePort().get().intValue());
            connectors.add(this.connector);
        } else {
            this.connector = null;
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                SslContextFactory sslCtxFactory = config.isTlsEnabledWithKeyStore() ? KeyStoreSSLContext.createSslContextFactory((String)config.getTlsProvider(), (String)config.getTlsKeyStoreType(), (String)config.getTlsKeyStore(), (String)config.getTlsKeyStorePassword(), (boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustStoreType(), (String)config.getTlsTrustStore(), (String)config.getTlsTrustStorePassword(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (long)config.getTlsCertRefreshCheckDurationSec()) : SecurityUtility.createSslContextFactory((boolean)config.isTlsAllowInsecureConnection(), (String)config.getTlsTrustCertsFilePath(), (String)config.getTlsCertificateFilePath(), (String)config.getTlsKeyFilePath(), (boolean)config.isTlsRequireTrustedClientCertOnConnect(), (boolean)true, (long)config.getTlsCertRefreshCheckDurationSec());
                this.connectorTls = new ServerConnector(this.server, 1, 1, sslCtxFactory);
                this.connectorTls.setPort(config.getWebServicePortTls().get().intValue());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new RestException((Throwable)e);
            }
        } else {
            this.connectorTls = null;
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public URI getServiceUri() {
        return this.server.getURI();
    }

    public void addServlet(String path, Class<? extends Servlet> servlet, Map<String, String> initParameters) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(path);
        ServletHolder holder = new ServletHolder(servlet);
        holder.setInitParameters(initParameters);
        context.addServlet(holder, path);
        this.handlers.add((Handler)context);
    }

    public void start() throws Exception {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setExtended(true);
        requestLog.setLogTimeZone(TimeZone.getDefault().getID());
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.server.setHandler((Handler)handlerCollection);
        this.server.start();
        log.info("Server started at end point {}", (Object)this.getServiceUri());
    }

    public void stop() throws Exception {
        this.server.stop();
        this.webServiceExecutor.stop();
        log.info("Server stopped successfully");
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }
}

