/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pulsar.client.api.ProducerAccessMode;

public class PublisherStats {
    private int count;
    public ProducerAccessMode accessMode;
    public double msgRateIn;
    public double msgThroughputIn;
    public double averageMsgSize;
    public double chunkedMessageRate;
    public long producerId;
    private int producerNameOffset = -1;
    private int producerNameLength;
    private int addressOffset = -1;
    private int addressLength;
    private int connectedSinceOffset = -1;
    private int connectedSinceLength;
    private int clientVersionOffset = -1;
    private int clientVersionLength;
    private StringBuilder stringBuffer = new StringBuilder();
    public Map<String, String> metadata;

    public PublisherStats add(PublisherStats stats) {
        double newAverageMsgSize;
        Preconditions.checkNotNull((Object)stats);
        ++this.count;
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.averageMsgSize = newAverageMsgSize = (this.averageMsgSize * (double)(this.count - 1) + stats.averageMsgSize) / (double)this.count;
        return this;
    }

    public String getProducerName() {
        return this.producerNameOffset == -1 ? null : this.stringBuffer.substring(this.producerNameOffset, this.producerNameOffset + this.producerNameLength);
    }

    public void setProducerName(String producerName) {
        if (producerName == null) {
            this.producerNameOffset = -1;
            return;
        }
        this.producerNameOffset = this.stringBuffer.length();
        this.producerNameLength = producerName.length();
        this.stringBuffer.append(producerName);
    }

    public String getAddress() {
        return this.addressOffset == -1 ? null : this.stringBuffer.substring(this.addressOffset, this.addressOffset + this.addressLength);
    }

    public void setAddress(String address) {
        if (address == null) {
            this.addressOffset = -1;
            return;
        }
        this.addressOffset = this.stringBuffer.length();
        this.addressLength = address.length();
        this.stringBuffer.append(address);
    }

    public String getConnectedSince() {
        return this.connectedSinceOffset == -1 ? null : this.stringBuffer.substring(this.connectedSinceOffset, this.connectedSinceOffset + this.connectedSinceLength);
    }

    public void setConnectedSince(String connectedSince) {
        if (connectedSince == null) {
            this.connectedSinceOffset = -1;
            return;
        }
        this.connectedSinceOffset = this.stringBuffer.length();
        this.connectedSinceLength = connectedSince.length();
        this.stringBuffer.append(connectedSince);
    }

    public String getClientVersion() {
        return this.clientVersionOffset == -1 ? null : this.stringBuffer.substring(this.clientVersionOffset, this.clientVersionOffset + this.clientVersionLength);
    }

    public void setClientVersion(String clientVersion) {
        if (clientVersion == null) {
            this.clientVersionOffset = -1;
            return;
        }
        this.clientVersionOffset = this.stringBuffer.length();
        this.clientVersionLength = clientVersion.length();
        this.stringBuffer.append(clientVersion);
    }
}

