/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.util.RestException;

public class Policies {
    public final AuthPolicies auth_policies = new AuthPolicies();
    public Set<String> replication_clusters = Sets.newHashSet();
    public BundlesData bundles;
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = Maps.newHashMap();
    @Deprecated
    public Map<String, DispatchRate> clusterDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> topicDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> subscriptionDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> replicatorDispatchRate = Maps.newHashMap();
    public Map<String, SubscribeRate> clusterSubscribeRate = Maps.newHashMap();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public AutoTopicCreationOverride autoTopicCreationOverride = null;
    public AutoSubscriptionCreationOverride autoSubscriptionCreationOverride = null;
    public Map<String, PublishRate> publishMaxMessageRate = Maps.newHashMap();
    public Map<String, Integer> latency_stats_sample_rate = Maps.newHashMap();
    public Integer message_ttl_in_seconds = null;
    public int subscription_expiration_time_minutes = 0;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";
    public boolean encryption_required = false;
    public DelayedDeliveryPolicies delayed_delivery_policies = null;
    public InactiveTopicPolicies inactive_topic_policies = null;
    public SubscriptionAuthMode subscription_auth_mode = SubscriptionAuthMode.None;
    public Integer max_producers_per_topic = null;
    public Integer max_consumers_per_topic = null;
    public Integer max_consumers_per_subscription = null;
    public Integer max_unacked_messages_per_consumer = null;
    public Integer max_unacked_messages_per_subscription = null;
    public Integer max_subscriptions_per_topic = null;
    public Long compaction_threshold = null;
    public long offload_threshold = -1L;
    public Long offload_deletion_lag_ms = null;
    public Integer max_topics_per_namespace = null;
    @Deprecated
    public SchemaAutoUpdateCompatibilityStrategy schema_auto_update_compatibility_strategy = SchemaAutoUpdateCompatibilityStrategy.Full;
    public SchemaCompatibilityStrategy schema_compatibility_strategy = SchemaCompatibilityStrategy.UNDEFINED;
    public boolean is_allow_auto_update_schema = true;
    public boolean schema_validation_enforced = false;
    public OffloadPolicies offload_policies = null;
    public Integer deduplicationSnapshotIntervalSeconds = null;
    public Set<CommandSubscribe.SubType> subscription_types_enabled = Sets.newHashSet();
    public Map<String, String> properties = Maps.newHashMap();
    public String resource_group_name = null;
    private static final long MAX_BUNDLES = 0x100000000L;

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth_policies, this.replication_clusters, this.backlog_quota_map, this.publishMaxMessageRate, this.clusterDispatchRate, this.topicDispatchRate, this.subscriptionDispatchRate, this.replicatorDispatchRate, this.clusterSubscribeRate, this.deduplicationEnabled, this.autoTopicCreationOverride, this.autoSubscriptionCreationOverride, this.persistence, this.bundles, this.latency_stats_sample_rate, this.message_ttl_in_seconds, this.subscription_expiration_time_minutes, this.retention_policies, this.encryption_required, this.delayed_delivery_policies, this.inactive_topic_policies, this.subscription_auth_mode, this.max_producers_per_topic, this.max_consumers_per_topic, this.max_consumers_per_subscription, this.max_unacked_messages_per_consumer, this.max_unacked_messages_per_subscription, this.compaction_threshold, this.offload_threshold, this.offload_deletion_lag_ms, this.schema_auto_update_compatibility_strategy, this.schema_validation_enforced, this.schema_compatibility_strategy, this.is_allow_auto_update_schema, this.offload_policies, this.subscription_types_enabled, this.properties, this.resource_group_name});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.clusterDispatchRate, other.clusterDispatchRate) && Objects.equals(this.topicDispatchRate, other.topicDispatchRate) && Objects.equals(this.subscriptionDispatchRate, other.subscriptionDispatchRate) && Objects.equals(this.replicatorDispatchRate, other.replicatorDispatchRate) && Objects.equals(this.clusterSubscribeRate, other.clusterSubscribeRate) && Objects.equals(this.publishMaxMessageRate, other.publishMaxMessageRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.autoTopicCreationOverride, other.autoTopicCreationOverride) && Objects.equals(this.autoSubscriptionCreationOverride, other.autoSubscriptionCreationOverride) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && Objects.equals(this.message_ttl_in_seconds, other.message_ttl_in_seconds) && Objects.equals(this.subscription_expiration_time_minutes, other.subscription_expiration_time_minutes) && Objects.equals(this.retention_policies, other.retention_policies) && Objects.equals(this.encryption_required, other.encryption_required) && Objects.equals(this.delayed_delivery_policies, other.delayed_delivery_policies) && Objects.equals(this.inactive_topic_policies, other.inactive_topic_policies) && Objects.equals((Object)this.subscription_auth_mode, (Object)other.subscription_auth_mode) && Objects.equals(this.max_producers_per_topic, other.max_producers_per_topic) && Objects.equals(this.max_consumers_per_topic, other.max_consumers_per_topic) && Objects.equals(this.max_unacked_messages_per_consumer, other.max_unacked_messages_per_consumer) && Objects.equals(this.max_unacked_messages_per_subscription, other.max_unacked_messages_per_subscription) && Objects.equals(this.max_consumers_per_subscription, other.max_consumers_per_subscription) && Objects.equals(this.compaction_threshold, other.compaction_threshold) && this.offload_threshold == other.offload_threshold && Objects.equals(this.offload_deletion_lag_ms, other.offload_deletion_lag_ms) && this.schema_auto_update_compatibility_strategy == other.schema_auto_update_compatibility_strategy && this.schema_validation_enforced == other.schema_validation_enforced && this.schema_compatibility_strategy == other.schema_compatibility_strategy && this.is_allow_auto_update_schema == other.is_allow_auto_update_schema && Objects.equals(this.offload_policies, other.offload_policies) && Objects.equals(this.subscription_types_enabled, other.subscription_types_enabled) && Objects.equals(this.properties, other.properties) && Objects.equals(this.resource_group_name, other.resource_group_name);
        }
        return false;
    }

    public static BundlesData defaultBundle() {
        BundlesData bundle = new BundlesData(1);
        ArrayList boundaries = Lists.newArrayList();
        boundaries.add(FIRST_BOUNDARY);
        boundaries.add(LAST_BOUNDARY);
        bundle.setBoundaries(boundaries);
        return bundle;
    }

    public static void setStorageQuota(Policies polices, BacklogQuota quota) {
        if (polices == null) {
            return;
        }
        polices.backlog_quota_map.put(BacklogQuota.BacklogQuotaType.destination_storage, quota);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("auth_policies", (Object)this.auth_policies).add("replication_clusters", this.replication_clusters).add("bundles", (Object)this.bundles).add("backlog_quota_map", this.backlog_quota_map).add("persistence", (Object)this.persistence).add("deduplicationEnabled", (Object)this.deduplicationEnabled).add("autoTopicCreationOverride", (Object)this.autoTopicCreationOverride).add("autoSubscriptionCreationOverride", (Object)this.autoSubscriptionCreationOverride).add("clusterDispatchRate", this.clusterDispatchRate).add("topicDispatchRate", this.topicDispatchRate).add("subscriptionDispatchRate", this.subscriptionDispatchRate).add("replicatorDispatchRate", this.replicatorDispatchRate).add("clusterSubscribeRate", this.clusterSubscribeRate).add("publishMaxMessageRate", this.publishMaxMessageRate).add("latency_stats_sample_rate", this.latency_stats_sample_rate).add("message_ttl_in_seconds", (Object)this.message_ttl_in_seconds).add("subscription_expiration_time_minutes", this.subscription_expiration_time_minutes).add("retention_policies", (Object)this.retention_policies).add("deleted", this.deleted).add("encryption_required", this.encryption_required).add("delayed_delivery_policies", (Object)this.delayed_delivery_policies).add("inactive_topic_policies", (Object)this.inactive_topic_policies).add("subscription_auth_mode", (Object)this.subscription_auth_mode).add("max_producers_per_topic", (Object)this.max_producers_per_topic).add("max_consumers_per_topic", (Object)this.max_consumers_per_topic).add("max_consumers_per_subscription", (Object)this.max_consumers_per_topic).add("max_unacked_messages_per_consumer", (Object)this.max_unacked_messages_per_consumer).add("max_unacked_messages_per_subscription", (Object)this.max_unacked_messages_per_subscription).add("compaction_threshold", (Object)this.compaction_threshold).add("offload_threshold", this.offload_threshold).add("offload_deletion_lag_ms", (Object)this.offload_deletion_lag_ms).add("schema_auto_update_compatibility_strategy", (Object)this.schema_auto_update_compatibility_strategy).add("schema_validation_enforced", this.schema_validation_enforced).add("schema_compatibility_Strategy", (Object)this.schema_compatibility_strategy).add("is_allow_auto_update_Schema", this.is_allow_auto_update_schema).add("offload_policies", (Object)this.offload_policies).add("subscription_types_enabled", this.subscription_types_enabled).add("properties", this.properties).add("resource_group_name", (Object)this.resource_group_name).toString();
    }

    public static BundlesData getBundles(int numBundles) {
        if (numBundles <= 0) {
            throw new RestException(Response.Status.BAD_REQUEST, "Invalid number of bundles. Number of numbles has to be in the range of (0, 2^32].");
        }
        Long maxVal = 0x100000000L;
        Long segSize = maxVal / (long)numBundles;
        ArrayList partitions = Lists.newArrayList();
        partitions.add(String.format("0x%08x", 0L));
        Long curPartition = segSize;
        for (int i = 0; i < numBundles; ++i) {
            if (i != numBundles - 1) {
                partitions.add(String.format("0x%08x", curPartition));
            } else {
                partitions.add(String.format("0x%08x", maxVal - 1L));
            }
            curPartition = curPartition + segSize;
        }
        return new BundlesData(partitions);
    }
}

