/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.FieldParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadPolicies
implements Serializable {
    private static final Logger log;
    private static final long serialVersionUID = 0L;
    private static final List<Field> CONFIGURATION_FIELDS;
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 0x4000000;
    public static final int DEFAULT_READ_BUFFER_SIZE_IN_BYTES = 0x100000;
    public static final int DEFAULT_OFFLOAD_MAX_THREADS = 2;
    public static final int DEFAULT_OFFLOAD_MAX_PREFETCH_ROUNDS = 1;
    public static final ImmutableList<String> DRIVER_NAMES;
    public static final String DEFAULT_OFFLOADER_DIRECTORY = "./offloaders";
    public static final Long DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
    public static final Long DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
    public static final String OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE = "managedLedgerOffloadAutoTriggerSizeThresholdBytes";
    public static final String DELETION_LAG_NAME_IN_CONF_FILE = "managedLedgerOffloadDeletionLagMs";
    public static final OffloadedReadPriority DEFAULT_OFFLOADED_READ_PRIORITY;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String offloadersDirectory = "./offloaders";
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadDriver = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadMaxThreads = 2;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadPrefetchRounds = 1;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Long managedLedgerOffloadThresholdInBytes = DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Long managedLedgerOffloadDeletionLagInMillis = DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private OffloadedReadPriority managedLedgerOffloadedReadPriority = DEFAULT_OFFLOADED_READ_PRIORITY;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRegion = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadBucket = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadServiceEndpoint = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer s3ManagedLedgerOffloadMaxBlockSizeInBytes = 0x4000000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer s3ManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadCredentialId = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadCredentialSecret = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRole = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRoleSessionName = "pulsar-s3-offload";
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadRegion = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadBucket = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer gcsManagedLedgerOffloadMaxBlockSizeInBytes = 0x4000000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer gcsManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadServiceAccountKeyFile = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String fileSystemProfilePath = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String fileSystemURI = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadBucket;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadRegion;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadServiceEndpoint;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadMaxBlockSizeInBytes;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadReadBufferSizeInBytes;

    public static OffloadPolicies create(String driver, String region, String bucket, String endpoint, String role, String roleSessionName, String credentialId, String credentialSecret, Integer maxBlockSizeInBytes, Integer readBufferSizeInBytes, Long offloadThresholdInBytes, Long offloadDeletionLagInMillis, OffloadedReadPriority readPriority) {
        OffloadPolicies offloadPolicies = new OffloadPolicies();
        offloadPolicies.setManagedLedgerOffloadDriver(driver);
        offloadPolicies.setManagedLedgerOffloadThresholdInBytes(offloadThresholdInBytes);
        offloadPolicies.setManagedLedgerOffloadDeletionLagInMillis(offloadDeletionLagInMillis);
        offloadPolicies.setManagedLedgerOffloadBucket(bucket);
        offloadPolicies.setManagedLedgerOffloadRegion(region);
        offloadPolicies.setManagedLedgerOffloadServiceEndpoint(endpoint);
        offloadPolicies.setManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes);
        offloadPolicies.setManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        offloadPolicies.setManagedLedgerOffloadedReadPriority(readPriority);
        if (driver.equalsIgnoreCase((String)DRIVER_NAMES.get(0)) || driver.equalsIgnoreCase((String)DRIVER_NAMES.get(1))) {
            if (role != null) {
                offloadPolicies.setS3ManagedLedgerOffloadRole(role);
            }
            if (roleSessionName != null) {
                offloadPolicies.setS3ManagedLedgerOffloadRoleSessionName(roleSessionName);
            }
            if (credentialId != null) {
                offloadPolicies.setS3ManagedLedgerOffloadCredentialId(credentialId);
            }
            if (credentialSecret != null) {
                offloadPolicies.setS3ManagedLedgerOffloadCredentialSecret(credentialSecret);
            }
            offloadPolicies.setS3ManagedLedgerOffloadRegion(region);
            offloadPolicies.setS3ManagedLedgerOffloadBucket(bucket);
            offloadPolicies.setS3ManagedLedgerOffloadServiceEndpoint(endpoint);
            offloadPolicies.setS3ManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes);
            offloadPolicies.setS3ManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        } else if (driver.equalsIgnoreCase((String)DRIVER_NAMES.get(2))) {
            offloadPolicies.setGcsManagedLedgerOffloadRegion(region);
            offloadPolicies.setGcsManagedLedgerOffloadBucket(bucket);
            offloadPolicies.setGcsManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes);
            offloadPolicies.setGcsManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        }
        return offloadPolicies;
    }

    public static OffloadPolicies create(Properties properties) {
        OffloadPolicies data = new OffloadPolicies();
        Field[] fields = OffloadPolicies.class.getDeclaredFields();
        Arrays.stream(fields).forEach(f -> {
            if (properties.containsKey(f.getName())) {
                try {
                    f.setAccessible(true);
                    f.set(data, FieldParser.value((String)properties.get(f.getName()), f));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
                }
            }
        });
        data.compatibleWithBrokerConfigFile(properties);
        return data;
    }

    private void compatibleWithBrokerConfigFile(Properties properties) {
        if (!properties.containsKey("managedLedgerOffloadThresholdInBytes") && properties.containsKey(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)) {
            this.setManagedLedgerOffloadThresholdInBytes(Long.parseLong(properties.getProperty(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)));
        }
        if (!properties.containsKey("managedLedgerOffloadDeletionLagInMillis") && properties.containsKey(DELETION_LAG_NAME_IN_CONF_FILE)) {
            this.setManagedLedgerOffloadDeletionLagInMillis(Long.parseLong(properties.getProperty(DELETION_LAG_NAME_IN_CONF_FILE)));
        }
    }

    public boolean driverSupported() {
        return DRIVER_NAMES.stream().anyMatch(d -> d.equalsIgnoreCase(this.managedLedgerOffloadDriver));
    }

    public static String getSupportedDriverNames() {
        return StringUtils.join(DRIVER_NAMES, (String)",");
    }

    public boolean isS3Driver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(0)) || this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(1));
    }

    public boolean isGcsDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(2));
    }

    public boolean isFileSystemDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(3));
    }

    public boolean bucketValid() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.managedLedgerOffloadBucket)) {
            return true;
        }
        if (this.isS3Driver()) {
            return StringUtils.isNotEmpty((CharSequence)this.s3ManagedLedgerOffloadBucket);
        }
        if (this.isGcsDriver()) {
            return StringUtils.isNotEmpty((CharSequence)this.gcsManagedLedgerOffloadBucket);
        }
        return this.isFileSystemDriver();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.managedLedgerOffloadedReadPriority, this.managedLedgerOffloadDriver, this.managedLedgerOffloadMaxThreads, this.managedLedgerOffloadPrefetchRounds, this.managedLedgerOffloadThresholdInBytes, this.managedLedgerOffloadDeletionLagInMillis, this.s3ManagedLedgerOffloadRegion, this.s3ManagedLedgerOffloadBucket, this.s3ManagedLedgerOffloadServiceEndpoint, this.s3ManagedLedgerOffloadMaxBlockSizeInBytes, this.s3ManagedLedgerOffloadReadBufferSizeInBytes, this.s3ManagedLedgerOffloadRole, this.s3ManagedLedgerOffloadRoleSessionName, this.gcsManagedLedgerOffloadRegion, this.gcsManagedLedgerOffloadBucket, this.gcsManagedLedgerOffloadMaxBlockSizeInBytes, this.gcsManagedLedgerOffloadReadBufferSizeInBytes, this.gcsManagedLedgerOffloadServiceAccountKeyFile, this.fileSystemProfilePath, this.fileSystemURI, this.managedLedgerOffloadBucket, this.managedLedgerOffloadRegion, this.managedLedgerOffloadServiceEndpoint, this.managedLedgerOffloadMaxBlockSizeInBytes, this.managedLedgerOffloadReadBufferSizeInBytes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OffloadPolicies other = (OffloadPolicies)obj;
        return Objects.equals((Object)this.managedLedgerOffloadedReadPriority, (Object)other.getManagedLedgerOffloadedReadPriority()) && Objects.equals(this.managedLedgerOffloadDriver, other.getManagedLedgerOffloadDriver()) && Objects.equals(this.managedLedgerOffloadMaxThreads, other.getManagedLedgerOffloadMaxThreads()) && Objects.equals(this.managedLedgerOffloadPrefetchRounds, other.getManagedLedgerOffloadPrefetchRounds()) && Objects.equals(this.managedLedgerOffloadThresholdInBytes, other.getManagedLedgerOffloadThresholdInBytes()) && Objects.equals(this.managedLedgerOffloadDeletionLagInMillis, other.getManagedLedgerOffloadDeletionLagInMillis()) && Objects.equals(this.s3ManagedLedgerOffloadRegion, other.getS3ManagedLedgerOffloadRegion()) && Objects.equals(this.s3ManagedLedgerOffloadBucket, other.getS3ManagedLedgerOffloadBucket()) && Objects.equals(this.s3ManagedLedgerOffloadServiceEndpoint, other.getS3ManagedLedgerOffloadServiceEndpoint()) && Objects.equals(this.s3ManagedLedgerOffloadMaxBlockSizeInBytes, other.getS3ManagedLedgerOffloadMaxBlockSizeInBytes()) && Objects.equals(this.s3ManagedLedgerOffloadReadBufferSizeInBytes, other.getS3ManagedLedgerOffloadReadBufferSizeInBytes()) && Objects.equals(this.s3ManagedLedgerOffloadRole, other.getS3ManagedLedgerOffloadRole()) && Objects.equals(this.s3ManagedLedgerOffloadRoleSessionName, other.getS3ManagedLedgerOffloadRoleSessionName()) && Objects.equals(this.gcsManagedLedgerOffloadRegion, other.getGcsManagedLedgerOffloadRegion()) && Objects.equals(this.gcsManagedLedgerOffloadBucket, other.getGcsManagedLedgerOffloadBucket()) && Objects.equals(this.gcsManagedLedgerOffloadMaxBlockSizeInBytes, other.getGcsManagedLedgerOffloadMaxBlockSizeInBytes()) && Objects.equals(this.gcsManagedLedgerOffloadReadBufferSizeInBytes, other.getGcsManagedLedgerOffloadReadBufferSizeInBytes()) && Objects.equals(this.gcsManagedLedgerOffloadServiceAccountKeyFile, other.getGcsManagedLedgerOffloadServiceAccountKeyFile()) && Objects.equals(this.fileSystemProfilePath, other.getFileSystemProfilePath()) && Objects.equals(this.fileSystemURI, other.getFileSystemURI()) && Objects.equals(this.managedLedgerOffloadBucket, other.getManagedLedgerOffloadBucket()) && Objects.equals(this.managedLedgerOffloadRegion, other.getManagedLedgerOffloadRegion()) && Objects.equals(this.managedLedgerOffloadServiceEndpoint, other.getManagedLedgerOffloadServiceEndpoint()) && Objects.equals(this.managedLedgerOffloadMaxBlockSizeInBytes, other.getManagedLedgerOffloadMaxBlockSizeInBytes()) && Objects.equals(this.managedLedgerOffloadReadBufferSizeInBytes, other.getManagedLedgerOffloadReadBufferSizeInBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("managedLedgerOffloadedReadPriority", (Object)this.managedLedgerOffloadedReadPriority).add("managedLedgerOffloadDriver", (Object)this.managedLedgerOffloadDriver).add("managedLedgerOffloadMaxThreads", (Object)this.managedLedgerOffloadMaxThreads).add("managedLedgerOffloadPrefetchRounds", (Object)this.managedLedgerOffloadPrefetchRounds).add(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE, (Object)this.managedLedgerOffloadThresholdInBytes).add("managedLedgerOffloadDeletionLagInMillis", (Object)this.managedLedgerOffloadDeletionLagInMillis).add("s3ManagedLedgerOffloadRegion", (Object)this.s3ManagedLedgerOffloadRegion).add("s3ManagedLedgerOffloadBucket", (Object)this.s3ManagedLedgerOffloadBucket).add("s3ManagedLedgerOffloadServiceEndpoint", (Object)this.s3ManagedLedgerOffloadServiceEndpoint).add("s3ManagedLedgerOffloadMaxBlockSizeInBytes", (Object)this.s3ManagedLedgerOffloadMaxBlockSizeInBytes).add("s3ManagedLedgerOffloadReadBufferSizeInBytes", (Object)this.s3ManagedLedgerOffloadReadBufferSizeInBytes).add("s3ManagedLedgerOffloadRole", (Object)this.s3ManagedLedgerOffloadRole).add("s3ManagedLedgerOffloadRoleSessionName", (Object)this.s3ManagedLedgerOffloadRoleSessionName).add("gcsManagedLedgerOffloadRegion", (Object)this.gcsManagedLedgerOffloadRegion).add("gcsManagedLedgerOffloadBucket", (Object)this.gcsManagedLedgerOffloadBucket).add("gcsManagedLedgerOffloadMaxBlockSizeInBytes", (Object)this.gcsManagedLedgerOffloadMaxBlockSizeInBytes).add("gcsManagedLedgerOffloadReadBufferSizeInBytes", (Object)this.gcsManagedLedgerOffloadReadBufferSizeInBytes).add("gcsManagedLedgerOffloadServiceAccountKeyFile", (Object)this.gcsManagedLedgerOffloadServiceAccountKeyFile).add("fileSystemProfilePath", (Object)this.fileSystemProfilePath).add("fileSystemURI", (Object)this.fileSystemURI).add("managedLedgerOffloadBucket", (Object)this.managedLedgerOffloadBucket).add("managedLedgerOffloadRegion", (Object)this.managedLedgerOffloadRegion).add("managedLedgerOffloadServiceEndpoint", (Object)this.managedLedgerOffloadServiceEndpoint).add("managedLedgerOffloadMaxBlockSizeInBytes", (Object)this.managedLedgerOffloadMaxBlockSizeInBytes).add("managedLedgerOffloadReadBufferSizeInBytes", (Object)this.managedLedgerOffloadReadBufferSizeInBytes).toString();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadedReadPriority", (Object)this.getManagedLedgerOffloadedReadPriority());
        OffloadPolicies.setProperty(properties, "offloadersDirectory", this.getOffloadersDirectory());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadDriver", this.getManagedLedgerOffloadDriver());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadMaxThreads", this.getManagedLedgerOffloadMaxThreads());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadPrefetchRounds", this.getManagedLedgerOffloadPrefetchRounds());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadThresholdInBytes", this.getManagedLedgerOffloadThresholdInBytes());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadDeletionLagInMillis", this.getManagedLedgerOffloadDeletionLagInMillis());
        if (this.isS3Driver()) {
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadRegion", this.getS3ManagedLedgerOffloadRegion());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadBucket", this.getS3ManagedLedgerOffloadBucket());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadServiceEndpoint", this.getS3ManagedLedgerOffloadServiceEndpoint());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadMaxBlockSizeInBytes", this.getS3ManagedLedgerOffloadMaxBlockSizeInBytes());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadCredentialId", this.getS3ManagedLedgerOffloadCredentialId());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadCredentialSecret", this.getS3ManagedLedgerOffloadCredentialSecret());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadRole", this.getS3ManagedLedgerOffloadRole());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadRoleSessionName", this.getS3ManagedLedgerOffloadRoleSessionName());
            OffloadPolicies.setProperty(properties, "s3ManagedLedgerOffloadReadBufferSizeInBytes", this.getS3ManagedLedgerOffloadReadBufferSizeInBytes());
        } else if (this.isGcsDriver()) {
            OffloadPolicies.setProperty(properties, "gcsManagedLedgerOffloadRegion", this.getGcsManagedLedgerOffloadRegion());
            OffloadPolicies.setProperty(properties, "gcsManagedLedgerOffloadBucket", this.getGcsManagedLedgerOffloadBucket());
            OffloadPolicies.setProperty(properties, "gcsManagedLedgerOffloadMaxBlockSizeInBytes", this.getGcsManagedLedgerOffloadMaxBlockSizeInBytes());
            OffloadPolicies.setProperty(properties, "gcsManagedLedgerOffloadReadBufferSizeInBytes", this.getGcsManagedLedgerOffloadReadBufferSizeInBytes());
            OffloadPolicies.setProperty(properties, "gcsManagedLedgerOffloadServiceAccountKeyFile", this.getGcsManagedLedgerOffloadServiceAccountKeyFile());
        } else if (this.isFileSystemDriver()) {
            OffloadPolicies.setProperty(properties, "fileSystemProfilePath", this.getFileSystemProfilePath());
            OffloadPolicies.setProperty(properties, "fileSystemURI", this.getFileSystemURI());
        }
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadBucket", this.getManagedLedgerOffloadBucket());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadRegion", this.getManagedLedgerOffloadRegion());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadServiceEndpoint", this.getManagedLedgerOffloadServiceEndpoint());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadMaxBlockSizeInBytes", this.getManagedLedgerOffloadMaxBlockSizeInBytes());
        OffloadPolicies.setProperty(properties, "managedLedgerOffloadReadBufferSizeInBytes", this.getManagedLedgerOffloadReadBufferSizeInBytes());
        return properties;
    }

    private static void setProperty(Properties properties, String key, Object value) {
        if (value != null) {
            properties.setProperty(key, "" + value);
        }
    }

    public static OffloadPolicies oldPoliciesCompatible(OffloadPolicies nsLevelPolicies, Policies policies) {
        if (policies == null || policies.offload_threshold == -1L && policies.offload_deletion_lag_ms == null) {
            return nsLevelPolicies;
        }
        if (nsLevelPolicies == null) {
            nsLevelPolicies = new OffloadPolicies();
        }
        if (nsLevelPolicies.getManagedLedgerOffloadThresholdInBytes() == null && policies.offload_threshold != -1L) {
            nsLevelPolicies.setManagedLedgerOffloadThresholdInBytes(policies.offload_threshold);
        }
        if (nsLevelPolicies.getManagedLedgerOffloadDeletionLagInMillis() == null && policies.offload_deletion_lag_ms != null) {
            nsLevelPolicies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
        }
        return nsLevelPolicies;
    }

    public static OffloadPolicies mergeConfiguration(OffloadPolicies topicLevelPolicies, OffloadPolicies nsLevelPolicies, Properties brokerProperties) {
        try {
            boolean allConfigValuesAreNull = true;
            OffloadPolicies offloadPolicies = new OffloadPolicies();
            for (Field field : CONFIGURATION_FIELDS) {
                Object object = topicLevelPolicies != null && field.get(topicLevelPolicies) != null ? field.get(topicLevelPolicies) : (nsLevelPolicies != null && field.get(nsLevelPolicies) != null ? field.get(nsLevelPolicies) : OffloadPolicies.getCompatibleValue(brokerProperties, field));
                if (object == null) continue;
                field.set(offloadPolicies, object);
                if (!allConfigValuesAreNull) continue;
                allConfigValuesAreNull = false;
            }
            if (allConfigValuesAreNull) {
                return null;
            }
            return offloadPolicies;
        }
        catch (Exception e) {
            log.error("Failed to merge configuration.", (Throwable)e);
            return null;
        }
    }

    private static Object getCompatibleValue(Properties properties, Field field) {
        Object object = field.getName().equals("managedLedgerOffloadThresholdInBytes") ? properties.getProperty("managedLedgerOffloadThresholdInBytes", properties.getProperty(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)) : (field.getName().equals("managedLedgerOffloadDeletionLagInMillis") ? properties.getProperty("managedLedgerOffloadDeletionLagInMillis", properties.getProperty(DELETION_LAG_NAME_IN_CONF_FILE)) : properties.get(field.getName()));
        return FieldParser.value((String)object, field);
    }

    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    public Integer getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    public Integer getManagedLedgerOffloadPrefetchRounds() {
        return this.managedLedgerOffloadPrefetchRounds;
    }

    public Long getManagedLedgerOffloadThresholdInBytes() {
        return this.managedLedgerOffloadThresholdInBytes;
    }

    public Long getManagedLedgerOffloadDeletionLagInMillis() {
        return this.managedLedgerOffloadDeletionLagInMillis;
    }

    public OffloadedReadPriority getManagedLedgerOffloadedReadPriority() {
        return this.managedLedgerOffloadedReadPriority;
    }

    public String getS3ManagedLedgerOffloadRegion() {
        return this.s3ManagedLedgerOffloadRegion;
    }

    public String getS3ManagedLedgerOffloadBucket() {
        return this.s3ManagedLedgerOffloadBucket;
    }

    public String getS3ManagedLedgerOffloadServiceEndpoint() {
        return this.s3ManagedLedgerOffloadServiceEndpoint;
    }

    public Integer getS3ManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public Integer getS3ManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public String getS3ManagedLedgerOffloadCredentialId() {
        return this.s3ManagedLedgerOffloadCredentialId;
    }

    public String getS3ManagedLedgerOffloadCredentialSecret() {
        return this.s3ManagedLedgerOffloadCredentialSecret;
    }

    public String getS3ManagedLedgerOffloadRole() {
        return this.s3ManagedLedgerOffloadRole;
    }

    public String getS3ManagedLedgerOffloadRoleSessionName() {
        return this.s3ManagedLedgerOffloadRoleSessionName;
    }

    public String getGcsManagedLedgerOffloadRegion() {
        return this.gcsManagedLedgerOffloadRegion;
    }

    public String getGcsManagedLedgerOffloadBucket() {
        return this.gcsManagedLedgerOffloadBucket;
    }

    public Integer getGcsManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public Integer getGcsManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public String getGcsManagedLedgerOffloadServiceAccountKeyFile() {
        return this.gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    public String getFileSystemProfilePath() {
        return this.fileSystemProfilePath;
    }

    public String getFileSystemURI() {
        return this.fileSystemURI;
    }

    public String getManagedLedgerOffloadBucket() {
        return this.managedLedgerOffloadBucket;
    }

    public String getManagedLedgerOffloadRegion() {
        return this.managedLedgerOffloadRegion;
    }

    public String getManagedLedgerOffloadServiceEndpoint() {
        return this.managedLedgerOffloadServiceEndpoint;
    }

    public Integer getManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.managedLedgerOffloadMaxBlockSizeInBytes;
    }

    public Integer getManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.managedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setOffloadersDirectory(String offloadersDirectory) {
        this.offloadersDirectory = offloadersDirectory;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadMaxThreads(Integer managedLedgerOffloadMaxThreads) {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadPrefetchRounds(Integer managedLedgerOffloadPrefetchRounds) {
        this.managedLedgerOffloadPrefetchRounds = managedLedgerOffloadPrefetchRounds;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadThresholdInBytes(Long managedLedgerOffloadThresholdInBytes) {
        this.managedLedgerOffloadThresholdInBytes = managedLedgerOffloadThresholdInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadDeletionLagInMillis(Long managedLedgerOffloadDeletionLagInMillis) {
        this.managedLedgerOffloadDeletionLagInMillis = managedLedgerOffloadDeletionLagInMillis;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadedReadPriority(OffloadedReadPriority managedLedgerOffloadedReadPriority) {
        this.managedLedgerOffloadedReadPriority = managedLedgerOffloadedReadPriority;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadRegion(String s3ManagedLedgerOffloadRegion) {
        this.s3ManagedLedgerOffloadRegion = s3ManagedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadBucket(String s3ManagedLedgerOffloadBucket) {
        this.s3ManagedLedgerOffloadBucket = s3ManagedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadServiceEndpoint(String s3ManagedLedgerOffloadServiceEndpoint) {
        this.s3ManagedLedgerOffloadServiceEndpoint = s3ManagedLedgerOffloadServiceEndpoint;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadMaxBlockSizeInBytes(Integer s3ManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.s3ManagedLedgerOffloadMaxBlockSizeInBytes = s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadReadBufferSizeInBytes(Integer s3ManagedLedgerOffloadReadBufferSizeInBytes) {
        this.s3ManagedLedgerOffloadReadBufferSizeInBytes = s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadCredentialId(String s3ManagedLedgerOffloadCredentialId) {
        this.s3ManagedLedgerOffloadCredentialId = s3ManagedLedgerOffloadCredentialId;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadCredentialSecret(String s3ManagedLedgerOffloadCredentialSecret) {
        this.s3ManagedLedgerOffloadCredentialSecret = s3ManagedLedgerOffloadCredentialSecret;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadRole(String s3ManagedLedgerOffloadRole) {
        this.s3ManagedLedgerOffloadRole = s3ManagedLedgerOffloadRole;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setS3ManagedLedgerOffloadRoleSessionName(String s3ManagedLedgerOffloadRoleSessionName) {
        this.s3ManagedLedgerOffloadRoleSessionName = s3ManagedLedgerOffloadRoleSessionName;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setGcsManagedLedgerOffloadRegion(String gcsManagedLedgerOffloadRegion) {
        this.gcsManagedLedgerOffloadRegion = gcsManagedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setGcsManagedLedgerOffloadBucket(String gcsManagedLedgerOffloadBucket) {
        this.gcsManagedLedgerOffloadBucket = gcsManagedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setGcsManagedLedgerOffloadMaxBlockSizeInBytes(Integer gcsManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.gcsManagedLedgerOffloadMaxBlockSizeInBytes = gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setGcsManagedLedgerOffloadReadBufferSizeInBytes(Integer gcsManagedLedgerOffloadReadBufferSizeInBytes) {
        this.gcsManagedLedgerOffloadReadBufferSizeInBytes = gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setGcsManagedLedgerOffloadServiceAccountKeyFile(String gcsManagedLedgerOffloadServiceAccountKeyFile) {
        this.gcsManagedLedgerOffloadServiceAccountKeyFile = gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setFileSystemProfilePath(String fileSystemProfilePath) {
        this.fileSystemProfilePath = fileSystemProfilePath;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setFileSystemURI(String fileSystemURI) {
        this.fileSystemURI = fileSystemURI;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadBucket(String managedLedgerOffloadBucket) {
        this.managedLedgerOffloadBucket = managedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadRegion(String managedLedgerOffloadRegion) {
        this.managedLedgerOffloadRegion = managedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadServiceEndpoint(String managedLedgerOffloadServiceEndpoint) {
        this.managedLedgerOffloadServiceEndpoint = managedLedgerOffloadServiceEndpoint;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadMaxBlockSizeInBytes(Integer managedLedgerOffloadMaxBlockSizeInBytes) {
        this.managedLedgerOffloadMaxBlockSizeInBytes = managedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public void setManagedLedgerOffloadReadBufferSizeInBytes(Integer managedLedgerOffloadReadBufferSizeInBytes) {
        this.managedLedgerOffloadReadBufferSizeInBytes = managedLedgerOffloadReadBufferSizeInBytes;
    }

    static {
        Field[] fields;
        log = LoggerFactory.getLogger(OffloadPolicies.class);
        CONFIGURATION_FIELDS = new ArrayList<Field>();
        Class<OffloadPolicies> clazz = OffloadPolicies.class;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Configuration.class)) continue;
            CONFIGURATION_FIELDS.add(field);
        }
        DRIVER_NAMES = ImmutableList.of((Object)"S3", (Object)"aws-s3", (Object)"google-cloud-storage", (Object)"filesystem", (Object)"azureblob", (Object)"aliyun-oss");
        DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES = null;
        DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS = null;
        DEFAULT_OFFLOADED_READ_PRIORITY = OffloadedReadPriority.TIERED_STORAGE_FIRST;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Configuration {
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static enum OffloadedReadPriority {
        BOOKKEEPER_FIRST("bookkeeper-first"),
        TIERED_STORAGE_FIRST("tiered-storage-first");

        private final String value;

        private OffloadedReadPriority(String value) {
            this.value = value;
        }

        public boolean equalsName(String otherName) {
            return this.value.equals(otherName);
        }

        public String toString() {
            return this.value;
        }

        public static OffloadedReadPriority fromString(String str) {
            for (OffloadedReadPriority value : OffloadedReadPriority.values()) {
                if (!value.value.equals(str)) continue;
                return value;
            }
            throw new IllegalArgumentException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + str);
        }

        public String getValue() {
            return this.value;
        }
    }
}

