/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

public class NamespaceBundleStats
implements Comparable<NamespaceBundleStats> {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public int consumerCount;
    public int producerCount;
    public long topics;
    public long cacheSize;
    private static final double throughputDifferenceThreshold = 100000.0;
    private static final double msgRateDifferenceThreshold = 100.0;
    private static final long topicConnectionDifferenceThreshold = 500L;
    private static final long cacheSizeDifferenceThreshold = 100000L;

    public NamespaceBundleStats() {
        this.reset();
    }

    public void reset() {
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.consumerCount = 0;
        this.producerCount = 0;
        this.topics = 0L;
        this.cacheSize = 0L;
    }

    @Override
    public int compareTo(NamespaceBundleStats other) {
        int result = this.compareByBandwidthIn(other);
        if (result == 0) {
            result = this.compareByBandwidthOut(other);
        }
        if (result == 0) {
            result = this.compareByMsgRate(other);
        }
        if (result == 0) {
            result = this.compareByTopicConnections(other);
        }
        if (result == 0) {
            result = this.compareByCacheSize(other);
        }
        return result;
    }

    public int compareByMsgRate(NamespaceBundleStats other) {
        double thisMsgRate = this.msgRateIn + this.msgRateOut;
        double otherMsgRate = other.msgRateIn + other.msgRateOut;
        if (Math.abs(thisMsgRate - otherMsgRate) > 100.0) {
            return Double.compare(thisMsgRate, otherMsgRate);
        }
        return 0;
    }

    public int compareByTopicConnections(NamespaceBundleStats other) {
        long thisTopicsAndConnections = this.topics + (long)this.consumerCount + (long)this.producerCount;
        long otherTopicsAndConnections = other.topics + (long)other.consumerCount + (long)other.producerCount;
        if (Math.abs(thisTopicsAndConnections - otherTopicsAndConnections) > 500L) {
            return Long.compare(thisTopicsAndConnections, otherTopicsAndConnections);
        }
        return 0;
    }

    public int compareByCacheSize(NamespaceBundleStats other) {
        if (Math.abs(this.cacheSize - other.cacheSize) > 100000L) {
            return Long.compare(this.cacheSize, other.cacheSize);
        }
        return 0;
    }

    public int compareByBandwidthIn(NamespaceBundleStats other) {
        if (Math.abs(this.msgThroughputIn - other.msgThroughputIn) > 100000.0) {
            return Double.compare(this.msgThroughputIn, other.msgThroughputIn);
        }
        return 0;
    }

    public int compareByBandwidthOut(NamespaceBundleStats other) {
        if (Math.abs(this.msgThroughputOut - other.msgThroughputOut) > 100000.0) {
            return Double.compare(this.msgThroughputOut, other.msgThroughputOut);
        }
        return 0;
    }
}

