/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.pulsar.client.api.KeySharedMode;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.CommandUtils;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.SafeCollectionUtils;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.common.util.collections.ConcurrentBitSetRecyclable;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedOutputStream;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Commands {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x500000;
    public static final int MESSAGE_SIZE_FRAME_PADDING = 10240;
    public static final int INVALID_MAX_MESSAGE_SIZE = -1;
    public static final short magicCrc32c = 3585;
    private static final int checksumSize = 4;
    private static final ByteBuf cmdPing;
    private static final ByteBuf cmdPong;

    public static ByteBuf newConnect(String authMethodName, String authData, String libVersion) {
        return Commands.newConnect(authMethodName, authData, Commands.getCurrentProtocolVersion(), libVersion, null, null, null, null);
    }

    public static ByteBuf newConnect(String authMethodName, String authData, String libVersion, String targetBroker) {
        return Commands.newConnect(authMethodName, authData, Commands.getCurrentProtocolVersion(), libVersion, targetBroker, null, null, null);
    }

    public static ByteBuf newConnect(String authMethodName, String authData, String libVersion, String targetBroker, String originalPrincipal, String clientAuthData, String clientAuthMethod) {
        return Commands.newConnect(authMethodName, authData, Commands.getCurrentProtocolVersion(), libVersion, targetBroker, originalPrincipal, clientAuthData, clientAuthMethod);
    }

    public static PulsarApi.FeatureFlags getFeatureFlags() {
        PulsarApi.FeatureFlags.Builder flags = PulsarApi.FeatureFlags.newBuilder();
        flags.setSupportsAuthRefresh(true);
        return flags.build();
    }

    public static ByteBuf newConnect(String authMethodName, String authData, int protocolVersion, String libVersion, String targetBroker, String originalPrincipal, String originalAuthData, String originalAuthMethod) {
        PulsarApi.CommandConnect.Builder connectBuilder = PulsarApi.CommandConnect.newBuilder();
        connectBuilder.setClientVersion(libVersion != null ? libVersion : "Pulsar Client");
        connectBuilder.setAuthMethodName(authMethodName);
        if ("ycav1".equals(authMethodName)) {
            connectBuilder.setAuthMethod(PulsarApi.AuthMethod.AuthMethodYcaV1);
        }
        if (targetBroker != null) {
            connectBuilder.setProxyToBrokerUrl(targetBroker);
        }
        if (authData != null) {
            connectBuilder.setAuthData(ByteString.copyFromUtf8((String)authData));
        }
        if (originalPrincipal != null) {
            connectBuilder.setOriginalPrincipal(originalPrincipal);
        }
        if (originalAuthData != null) {
            connectBuilder.setOriginalAuthData(originalAuthData);
        }
        if (originalAuthMethod != null) {
            connectBuilder.setOriginalAuthMethod(originalAuthMethod);
        }
        connectBuilder.setProtocolVersion(protocolVersion);
        connectBuilder.setFeatureFlags(Commands.getFeatureFlags());
        PulsarApi.CommandConnect connect = connectBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CONNECT).setConnect(connect));
        connect.recycle();
        connectBuilder.recycle();
        return res;
    }

    public static ByteBuf newConnect(String authMethodName, AuthData authData, int protocolVersion, String libVersion, String targetBroker, String originalPrincipal, AuthData originalAuthData, String originalAuthMethod) {
        PulsarApi.CommandConnect.Builder connectBuilder = PulsarApi.CommandConnect.newBuilder();
        connectBuilder.setClientVersion(libVersion != null ? libVersion : "Pulsar Client");
        connectBuilder.setAuthMethodName(authMethodName);
        if (targetBroker != null) {
            connectBuilder.setProxyToBrokerUrl(targetBroker);
        }
        if (authData != null) {
            connectBuilder.setAuthData(ByteString.copyFrom((byte[])authData.getBytes()));
        }
        if (originalPrincipal != null) {
            connectBuilder.setOriginalPrincipal(originalPrincipal);
        }
        if (originalAuthData != null) {
            connectBuilder.setOriginalAuthData(new String(originalAuthData.getBytes(), StandardCharsets.UTF_8));
        }
        if (originalAuthMethod != null) {
            connectBuilder.setOriginalAuthMethod(originalAuthMethod);
        }
        connectBuilder.setProtocolVersion(protocolVersion);
        connectBuilder.setFeatureFlags(Commands.getFeatureFlags());
        PulsarApi.CommandConnect connect = connectBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CONNECT).setConnect(connect));
        connect.recycle();
        connectBuilder.recycle();
        return res;
    }

    public static ByteBuf newConnected(int clientProtocoVersion) {
        return Commands.newConnected(clientProtocoVersion, -1);
    }

    public static PulsarApi.BaseCommand newConnectedCommand(int clientProtocolVersion, int maxMessageSize) {
        PulsarApi.CommandConnected.Builder connectedBuilder = PulsarApi.CommandConnected.newBuilder();
        connectedBuilder.setServerVersion("Pulsar Server");
        if (-1 != maxMessageSize) {
            connectedBuilder.setMaxMessageSize(maxMessageSize);
        }
        int currentProtocolVersion = Commands.getCurrentProtocolVersion();
        int versionToAdvertise = Math.min(currentProtocolVersion, clientProtocolVersion);
        connectedBuilder.setProtocolVersion(versionToAdvertise);
        PulsarApi.CommandConnected connected = connectedBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.CONNECTED).setConnected(connected).build();
        connectedBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newConnected(int clientProtocolVersion, int maxMessageSize) {
        PulsarApi.CommandConnected.Builder connectedBuilder = PulsarApi.CommandConnected.newBuilder();
        connectedBuilder.setServerVersion("Pulsar Server");
        if (-1 != maxMessageSize) {
            connectedBuilder.setMaxMessageSize(maxMessageSize);
        }
        int currentProtocolVersion = Commands.getCurrentProtocolVersion();
        int versionToAdvertise = Math.min(currentProtocolVersion, clientProtocolVersion);
        connectedBuilder.setProtocolVersion(versionToAdvertise);
        PulsarApi.CommandConnected connected = connectedBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CONNECTED).setConnected(connected));
        connected.recycle();
        connectedBuilder.recycle();
        return res;
    }

    public static ByteBuf newAuthChallenge(String authMethod, AuthData brokerData, int clientProtocolVersion) {
        PulsarApi.CommandAuthChallenge.Builder challengeBuilder = PulsarApi.CommandAuthChallenge.newBuilder();
        int currentProtocolVersion = Commands.getCurrentProtocolVersion();
        int versionToAdvertise = Math.min(currentProtocolVersion, clientProtocolVersion);
        challengeBuilder.setProtocolVersion(versionToAdvertise);
        byte[] authData = brokerData != null ? brokerData.getBytes() : new byte[]{};
        PulsarApi.CommandAuthChallenge challenge = challengeBuilder.setChallenge(PulsarApi.AuthData.newBuilder().setAuthData(ByteString.copyFrom((byte[])authData)).setAuthMethodName(authMethod).build()).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.AUTH_CHALLENGE).setAuthChallenge(challenge));
        challenge.recycle();
        challengeBuilder.recycle();
        return res;
    }

    public static ByteBuf newAuthResponse(String authMethod, AuthData clientData, int clientProtocolVersion, String clientVersion) {
        PulsarApi.CommandAuthResponse.Builder responseBuilder = PulsarApi.CommandAuthResponse.newBuilder();
        responseBuilder.setClientVersion(clientVersion != null ? clientVersion : "Pulsar Client");
        responseBuilder.setProtocolVersion(clientProtocolVersion);
        PulsarApi.CommandAuthResponse response = responseBuilder.setResponse(PulsarApi.AuthData.newBuilder().setAuthData(ByteString.copyFrom((byte[])clientData.getBytes())).setAuthMethodName(authMethod).build()).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.AUTH_RESPONSE).setAuthResponse(response));
        response.recycle();
        responseBuilder.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newSuccessCommand(long requestId) {
        PulsarApi.CommandSuccess.Builder successBuilder = PulsarApi.CommandSuccess.newBuilder();
        successBuilder.setRequestId(requestId);
        PulsarApi.CommandSuccess success = successBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SUCCESS).setSuccess(success).build();
        successBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newSuccess(long requestId) {
        PulsarApi.CommandSuccess.Builder successBuilder = PulsarApi.CommandSuccess.newBuilder();
        successBuilder.setRequestId(requestId);
        PulsarApi.CommandSuccess success = successBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SUCCESS).setSuccess(success));
        successBuilder.recycle();
        success.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newProducerSuccessCommand(long requestId, String producerName, SchemaVersion schemaVersion) {
        return Commands.newProducerSuccessCommand(requestId, producerName, -1L, schemaVersion);
    }

    public static ByteBuf newProducerSuccess(long requestId, String producerName, SchemaVersion schemaVersion) {
        return Commands.newProducerSuccess(requestId, producerName, -1L, schemaVersion);
    }

    public static PulsarApi.BaseCommand newProducerSuccessCommand(long requestId, String producerName, long lastSequenceId, SchemaVersion schemaVersion) {
        PulsarApi.CommandProducerSuccess.Builder producerSuccessBuilder = PulsarApi.CommandProducerSuccess.newBuilder();
        producerSuccessBuilder.setRequestId(requestId);
        producerSuccessBuilder.setProducerName(producerName);
        producerSuccessBuilder.setLastSequenceId(lastSequenceId);
        producerSuccessBuilder.setSchemaVersion(ByteString.copyFrom((byte[])schemaVersion.bytes()));
        PulsarApi.CommandProducerSuccess producerSuccess = producerSuccessBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.PRODUCER_SUCCESS).setProducerSuccess(producerSuccess).build();
        producerSuccessBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newProducerSuccess(long requestId, String producerName, long lastSequenceId, SchemaVersion schemaVersion) {
        PulsarApi.CommandProducerSuccess.Builder producerSuccessBuilder = PulsarApi.CommandProducerSuccess.newBuilder();
        producerSuccessBuilder.setRequestId(requestId);
        producerSuccessBuilder.setProducerName(producerName);
        producerSuccessBuilder.setLastSequenceId(lastSequenceId);
        producerSuccessBuilder.setSchemaVersion(ByteString.copyFrom((byte[])schemaVersion.bytes()));
        PulsarApi.CommandProducerSuccess producerSuccess = producerSuccessBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PRODUCER_SUCCESS).setProducerSuccess(producerSuccess));
        producerSuccess.recycle();
        producerSuccessBuilder.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newErrorCommand(long requestId, PulsarApi.ServerError error, String message) {
        PulsarApi.CommandError.Builder cmdErrorBuilder = PulsarApi.CommandError.newBuilder();
        cmdErrorBuilder.setRequestId(requestId);
        cmdErrorBuilder.setError(error);
        cmdErrorBuilder.setMessage(message);
        PulsarApi.CommandError cmdError = cmdErrorBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.ERROR).setError(cmdError).build();
        cmdErrorBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newError(long requestId, PulsarApi.ServerError error, String message) {
        PulsarApi.CommandError.Builder cmdErrorBuilder = PulsarApi.CommandError.newBuilder();
        cmdErrorBuilder.setRequestId(requestId);
        cmdErrorBuilder.setError(error);
        cmdErrorBuilder.setMessage(message);
        PulsarApi.CommandError cmdError = cmdErrorBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ERROR).setError(cmdError));
        cmdError.recycle();
        cmdErrorBuilder.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newSendReceiptCommand(long producerId, long sequenceId, long highestId, long ledgerId, long entryId) {
        PulsarApi.CommandSendReceipt.Builder sendReceiptBuilder = PulsarApi.CommandSendReceipt.newBuilder();
        sendReceiptBuilder.setProducerId(producerId);
        sendReceiptBuilder.setSequenceId(sequenceId);
        sendReceiptBuilder.setHighestSequenceId(highestId);
        PulsarApi.MessageIdData.Builder messageIdBuilder = PulsarApi.MessageIdData.newBuilder();
        messageIdBuilder.setLedgerId(ledgerId);
        messageIdBuilder.setEntryId(entryId);
        PulsarApi.MessageIdData messageId = messageIdBuilder.build();
        sendReceiptBuilder.setMessageId(messageId);
        PulsarApi.CommandSendReceipt sendReceipt = sendReceiptBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.SEND_RECEIPT).setSendReceipt(sendReceipt).build();
        messageIdBuilder.recycle();
        sendReceiptBuilder.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newSendReceipt(long producerId, long sequenceId, long highestId, long ledgerId, long entryId) {
        PulsarApi.CommandSendReceipt.Builder sendReceiptBuilder = PulsarApi.CommandSendReceipt.newBuilder();
        sendReceiptBuilder.setProducerId(producerId);
        sendReceiptBuilder.setSequenceId(sequenceId);
        sendReceiptBuilder.setHighestSequenceId(highestId);
        PulsarApi.MessageIdData.Builder messageIdBuilder = PulsarApi.MessageIdData.newBuilder();
        messageIdBuilder.setLedgerId(ledgerId);
        messageIdBuilder.setEntryId(entryId);
        PulsarApi.MessageIdData messageId = messageIdBuilder.build();
        sendReceiptBuilder.setMessageId(messageId);
        PulsarApi.CommandSendReceipt sendReceipt = sendReceiptBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEND_RECEIPT).setSendReceipt(sendReceipt));
        messageIdBuilder.recycle();
        messageId.recycle();
        sendReceiptBuilder.recycle();
        sendReceipt.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newSendErrorCommand(long producerId, long sequenceId, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandSendError.Builder sendErrorBuilder = PulsarApi.CommandSendError.newBuilder();
        sendErrorBuilder.setProducerId(producerId);
        sendErrorBuilder.setSequenceId(sequenceId);
        sendErrorBuilder.setError(error);
        sendErrorBuilder.setMessage(errorMsg);
        PulsarApi.CommandSendError sendError = sendErrorBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.SEND_ERROR).setSendError(sendError).build();
        sendErrorBuilder.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newSendError(long producerId, long sequenceId, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandSendError.Builder sendErrorBuilder = PulsarApi.CommandSendError.newBuilder();
        sendErrorBuilder.setProducerId(producerId);
        sendErrorBuilder.setSequenceId(sequenceId);
        sendErrorBuilder.setError(error);
        sendErrorBuilder.setMessage(errorMsg);
        PulsarApi.CommandSendError sendError = sendErrorBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEND_ERROR).setSendError(sendError));
        sendErrorBuilder.recycle();
        sendError.recycle();
        return res;
    }

    public static boolean hasChecksum(ByteBuf buffer) {
        return buffer.getShort(buffer.readerIndex()) == 3585;
    }

    public static int readChecksum(ByteBuf buffer) {
        buffer.skipBytes(2);
        return buffer.readInt();
    }

    public static void skipChecksumIfPresent(ByteBuf buffer) {
        if (Commands.hasChecksum(buffer)) {
            Commands.readChecksum(buffer);
        }
    }

    public static PulsarApi.MessageMetadata parseMessageMetadata(ByteBuf buffer) {
        try {
            Commands.skipChecksumIfPresent(buffer);
            int metadataSize = (int)buffer.readUnsignedInt();
            int writerIndex = buffer.writerIndex();
            buffer.writerIndex(buffer.readerIndex() + metadataSize);
            ByteBufCodedInputStream stream = ByteBufCodedInputStream.get(buffer);
            PulsarApi.MessageMetadata.Builder messageMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
            PulsarApi.MessageMetadata res = messageMetadataBuilder.mergeFrom(stream, null).build();
            buffer.writerIndex(writerIndex);
            messageMetadataBuilder.recycle();
            stream.recycle();
            return res;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void skipMessageMetadata(ByteBuf buffer) {
        Commands.skipChecksumIfPresent(buffer);
        int metadataSize = (int)buffer.readUnsignedInt();
        buffer.skipBytes(metadataSize);
    }

    public static PulsarApi.BaseCommand newMessageCommand(long consumerId, PulsarApi.MessageIdData messageId, int redeliveryCount, long[] ackSet) {
        PulsarApi.CommandMessage.Builder msgBuilder = PulsarApi.CommandMessage.newBuilder();
        msgBuilder.setConsumerId(consumerId);
        msgBuilder.setMessageId(messageId);
        if (redeliveryCount > 0) {
            msgBuilder.setRedeliveryCount(redeliveryCount);
        }
        if (ackSet != null) {
            msgBuilder.addAllAckSet(SafeCollectionUtils.longArrayToList(ackSet));
        }
        PulsarApi.CommandMessage msg = msgBuilder.build();
        PulsarApi.BaseCommand.Builder cmdBuilder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand cmd = cmdBuilder.setType(PulsarApi.BaseCommand.Type.MESSAGE).setMessage(msg).build();
        msgBuilder.recycle();
        cmdBuilder.recycle();
        return cmd;
    }

    public static ByteBufPair newMessage(long consumerId, PulsarApi.MessageIdData messageId, int redeliveryCount, ByteBuf metadataAndPayload, long[] ackSet) {
        PulsarApi.CommandMessage.Builder msgBuilder = PulsarApi.CommandMessage.newBuilder();
        msgBuilder.setConsumerId(consumerId);
        msgBuilder.setMessageId(messageId);
        if (redeliveryCount > 0) {
            msgBuilder.setRedeliveryCount(redeliveryCount);
        }
        if (ackSet != null) {
            msgBuilder.addAllAckSet(SafeCollectionUtils.longArrayToList(ackSet));
        }
        PulsarApi.CommandMessage msg = msgBuilder.build();
        PulsarApi.BaseCommand.Builder cmdBuilder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand cmd = cmdBuilder.setType(PulsarApi.BaseCommand.Type.MESSAGE).setMessage(msg).build();
        ByteBufPair res = Commands.serializeCommandMessageWithSize(cmd, metadataAndPayload);
        cmd.recycle();
        cmdBuilder.recycle();
        msg.recycle();
        msgBuilder.recycle();
        return res;
    }

    public static ByteBufPair newSend(long producerId, long sequenceId, int numMessaegs, ChecksumType checksumType, PulsarApi.MessageMetadata messageMetadata, ByteBuf payload) {
        return Commands.newSend(producerId, sequenceId, numMessaegs, messageMetadata.hasTxnidLeastBits() ? messageMetadata.getTxnidLeastBits() : -1L, messageMetadata.hasTxnidMostBits() ? messageMetadata.getTxnidMostBits() : -1L, checksumType, messageMetadata, payload);
    }

    public static ByteBufPair newSend(long producerId, long lowestSequenceId, long highestSequenceId, int numMessaegs, ChecksumType checksumType, PulsarApi.MessageMetadata messageMetadata, ByteBuf payload) {
        return Commands.newSend(producerId, lowestSequenceId, highestSequenceId, numMessaegs, messageMetadata.hasTxnidLeastBits() ? messageMetadata.getTxnidLeastBits() : -1L, messageMetadata.hasTxnidMostBits() ? messageMetadata.getTxnidMostBits() : -1L, checksumType, messageMetadata, payload);
    }

    public static ByteBufPair newSend(long producerId, long sequenceId, int numMessages, long txnIdLeastBits, long txnIdMostBits, ChecksumType checksumType, PulsarApi.MessageMetadata messageData, ByteBuf payload) {
        PulsarApi.CommandSend.Builder sendBuilder = PulsarApi.CommandSend.newBuilder();
        sendBuilder.setProducerId(producerId);
        sendBuilder.setSequenceId(sequenceId);
        if (numMessages > 1) {
            sendBuilder.setNumMessages(numMessages);
        }
        if (txnIdLeastBits >= 0L) {
            sendBuilder.setTxnidLeastBits(txnIdLeastBits);
        }
        if (txnIdMostBits >= 0L) {
            sendBuilder.setTxnidMostBits(txnIdMostBits);
        }
        if (messageData.hasTotalChunkMsgSize() && messageData.getTotalChunkMsgSize() > 1) {
            sendBuilder.setIsChunk(true);
        }
        PulsarApi.CommandSend send = sendBuilder.build();
        ByteBufPair res = Commands.serializeCommandSendWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEND).setSend(send), checksumType, messageData, payload);
        send.recycle();
        sendBuilder.recycle();
        return res;
    }

    public static ByteBufPair newSend(long producerId, long lowestSequenceId, long highestSequenceId, int numMessages, long txnIdLeastBits, long txnIdMostBits, ChecksumType checksumType, PulsarApi.MessageMetadata messageData, ByteBuf payload) {
        PulsarApi.CommandSend.Builder sendBuilder = PulsarApi.CommandSend.newBuilder();
        sendBuilder.setProducerId(producerId);
        sendBuilder.setSequenceId(lowestSequenceId);
        sendBuilder.setHighestSequenceId(highestSequenceId);
        if (numMessages > 1) {
            sendBuilder.setNumMessages(numMessages);
        }
        if (txnIdLeastBits >= 0L) {
            sendBuilder.setTxnidLeastBits(txnIdLeastBits);
        }
        if (txnIdMostBits >= 0L) {
            sendBuilder.setTxnidMostBits(txnIdMostBits);
        }
        if (messageData.hasTotalChunkMsgSize() && messageData.getTotalChunkMsgSize() > 1) {
            sendBuilder.setIsChunk(true);
        }
        PulsarApi.CommandSend send = sendBuilder.build();
        ByteBufPair res = Commands.serializeCommandSendWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEND).setSend(send), checksumType, messageData, payload);
        send.recycle();
        sendBuilder.recycle();
        return res;
    }

    public static ByteBuf newSubscribe(String topic, String subscription, long consumerId, long requestId, PulsarApi.CommandSubscribe.SubType subType, int priorityLevel, String consumerName, long resetStartMessageBackInSeconds) {
        return Commands.newSubscribe(topic, subscription, consumerId, requestId, subType, priorityLevel, consumerName, true, null, Collections.emptyMap(), false, false, PulsarApi.CommandSubscribe.InitialPosition.Earliest, resetStartMessageBackInSeconds, null, true);
    }

    public static ByteBuf newSubscribe(String topic, String subscription, long consumerId, long requestId, PulsarApi.CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, PulsarApi.MessageIdData startMessageId, Map<String, String> metadata, boolean readCompacted, boolean isReplicated, PulsarApi.CommandSubscribe.InitialPosition subscriptionInitialPosition, long startMessageRollbackDurationInSec, SchemaInfo schemaInfo, boolean createTopicIfDoesNotExist) {
        return Commands.newSubscribe(topic, subscription, consumerId, requestId, subType, priorityLevel, consumerName, isDurable, startMessageId, metadata, readCompacted, isReplicated, subscriptionInitialPosition, startMessageRollbackDurationInSec, schemaInfo, createTopicIfDoesNotExist, null);
    }

    public static ByteBuf newSubscribe(String topic, String subscription, long consumerId, long requestId, PulsarApi.CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, PulsarApi.MessageIdData startMessageId, Map<String, String> metadata, boolean readCompacted, boolean isReplicated, PulsarApi.CommandSubscribe.InitialPosition subscriptionInitialPosition, long startMessageRollbackDurationInSec, SchemaInfo schemaInfo, boolean createTopicIfDoesNotExist, KeySharedPolicy keySharedPolicy) {
        PulsarApi.CommandSubscribe.Builder subscribeBuilder = PulsarApi.CommandSubscribe.newBuilder();
        subscribeBuilder.setTopic(topic);
        subscribeBuilder.setSubscription(subscription);
        subscribeBuilder.setSubType(subType);
        subscribeBuilder.setConsumerId(consumerId);
        subscribeBuilder.setConsumerName(consumerName);
        subscribeBuilder.setRequestId(requestId);
        subscribeBuilder.setPriorityLevel(priorityLevel);
        subscribeBuilder.setDurable(isDurable);
        subscribeBuilder.setReadCompacted(readCompacted);
        subscribeBuilder.setInitialPosition(subscriptionInitialPosition);
        subscribeBuilder.setReplicateSubscriptionState(isReplicated);
        subscribeBuilder.setForceTopicCreation(createTopicIfDoesNotExist);
        if (keySharedPolicy != null) {
            PulsarApi.KeySharedMeta.Builder keySharedMetaBuilder = PulsarApi.KeySharedMeta.newBuilder();
            keySharedMetaBuilder.setAllowOutOfOrderDelivery(keySharedPolicy.isAllowOutOfOrderDelivery());
            keySharedMetaBuilder.setKeySharedMode(Commands.convertKeySharedMode(keySharedPolicy.getKeySharedMode()));
            if (keySharedPolicy instanceof KeySharedPolicy.KeySharedPolicySticky) {
                List ranges = ((KeySharedPolicy.KeySharedPolicySticky)keySharedPolicy).getRanges();
                for (Range range : ranges) {
                    keySharedMetaBuilder.addHashRanges(PulsarApi.IntRange.newBuilder().setStart(range.getStart()).setEnd(range.getEnd()));
                }
            }
            subscribeBuilder.setKeySharedMeta(keySharedMetaBuilder.build());
        }
        if (startMessageId != null) {
            subscribeBuilder.setStartMessageId(startMessageId);
        }
        if (startMessageRollbackDurationInSec > 0L) {
            subscribeBuilder.setStartMessageRollbackDurationSec(startMessageRollbackDurationInSec);
        }
        subscribeBuilder.addAllMetadata(CommandUtils.toKeyValueList(metadata));
        PulsarApi.Schema schema = null;
        if (schemaInfo != null) {
            schema = Commands.getSchema(schemaInfo);
            subscribeBuilder.setSchema(schema);
        }
        PulsarApi.CommandSubscribe subscribe = subscribeBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SUBSCRIBE).setSubscribe(subscribe));
        subscribeBuilder.recycle();
        subscribe.recycle();
        if (null != schema) {
            schema.recycle();
        }
        return res;
    }

    private static PulsarApi.KeySharedMode convertKeySharedMode(KeySharedMode mode) {
        switch (mode) {
            case AUTO_SPLIT: {
                return PulsarApi.KeySharedMode.AUTO_SPLIT;
            }
            case STICKY: {
                return PulsarApi.KeySharedMode.STICKY;
            }
        }
        throw new IllegalArgumentException("Unexpected key shared mode: " + mode);
    }

    public static ByteBuf newUnsubscribe(long consumerId, long requestId) {
        PulsarApi.CommandUnsubscribe.Builder unsubscribeBuilder = PulsarApi.CommandUnsubscribe.newBuilder();
        unsubscribeBuilder.setConsumerId(consumerId);
        unsubscribeBuilder.setRequestId(requestId);
        PulsarApi.CommandUnsubscribe unsubscribe = unsubscribeBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.UNSUBSCRIBE).setUnsubscribe(unsubscribe));
        unsubscribeBuilder.recycle();
        unsubscribe.recycle();
        return res;
    }

    public static ByteBuf newActiveConsumerChange(long consumerId, boolean isActive) {
        PulsarApi.CommandActiveConsumerChange.Builder changeBuilder = PulsarApi.CommandActiveConsumerChange.newBuilder().setConsumerId(consumerId).setIsActive(isActive);
        PulsarApi.CommandActiveConsumerChange change = changeBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ACTIVE_CONSUMER_CHANGE).setActiveConsumerChange(change));
        changeBuilder.recycle();
        change.recycle();
        return res;
    }

    public static ByteBuf newSeek(long consumerId, long requestId, long ledgerId, long entryId, long[] ackSet) {
        PulsarApi.CommandSeek.Builder seekBuilder = PulsarApi.CommandSeek.newBuilder();
        seekBuilder.setConsumerId(consumerId);
        seekBuilder.setRequestId(requestId);
        PulsarApi.MessageIdData.Builder messageIdBuilder = PulsarApi.MessageIdData.newBuilder();
        messageIdBuilder.setLedgerId(ledgerId);
        messageIdBuilder.setEntryId(entryId);
        messageIdBuilder.addAllAckSet(SafeCollectionUtils.longArrayToList(ackSet));
        PulsarApi.MessageIdData messageId = messageIdBuilder.build();
        seekBuilder.setMessageId(messageId);
        PulsarApi.CommandSeek seek = seekBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEEK).setSeek(seek));
        messageId.recycle();
        messageIdBuilder.recycle();
        seekBuilder.recycle();
        seek.recycle();
        return res;
    }

    public static ByteBuf newSeek(long consumerId, long requestId, long timestamp) {
        PulsarApi.CommandSeek.Builder seekBuilder = PulsarApi.CommandSeek.newBuilder();
        seekBuilder.setConsumerId(consumerId);
        seekBuilder.setRequestId(requestId);
        seekBuilder.setMessagePublishTime(timestamp);
        PulsarApi.CommandSeek seek = seekBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.SEEK).setSeek(seek));
        seekBuilder.recycle();
        seek.recycle();
        return res;
    }

    public static ByteBuf newCloseConsumer(long consumerId, long requestId) {
        PulsarApi.CommandCloseConsumer.Builder closeConsumerBuilder = PulsarApi.CommandCloseConsumer.newBuilder();
        closeConsumerBuilder.setConsumerId(consumerId);
        closeConsumerBuilder.setRequestId(requestId);
        PulsarApi.CommandCloseConsumer closeConsumer = closeConsumerBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CLOSE_CONSUMER).setCloseConsumer(closeConsumer));
        closeConsumerBuilder.recycle();
        closeConsumer.recycle();
        return res;
    }

    public static ByteBuf newReachedEndOfTopic(long consumerId) {
        PulsarApi.CommandReachedEndOfTopic.Builder reachedEndOfTopicBuilder = PulsarApi.CommandReachedEndOfTopic.newBuilder();
        reachedEndOfTopicBuilder.setConsumerId(consumerId);
        PulsarApi.CommandReachedEndOfTopic reachedEndOfTopic = reachedEndOfTopicBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.REACHED_END_OF_TOPIC).setReachedEndOfTopic(reachedEndOfTopic));
        reachedEndOfTopicBuilder.recycle();
        reachedEndOfTopic.recycle();
        return res;
    }

    public static ByteBuf newCloseProducer(long producerId, long requestId) {
        PulsarApi.CommandCloseProducer.Builder closeProducerBuilder = PulsarApi.CommandCloseProducer.newBuilder();
        closeProducerBuilder.setProducerId(producerId);
        closeProducerBuilder.setRequestId(requestId);
        PulsarApi.CommandCloseProducer closeProducer = closeProducerBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CLOSE_PRODUCER).setCloseProducer(closeProducerBuilder));
        closeProducerBuilder.recycle();
        closeProducer.recycle();
        return res;
    }

    @VisibleForTesting
    public static ByteBuf newProducer(String topic, long producerId, long requestId, String producerName, Map<String, String> metadata) {
        return Commands.newProducer(topic, producerId, requestId, producerName, false, metadata);
    }

    public static ByteBuf newProducer(String topic, long producerId, long requestId, String producerName, boolean encrypted, Map<String, String> metadata) {
        return Commands.newProducer(topic, producerId, requestId, producerName, encrypted, metadata, null, 0L, false);
    }

    private static PulsarApi.Schema.Type getSchemaType(SchemaType type) {
        if (type.getValue() < 0) {
            return PulsarApi.Schema.Type.None;
        }
        return PulsarApi.Schema.Type.valueOf(type.getValue());
    }

    public static SchemaType getSchemaType(PulsarApi.Schema.Type type) {
        if (type.getNumber() < 0) {
            return SchemaType.NONE;
        }
        return SchemaType.valueOf((int)type.getNumber());
    }

    private static PulsarApi.Schema getSchema(SchemaInfo schemaInfo) {
        PulsarApi.Schema.Builder builder = PulsarApi.Schema.newBuilder().setName(schemaInfo.getName()).setSchemaData(ByteString.copyFrom((byte[])schemaInfo.getSchema())).setType(Commands.getSchemaType(schemaInfo.getType())).addAllProperties(schemaInfo.getProperties().entrySet().stream().map(entry -> PulsarApi.KeyValue.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build()).collect(Collectors.toList()));
        PulsarApi.Schema schema = builder.build();
        builder.recycle();
        return schema;
    }

    public static ByteBuf newProducer(String topic, long producerId, long requestId, String producerName, boolean encrypted, Map<String, String> metadata, SchemaInfo schemaInfo, long epoch, boolean userProvidedProducerName) {
        PulsarApi.CommandProducer.Builder producerBuilder = PulsarApi.CommandProducer.newBuilder();
        producerBuilder.setTopic(topic);
        producerBuilder.setProducerId(producerId);
        producerBuilder.setRequestId(requestId);
        producerBuilder.setEpoch(epoch);
        if (producerName != null) {
            producerBuilder.setProducerName(producerName);
        }
        producerBuilder.setUserProvidedProducerName(userProvidedProducerName);
        producerBuilder.setEncrypted(encrypted);
        producerBuilder.addAllMetadata(CommandUtils.toKeyValueList(metadata));
        if (null != schemaInfo) {
            producerBuilder.setSchema(Commands.getSchema(schemaInfo));
        }
        PulsarApi.CommandProducer producer = producerBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PRODUCER).setProducer(producer));
        producerBuilder.recycle();
        producer.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newPartitionMetadataResponseCommand(PulsarApi.ServerError error, String errorMsg, long requestId) {
        PulsarApi.CommandPartitionedTopicMetadataResponse.Builder partitionMetadataResponseBuilder = PulsarApi.CommandPartitionedTopicMetadataResponse.newBuilder();
        partitionMetadataResponseBuilder.setRequestId(requestId);
        partitionMetadataResponseBuilder.setError(error);
        partitionMetadataResponseBuilder.setResponse(PulsarApi.CommandPartitionedTopicMetadataResponse.LookupType.Failed);
        if (errorMsg != null) {
            partitionMetadataResponseBuilder.setMessage(errorMsg);
        }
        PulsarApi.CommandPartitionedTopicMetadataResponse partitionMetadataResponse = partitionMetadataResponseBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.PARTITIONED_METADATA_RESPONSE).setPartitionMetadataResponse(partitionMetadataResponse).build();
        partitionMetadataResponseBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newPartitionMetadataResponse(PulsarApi.ServerError error, String errorMsg, long requestId) {
        PulsarApi.CommandPartitionedTopicMetadataResponse.Builder partitionMetadataResponseBuilder = PulsarApi.CommandPartitionedTopicMetadataResponse.newBuilder();
        partitionMetadataResponseBuilder.setRequestId(requestId);
        partitionMetadataResponseBuilder.setError(error);
        partitionMetadataResponseBuilder.setResponse(PulsarApi.CommandPartitionedTopicMetadataResponse.LookupType.Failed);
        if (errorMsg != null) {
            partitionMetadataResponseBuilder.setMessage(errorMsg);
        }
        PulsarApi.CommandPartitionedTopicMetadataResponse partitionMetadataResponse = partitionMetadataResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PARTITIONED_METADATA_RESPONSE).setPartitionMetadataResponse(partitionMetadataResponse));
        partitionMetadataResponseBuilder.recycle();
        partitionMetadataResponse.recycle();
        return res;
    }

    public static ByteBuf newPartitionMetadataRequest(String topic, long requestId) {
        PulsarApi.CommandPartitionedTopicMetadata.Builder partitionMetadataBuilder = PulsarApi.CommandPartitionedTopicMetadata.newBuilder();
        partitionMetadataBuilder.setTopic(topic);
        partitionMetadataBuilder.setRequestId(requestId);
        PulsarApi.CommandPartitionedTopicMetadata partitionMetadata = partitionMetadataBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PARTITIONED_METADATA).setPartitionMetadata(partitionMetadata));
        partitionMetadataBuilder.recycle();
        partitionMetadata.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newPartitionMetadataResponseCommand(int partitions, long requestId) {
        PulsarApi.CommandPartitionedTopicMetadataResponse.Builder partitionMetadataResponseBuilder = PulsarApi.CommandPartitionedTopicMetadataResponse.newBuilder();
        partitionMetadataResponseBuilder.setPartitions(partitions);
        partitionMetadataResponseBuilder.setResponse(PulsarApi.CommandPartitionedTopicMetadataResponse.LookupType.Success);
        partitionMetadataResponseBuilder.setRequestId(requestId);
        PulsarApi.CommandPartitionedTopicMetadataResponse partitionMetadataResponse = partitionMetadataResponseBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.PARTITIONED_METADATA_RESPONSE).setPartitionMetadataResponse(partitionMetadataResponse).build();
        partitionMetadataResponseBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newPartitionMetadataResponse(int partitions, long requestId) {
        PulsarApi.CommandPartitionedTopicMetadataResponse.Builder partitionMetadataResponseBuilder = PulsarApi.CommandPartitionedTopicMetadataResponse.newBuilder();
        partitionMetadataResponseBuilder.setPartitions(partitions);
        partitionMetadataResponseBuilder.setResponse(PulsarApi.CommandPartitionedTopicMetadataResponse.LookupType.Success);
        partitionMetadataResponseBuilder.setRequestId(requestId);
        PulsarApi.CommandPartitionedTopicMetadataResponse partitionMetadataResponse = partitionMetadataResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PARTITIONED_METADATA_RESPONSE).setPartitionMetadataResponse(partitionMetadataResponse));
        partitionMetadataResponseBuilder.recycle();
        partitionMetadataResponse.recycle();
        return res;
    }

    public static ByteBuf newLookup(String topic, boolean authoritative, long requestId) {
        return Commands.newLookup(topic, null, authoritative, requestId);
    }

    public static ByteBuf newLookup(String topic, String listenerName, boolean authoritative, long requestId) {
        PulsarApi.CommandLookupTopic.Builder lookupTopicBuilder = PulsarApi.CommandLookupTopic.newBuilder();
        lookupTopicBuilder.setTopic(topic);
        lookupTopicBuilder.setRequestId(requestId);
        lookupTopicBuilder.setAuthoritative(authoritative);
        if (StringUtils.isNotBlank((CharSequence)listenerName)) {
            lookupTopicBuilder.setAdvertisedListenerName(listenerName);
        }
        PulsarApi.CommandLookupTopic lookupBroker = lookupTopicBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.LOOKUP).setLookupTopic(lookupBroker));
        lookupTopicBuilder.recycle();
        lookupBroker.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newLookupResponseCommand(String brokerServiceUrl, String brokerServiceUrlTls, boolean authoritative, PulsarApi.CommandLookupTopicResponse.LookupType response, long requestId, boolean proxyThroughServiceUrl) {
        PulsarApi.CommandLookupTopicResponse.Builder commandLookupTopicResponseBuilder = PulsarApi.CommandLookupTopicResponse.newBuilder();
        commandLookupTopicResponseBuilder.setBrokerServiceUrl(brokerServiceUrl);
        if (brokerServiceUrlTls != null) {
            commandLookupTopicResponseBuilder.setBrokerServiceUrlTls(brokerServiceUrlTls);
        }
        commandLookupTopicResponseBuilder.setResponse(response);
        commandLookupTopicResponseBuilder.setRequestId(requestId);
        commandLookupTopicResponseBuilder.setAuthoritative(authoritative);
        commandLookupTopicResponseBuilder.setProxyThroughServiceUrl(proxyThroughServiceUrl);
        PulsarApi.CommandLookupTopicResponse commandLookupTopicResponse = commandLookupTopicResponseBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.LOOKUP_RESPONSE).setLookupTopicResponse(commandLookupTopicResponse).build();
        commandLookupTopicResponseBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newLookupResponse(String brokerServiceUrl, String brokerServiceUrlTls, boolean authoritative, PulsarApi.CommandLookupTopicResponse.LookupType response, long requestId, boolean proxyThroughServiceUrl) {
        PulsarApi.CommandLookupTopicResponse.Builder commandLookupTopicResponseBuilder = PulsarApi.CommandLookupTopicResponse.newBuilder();
        commandLookupTopicResponseBuilder.setBrokerServiceUrl(brokerServiceUrl);
        if (brokerServiceUrlTls != null) {
            commandLookupTopicResponseBuilder.setBrokerServiceUrlTls(brokerServiceUrlTls);
        }
        commandLookupTopicResponseBuilder.setResponse(response);
        commandLookupTopicResponseBuilder.setRequestId(requestId);
        commandLookupTopicResponseBuilder.setAuthoritative(authoritative);
        commandLookupTopicResponseBuilder.setProxyThroughServiceUrl(proxyThroughServiceUrl);
        PulsarApi.CommandLookupTopicResponse commandLookupTopicResponse = commandLookupTopicResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.LOOKUP_RESPONSE).setLookupTopicResponse(commandLookupTopicResponse));
        commandLookupTopicResponseBuilder.recycle();
        commandLookupTopicResponse.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newLookupErrorResponseCommand(PulsarApi.ServerError error, String errorMsg, long requestId) {
        PulsarApi.CommandLookupTopicResponse.Builder commandLookupTopicResponseBuilder = PulsarApi.CommandLookupTopicResponse.newBuilder();
        commandLookupTopicResponseBuilder.setRequestId(requestId);
        commandLookupTopicResponseBuilder.setError(error);
        if (errorMsg != null) {
            commandLookupTopicResponseBuilder.setMessage(errorMsg);
        }
        commandLookupTopicResponseBuilder.setResponse(PulsarApi.CommandLookupTopicResponse.LookupType.Failed);
        PulsarApi.CommandLookupTopicResponse commandLookupTopicResponse = commandLookupTopicResponseBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand res = builder.setType(PulsarApi.BaseCommand.Type.LOOKUP_RESPONSE).setLookupTopicResponse(commandLookupTopicResponse).build();
        commandLookupTopicResponseBuilder.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newLookupErrorResponse(PulsarApi.ServerError error, String errorMsg, long requestId) {
        PulsarApi.CommandLookupTopicResponse.Builder connectionBuilder = PulsarApi.CommandLookupTopicResponse.newBuilder();
        connectionBuilder.setRequestId(requestId);
        connectionBuilder.setError(error);
        if (errorMsg != null) {
            connectionBuilder.setMessage(errorMsg);
        }
        connectionBuilder.setResponse(PulsarApi.CommandLookupTopicResponse.LookupType.Failed);
        PulsarApi.CommandLookupTopicResponse connectionBroker = connectionBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.LOOKUP_RESPONSE).setLookupTopicResponse(connectionBroker));
        connectionBuilder.recycle();
        connectionBroker.recycle();
        return res;
    }

    public static ByteBuf newMultiTransactionMessageAck(long consumerId, TxnID txnID, List<Triple<Long, Long, ConcurrentBitSetRecyclable>> entries) {
        PulsarApi.CommandAck.Builder ackBuilder = PulsarApi.CommandAck.newBuilder();
        ackBuilder.setConsumerId(consumerId);
        ackBuilder.setAckType(PulsarApi.CommandAck.AckType.Individual);
        ackBuilder.setTxnidLeastBits(txnID.getLeastSigBits());
        ackBuilder.setTxnidMostBits(txnID.getMostSigBits());
        return Commands.newMultiMessageAckCommon(ackBuilder, entries);
    }

    public static ByteBuf newMultiMessageAckCommon(PulsarApi.CommandAck.Builder ackBuilder, List<Triple<Long, Long, ConcurrentBitSetRecyclable>> entries) {
        int entriesCount = entries.size();
        for (int i = 0; i < entriesCount; ++i) {
            long ledgerId = (Long)entries.get(i).getLeft();
            long entryId = (Long)entries.get(i).getMiddle();
            ConcurrentBitSetRecyclable bitSet = (ConcurrentBitSetRecyclable)entries.get(i).getRight();
            PulsarApi.MessageIdData.Builder messageIdDataBuilder = PulsarApi.MessageIdData.newBuilder();
            messageIdDataBuilder.setLedgerId(ledgerId);
            messageIdDataBuilder.setEntryId(entryId);
            if (bitSet != null) {
                messageIdDataBuilder.addAllAckSet(SafeCollectionUtils.longArrayToList(bitSet.toLongArray()));
            }
            PulsarApi.MessageIdData messageIdData = messageIdDataBuilder.build();
            ackBuilder.addMessageId(messageIdData);
            if (bitSet != null) {
                bitSet.recycle();
            }
            messageIdDataBuilder.recycle();
        }
        PulsarApi.CommandAck ack = ackBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ACK).setAck(ack));
        for (int i = 0; i < entriesCount; ++i) {
            ack.getMessageId(i).recycle();
        }
        ack.recycle();
        ackBuilder.recycle();
        return res;
    }

    public static ByteBuf newMultiMessageAck(long consumerId, List<Triple<Long, Long, ConcurrentBitSetRecyclable>> entries) {
        PulsarApi.CommandAck.Builder ackBuilder = PulsarApi.CommandAck.newBuilder();
        ackBuilder.setConsumerId(consumerId);
        ackBuilder.setAckType(PulsarApi.CommandAck.AckType.Individual);
        return Commands.newMultiMessageAckCommon(ackBuilder, entries);
    }

    public static ByteBuf newAck(long consumerId, long ledgerId, long entryId, BitSetRecyclable ackSet, PulsarApi.CommandAck.AckType ackType, PulsarApi.CommandAck.ValidationError validationError, Map<String, Long> properties) {
        return Commands.newAck(consumerId, ledgerId, entryId, ackSet, ackType, validationError, properties, -1L, -1L, -1L, -1);
    }

    public static ByteBuf newAck(long consumerId, long ledgerId, long entryId, BitSetRecyclable ackSet, PulsarApi.CommandAck.AckType ackType, PulsarApi.CommandAck.ValidationError validationError, Map<String, Long> properties, long txnIdLeastBits, long txnIdMostBits, long requestId, int batchSize) {
        PulsarApi.CommandAck.Builder ackBuilder = PulsarApi.CommandAck.newBuilder();
        ackBuilder.setConsumerId(consumerId);
        ackBuilder.setAckType(ackType);
        PulsarApi.MessageIdData.Builder messageIdDataBuilder = PulsarApi.MessageIdData.newBuilder();
        messageIdDataBuilder.setLedgerId(ledgerId);
        messageIdDataBuilder.setEntryId(entryId);
        if (ackSet != null) {
            messageIdDataBuilder.addAllAckSet(SafeCollectionUtils.longArrayToList(ackSet.toLongArray()));
        }
        if (batchSize >= 0) {
            messageIdDataBuilder.setBatchSize(batchSize);
        }
        PulsarApi.MessageIdData messageIdData = messageIdDataBuilder.build();
        ackBuilder.addMessageId(messageIdData);
        if (validationError != null) {
            ackBuilder.setValidationError(validationError);
        }
        if (txnIdMostBits >= 0L) {
            ackBuilder.setTxnidMostBits(txnIdMostBits);
        }
        if (txnIdLeastBits >= 0L) {
            ackBuilder.setTxnidLeastBits(txnIdLeastBits);
        }
        if (requestId >= 0L) {
            ackBuilder.setRequestId(requestId);
        }
        for (Map.Entry<String, Long> e : properties.entrySet()) {
            ackBuilder.addProperties(PulsarApi.KeyLongValue.newBuilder().setKey(e.getKey()).setValue(e.getValue()).build());
        }
        PulsarApi.CommandAck ack = ackBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ACK).setAck(ack));
        ack.recycle();
        ackBuilder.recycle();
        messageIdDataBuilder.recycle();
        messageIdData.recycle();
        return res;
    }

    public static ByteBuf newAck(long consumerId, long ledgerId, long entryId, BitSetRecyclable ackSet, PulsarApi.CommandAck.AckType ackType, PulsarApi.CommandAck.ValidationError validationError, Map<String, Long> properties, long txnIdLeastBits, long txnIdMostBits, long requestId) {
        return Commands.newAck(consumerId, ledgerId, entryId, ackSet, ackType, validationError, properties, txnIdLeastBits, txnIdMostBits, requestId, -1);
    }

    public static ByteBuf newAckResponse(long requestId, PulsarApi.ServerError error, String errorMsg, long consumerId) {
        PulsarApi.CommandAckResponse.Builder commandAckResponseBuilder = PulsarApi.CommandAckResponse.newBuilder();
        commandAckResponseBuilder.setConsumerId(consumerId);
        commandAckResponseBuilder.setRequestId(requestId);
        if (error != null) {
            commandAckResponseBuilder.setError(error);
        }
        if (errorMsg != null) {
            commandAckResponseBuilder.setMessage(errorMsg);
        }
        PulsarApi.CommandAckResponse commandAckResponse = commandAckResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ACK_RESPONSE).setAckResponse(commandAckResponseBuilder));
        commandAckResponseBuilder.recycle();
        commandAckResponse.recycle();
        return res;
    }

    public static ByteBuf newFlow(long consumerId, int messagePermits) {
        PulsarApi.CommandFlow.Builder flowBuilder = PulsarApi.CommandFlow.newBuilder();
        flowBuilder.setConsumerId(consumerId);
        flowBuilder.setMessagePermits(messagePermits);
        PulsarApi.CommandFlow flow = flowBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.FLOW).setFlow(flowBuilder));
        flow.recycle();
        flowBuilder.recycle();
        return res;
    }

    public static ByteBuf newRedeliverUnacknowledgedMessages(long consumerId) {
        PulsarApi.CommandRedeliverUnacknowledgedMessages.Builder redeliverBuilder = PulsarApi.CommandRedeliverUnacknowledgedMessages.newBuilder();
        redeliverBuilder.setConsumerId(consumerId);
        PulsarApi.CommandRedeliverUnacknowledgedMessages redeliver = redeliverBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.REDELIVER_UNACKNOWLEDGED_MESSAGES).setRedeliverUnacknowledgedMessages(redeliverBuilder));
        redeliver.recycle();
        redeliverBuilder.recycle();
        return res;
    }

    public static ByteBuf newRedeliverUnacknowledgedMessages(long consumerId, List<PulsarApi.MessageIdData> messageIds) {
        PulsarApi.CommandRedeliverUnacknowledgedMessages.Builder redeliverBuilder = PulsarApi.CommandRedeliverUnacknowledgedMessages.newBuilder();
        redeliverBuilder.setConsumerId(consumerId);
        redeliverBuilder.addAllMessageIds(messageIds);
        PulsarApi.CommandRedeliverUnacknowledgedMessages redeliver = redeliverBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.REDELIVER_UNACKNOWLEDGED_MESSAGES).setRedeliverUnacknowledgedMessages(redeliverBuilder));
        redeliver.recycle();
        redeliverBuilder.recycle();
        return res;
    }

    public static ByteBuf newConsumerStatsResponse(PulsarApi.ServerError serverError, String errMsg, long requestId) {
        PulsarApi.CommandConsumerStatsResponse.Builder commandConsumerStatsResponseBuilder = PulsarApi.CommandConsumerStatsResponse.newBuilder();
        commandConsumerStatsResponseBuilder.setRequestId(requestId);
        commandConsumerStatsResponseBuilder.setErrorMessage(errMsg);
        commandConsumerStatsResponseBuilder.setErrorCode(serverError);
        PulsarApi.CommandConsumerStatsResponse commandConsumerStatsResponse = commandConsumerStatsResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CONSUMER_STATS_RESPONSE).setConsumerStatsResponse(commandConsumerStatsResponseBuilder));
        commandConsumerStatsResponse.recycle();
        commandConsumerStatsResponseBuilder.recycle();
        return res;
    }

    public static ByteBuf newConsumerStatsResponse(PulsarApi.CommandConsumerStatsResponse.Builder builder) {
        PulsarApi.CommandConsumerStatsResponse commandConsumerStatsResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.CONSUMER_STATS_RESPONSE).setConsumerStatsResponse(builder));
        commandConsumerStatsResponse.recycle();
        builder.recycle();
        return res;
    }

    public static ByteBuf newGetTopicsOfNamespaceRequest(String namespace, long requestId, PulsarApi.CommandGetTopicsOfNamespace.Mode mode) {
        PulsarApi.CommandGetTopicsOfNamespace.Builder topicsBuilder = PulsarApi.CommandGetTopicsOfNamespace.newBuilder();
        topicsBuilder.setNamespace(namespace).setRequestId(requestId).setMode(mode);
        PulsarApi.CommandGetTopicsOfNamespace topicsCommand = topicsBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_TOPICS_OF_NAMESPACE).setGetTopicsOfNamespace(topicsCommand));
        topicsBuilder.recycle();
        topicsCommand.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newGetTopicsOfNamespaceResponseCommand(List<String> topics, long requestId) {
        PulsarApi.CommandGetTopicsOfNamespaceResponse.Builder topicsResponseBuilder = PulsarApi.CommandGetTopicsOfNamespaceResponse.newBuilder();
        topicsResponseBuilder.setRequestId(requestId).addAllTopics(topics);
        PulsarApi.CommandGetTopicsOfNamespaceResponse topicsOfNamespaceResponse = topicsResponseBuilder.build();
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.GET_TOPICS_OF_NAMESPACE_RESPONSE).setGetTopicsOfNamespaceResponse(topicsOfNamespaceResponse).build();
        topicsResponseBuilder.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newGetTopicsOfNamespaceResponse(List<String> topics, long requestId) {
        PulsarApi.CommandGetTopicsOfNamespaceResponse.Builder topicsResponseBuilder = PulsarApi.CommandGetTopicsOfNamespaceResponse.newBuilder();
        topicsResponseBuilder.setRequestId(requestId).addAllTopics(topics);
        PulsarApi.CommandGetTopicsOfNamespaceResponse topicsOfNamespaceResponse = topicsResponseBuilder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_TOPICS_OF_NAMESPACE_RESPONSE).setGetTopicsOfNamespaceResponse(topicsOfNamespaceResponse));
        topicsResponseBuilder.recycle();
        topicsOfNamespaceResponse.recycle();
        return res;
    }

    static ByteBuf newPing() {
        return cmdPing.retainedDuplicate();
    }

    static ByteBuf newPong() {
        return cmdPong.retainedDuplicate();
    }

    public static ByteBuf newGetLastMessageId(long consumerId, long requestId) {
        PulsarApi.CommandGetLastMessageId.Builder cmdBuilder = PulsarApi.CommandGetLastMessageId.newBuilder();
        cmdBuilder.setConsumerId(consumerId).setRequestId(requestId);
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_LAST_MESSAGE_ID).setGetLastMessageId(cmdBuilder.build()));
        cmdBuilder.recycle();
        return res;
    }

    public static ByteBuf newGetLastMessageIdResponse(long requestId, PulsarApi.MessageIdData messageIdData, PulsarApi.MessageIdData consumerMarkDeletePosition) {
        PulsarApi.CommandGetLastMessageIdResponse.Builder response = PulsarApi.CommandGetLastMessageIdResponse.newBuilder().setLastMessageId(messageIdData).setRequestId(requestId);
        if (consumerMarkDeletePosition != null) {
            response.setConsumerMarkDeletePosition(consumerMarkDeletePosition);
        }
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_LAST_MESSAGE_ID_RESPONSE).setGetLastMessageIdResponse(response.build()));
        response.recycle();
        return res;
    }

    public static ByteBuf newGetSchema(long requestId, String topic, Optional<SchemaVersion> version) {
        PulsarApi.CommandGetSchema.Builder schema = PulsarApi.CommandGetSchema.newBuilder().setRequestId(requestId);
        schema.setTopic(topic);
        version.ifPresent(schemaVersion -> schema.setSchemaVersion(ByteString.copyFrom((byte[])schemaVersion.bytes())));
        PulsarApi.CommandGetSchema getSchema = schema.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_SCHEMA).setGetSchema(getSchema));
        schema.recycle();
        return res;
    }

    public static ByteBuf newGetSchemaResponse(long requestId, PulsarApi.CommandGetSchemaResponse response) {
        PulsarApi.CommandGetSchemaResponse.Builder schemaResponseBuilder = PulsarApi.CommandGetSchemaResponse.newBuilder(response).setRequestId(requestId);
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_SCHEMA_RESPONSE).setGetSchemaResponse(schemaResponseBuilder.build()));
        schemaResponseBuilder.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newGetSchemaResponseCommand(long requestId, SchemaInfo schema, SchemaVersion version) {
        PulsarApi.CommandGetSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetSchemaResponse.newBuilder().setRequestId(requestId).setSchemaVersion(ByteString.copyFrom((byte[])version.bytes())).setSchema(Commands.getSchema(schema));
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.GET_SCHEMA_RESPONSE).setGetSchemaResponse(schemaResponse.build()).build();
        schemaResponse.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newGetSchemaResponse(long requestId, SchemaInfo schema, SchemaVersion version) {
        PulsarApi.CommandGetSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetSchemaResponse.newBuilder().setRequestId(requestId).setSchemaVersion(ByteString.copyFrom((byte[])version.bytes())).setSchema(Commands.getSchema(schema));
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_SCHEMA_RESPONSE).setGetSchemaResponse(schemaResponse.build()));
        schemaResponse.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newGetSchemaResponseErrorCommand(long requestId, PulsarApi.ServerError error, String errorMessage) {
        PulsarApi.CommandGetSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetSchemaResponse.newBuilder().setRequestId(requestId).setErrorCode(error).setErrorMessage(errorMessage);
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.GET_SCHEMA_RESPONSE).setGetSchemaResponse(schemaResponse.build()).build();
        schemaResponse.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newGetSchemaResponseError(long requestId, PulsarApi.ServerError error, String errorMessage) {
        PulsarApi.CommandGetSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetSchemaResponse.newBuilder().setRequestId(requestId).setErrorCode(error).setErrorMessage(errorMessage);
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_SCHEMA_RESPONSE).setGetSchemaResponse(schemaResponse.build()));
        schemaResponse.recycle();
        return res;
    }

    public static ByteBuf newGetOrCreateSchema(long requestId, String topic, SchemaInfo schemaInfo) {
        PulsarApi.CommandGetOrCreateSchema getOrCreateSchema = PulsarApi.CommandGetOrCreateSchema.newBuilder().setRequestId(requestId).setTopic(topic).setSchema(Commands.getSchema(schemaInfo)).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_OR_CREATE_SCHEMA).setGetOrCreateSchema(getOrCreateSchema));
        getOrCreateSchema.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newGetOrCreateSchemaResponseCommand(long requestId, SchemaVersion schemaVersion) {
        PulsarApi.CommandGetOrCreateSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetOrCreateSchemaResponse.newBuilder().setRequestId(requestId).setSchemaVersion(ByteString.copyFrom((byte[])schemaVersion.bytes()));
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.GET_OR_CREATE_SCHEMA_RESPONSE).setGetOrCreateSchemaResponse(schemaResponse.build()).build();
        schemaResponse.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newGetOrCreateSchemaResponse(long requestId, SchemaVersion schemaVersion) {
        PulsarApi.CommandGetOrCreateSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetOrCreateSchemaResponse.newBuilder().setRequestId(requestId).setSchemaVersion(ByteString.copyFrom((byte[])schemaVersion.bytes()));
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_OR_CREATE_SCHEMA_RESPONSE).setGetOrCreateSchemaResponse(schemaResponse.build()));
        schemaResponse.recycle();
        return res;
    }

    public static PulsarApi.BaseCommand newGetOrCreateSchemaResponseErrorCommand(long requestId, PulsarApi.ServerError error, String errorMessage) {
        PulsarApi.CommandGetOrCreateSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetOrCreateSchemaResponse.newBuilder().setRequestId(requestId).setErrorCode(error).setErrorMessage(errorMessage);
        PulsarApi.BaseCommand.Builder builder = PulsarApi.BaseCommand.newBuilder();
        PulsarApi.BaseCommand command = builder.setType(PulsarApi.BaseCommand.Type.GET_OR_CREATE_SCHEMA_RESPONSE).setGetOrCreateSchemaResponse(schemaResponse.build()).build();
        schemaResponse.recycle();
        builder.recycle();
        return command;
    }

    public static ByteBuf newGetOrCreateSchemaResponseError(long requestId, PulsarApi.ServerError error, String errorMessage) {
        PulsarApi.CommandGetOrCreateSchemaResponse.Builder schemaResponse = PulsarApi.CommandGetOrCreateSchemaResponse.newBuilder().setRequestId(requestId).setErrorCode(error).setErrorMessage(errorMessage);
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.GET_OR_CREATE_SCHEMA_RESPONSE).setGetOrCreateSchemaResponse(schemaResponse.build()));
        schemaResponse.recycle();
        return res;
    }

    public static ByteBuf newTxn(long tcId, long requestId, long ttlSeconds) {
        PulsarApi.CommandNewTxn commandNewTxn = PulsarApi.CommandNewTxn.newBuilder().setTcId(tcId).setRequestId(requestId).setTxnTtlSeconds(ttlSeconds).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.NEW_TXN).setNewTxn(commandNewTxn));
        commandNewTxn.recycle();
        return res;
    }

    public static ByteBuf newTxnResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandNewTxnResponse commandNewTxnResponse = PulsarApi.CommandNewTxnResponse.newBuilder().setRequestId(requestId).setTxnidMostBits(txnIdMostBits).setTxnidLeastBits(txnIdLeastBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.NEW_TXN_RESPONSE).setNewTxnResponse(commandNewTxnResponse));
        commandNewTxnResponse.recycle();
        return res;
    }

    public static ByteBuf newTxnResponse(long requestId, long txnIdMostBits, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandNewTxnResponse.Builder builder = PulsarApi.CommandNewTxnResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidMostBits(txnIdMostBits);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandNewTxnResponse errorResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.NEW_TXN_RESPONSE).setNewTxnResponse(errorResponse));
        builder.recycle();
        errorResponse.recycle();
        return res;
    }

    public static ByteBuf newAddPartitionToTxn(long requestId, long txnIdLeastBits, long txnIdMostBits, List<String> partitions) {
        PulsarApi.CommandAddPartitionToTxn.Builder builder = PulsarApi.CommandAddPartitionToTxn.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidLeastBits(txnIdLeastBits);
        builder.setTxnidMostBits(txnIdMostBits);
        if (partitions != null) {
            builder.addAllPartitions(partitions);
        }
        PulsarApi.CommandAddPartitionToTxn commandAddPartitionToTxn = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_PARTITION_TO_TXN).setAddPartitionToTxn(commandAddPartitionToTxn));
        commandAddPartitionToTxn.recycle();
        return res;
    }

    public static ByteBuf newAddPartitionToTxnResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandAddPartitionToTxnResponse commandAddPartitionToTxnResponse = PulsarApi.CommandAddPartitionToTxnResponse.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_PARTITION_TO_TXN_RESPONSE).setAddPartitionToTxnResponse(commandAddPartitionToTxnResponse));
        commandAddPartitionToTxnResponse.recycle();
        return res;
    }

    public static ByteBuf newAddPartitionToTxnResponse(long requestId, long txnIdMostBits, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandAddPartitionToTxnResponse.Builder builder = PulsarApi.CommandAddPartitionToTxnResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidMostBits(txnIdMostBits);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandAddPartitionToTxnResponse commandAddPartitionToTxnResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_PARTITION_TO_TXN_RESPONSE).setAddPartitionToTxnResponse(commandAddPartitionToTxnResponse));
        builder.recycle();
        commandAddPartitionToTxnResponse.recycle();
        return res;
    }

    public static ByteBuf newAddSubscriptionToTxn(long requestId, long txnIdLeastBits, long txnIdMostBits, List<PulsarApi.Subscription> subscription) {
        PulsarApi.CommandAddSubscriptionToTxn commandAddSubscriptionToTxn = PulsarApi.CommandAddSubscriptionToTxn.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).addAllSubscription(subscription).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_SUBSCRIPTION_TO_TXN).setAddSubscriptionToTxn(commandAddSubscriptionToTxn));
        commandAddSubscriptionToTxn.recycle();
        return res;
    }

    public static ByteBuf newAddSubscriptionToTxnResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandAddSubscriptionToTxnResponse command = PulsarApi.CommandAddSubscriptionToTxnResponse.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_SUBSCRIPTION_TO_TXN_RESPONSE).setAddSubscriptionToTxnResponse(command));
        command.recycle();
        return res;
    }

    public static ByteBuf newAddSubscriptionToTxnResponse(long requestId, long txnIdMostBits, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandAddSubscriptionToTxnResponse.Builder builder = PulsarApi.CommandAddSubscriptionToTxnResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidMostBits(txnIdMostBits);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandAddSubscriptionToTxnResponse errorResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.ADD_SUBSCRIPTION_TO_TXN_RESPONSE).setAddSubscriptionToTxnResponse(errorResponse));
        builder.recycle();
        errorResponse.recycle();
        return res;
    }

    public static ByteBuf newEndTxn(long requestId, long txnIdLeastBits, long txnIdMostBits, PulsarApi.TxnAction txnAction, List<PulsarApi.MessageIdData> messageIdList) {
        PulsarApi.CommandEndTxn commandEndTxn = PulsarApi.CommandEndTxn.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).setTxnAction(txnAction).addAllMessageId(messageIdList).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN).setEndTxn(commandEndTxn));
        commandEndTxn.recycle();
        for (PulsarApi.MessageIdData messageIdData : messageIdList) {
            messageIdData.recycle();
        }
        return res;
    }

    public static ByteBuf newEndTxnResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandEndTxnResponse commandEndTxnResponse = PulsarApi.CommandEndTxnResponse.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_RESPONSE).setEndTxnResponse(commandEndTxnResponse));
        commandEndTxnResponse.recycle();
        return res;
    }

    public static ByteBuf newEndTxnResponse(long requestId, long txnIdMostBits, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandEndTxnResponse.Builder builder = PulsarApi.CommandEndTxnResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidMostBits(txnIdMostBits);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandEndTxnResponse commandEndTxnResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_RESPONSE).setEndTxnResponse(commandEndTxnResponse));
        builder.recycle();
        commandEndTxnResponse.recycle();
        return res;
    }

    public static ByteBuf newEndTxnOnPartition(long requestId, long txnIdLeastBits, long txnIdMostBits, String topic, PulsarApi.TxnAction txnAction, List<PulsarApi.MessageIdData> messageIdDataList) {
        PulsarApi.CommandEndTxnOnPartition.Builder txnEndOnPartition = PulsarApi.CommandEndTxnOnPartition.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).setTopic(topic).setTxnAction(txnAction).addAllMessageId(messageIdDataList);
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_PARTITION).setEndTxnOnPartition(txnEndOnPartition));
        txnEndOnPartition.recycle();
        for (PulsarApi.MessageIdData messageIdData : messageIdDataList) {
            messageIdData.recycle();
        }
        return res;
    }

    public static ByteBuf newEndTxnOnPartitionResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandEndTxnOnPartitionResponse commandEndTxnOnPartitionResponse = PulsarApi.CommandEndTxnOnPartitionResponse.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_PARTITION_RESPONSE).setEndTxnOnPartitionResponse(commandEndTxnOnPartitionResponse));
        commandEndTxnOnPartitionResponse.recycle();
        return res;
    }

    public static ByteBuf newEndTxnOnPartitionResponse(long requestId, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandEndTxnOnPartitionResponse.Builder builder = PulsarApi.CommandEndTxnOnPartitionResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandEndTxnOnPartitionResponse commandEndTxnOnPartitionResponse = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_PARTITION_RESPONSE).setEndTxnOnPartitionResponse(commandEndTxnOnPartitionResponse));
        builder.recycle();
        commandEndTxnOnPartitionResponse.recycle();
        return res;
    }

    public static ByteBuf newEndTxnOnSubscription(long requestId, long txnIdLeastBits, long txnIdMostBits, String topic, String subscription, PulsarApi.TxnAction txnAction) {
        PulsarApi.Subscription.Builder builder = PulsarApi.Subscription.newBuilder();
        builder.setTopic(topic);
        builder.setSubscription(subscription);
        PulsarApi.Subscription sub = builder.build();
        builder.recycle();
        return Commands.newEndTxnOnSubscription(requestId, txnIdLeastBits, txnIdMostBits, sub, txnAction);
    }

    public static ByteBuf newEndTxnOnSubscription(long requestId, long txnIdLeastBits, long txnIdMostBits, PulsarApi.Subscription subscription, PulsarApi.TxnAction txnAction) {
        PulsarApi.CommandEndTxnOnSubscription commandEndTxnOnSubscription = PulsarApi.CommandEndTxnOnSubscription.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).setSubscription(subscription).setTxnAction(txnAction).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_SUBSCRIPTION).setEndTxnOnSubscription(commandEndTxnOnSubscription));
        subscription.recycle();
        commandEndTxnOnSubscription.recycle();
        return res;
    }

    public static ByteBuf newEndTxnOnSubscriptionResponse(long requestId, long txnIdLeastBits, long txnIdMostBits) {
        PulsarApi.CommandEndTxnOnSubscriptionResponse response = PulsarApi.CommandEndTxnOnSubscriptionResponse.newBuilder().setRequestId(requestId).setTxnidLeastBits(txnIdLeastBits).setTxnidMostBits(txnIdMostBits).build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_SUBSCRIPTION_RESPONSE).setEndTxnOnSubscriptionResponse(response));
        response.recycle();
        return res;
    }

    public static ByteBuf newEndTxnOnSubscriptionResponse(long requestId, long txnIdLeastBits, long txnIdMostBits, PulsarApi.ServerError error, String errorMsg) {
        PulsarApi.CommandEndTxnOnSubscriptionResponse.Builder builder = PulsarApi.CommandEndTxnOnSubscriptionResponse.newBuilder();
        builder.setRequestId(requestId);
        builder.setTxnidMostBits(txnIdMostBits);
        builder.setTxnidLeastBits(txnIdLeastBits);
        builder.setError(error);
        if (errorMsg != null) {
            builder.setMessage(errorMsg);
        }
        PulsarApi.CommandEndTxnOnSubscriptionResponse response = builder.build();
        ByteBuf res = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.END_TXN_ON_SUBSCRIPTION_RESPONSE).setEndTxnOnSubscriptionResponse(response));
        builder.recycle();
        response.recycle();
        return res;
    }

    @VisibleForTesting
    public static ByteBuf serializeWithSize(PulsarApi.BaseCommand.Builder cmdBuilder) {
        PulsarApi.BaseCommand cmd = cmdBuilder.build();
        int cmdSize = cmd.getSerializedSize();
        int totalSize = cmdSize + 4;
        int frameSize = totalSize + 4;
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(frameSize, frameSize);
        buf.writeInt(totalSize);
        buf.writeInt(cmdSize);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(buf);
        try {
            cmd.writeTo(outStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            cmd.recycle();
            cmdBuilder.recycle();
            outStream.recycle();
        }
        return buf;
    }

    public static ByteBuf serializeWithSize(PulsarApi.BaseCommand cmd) {
        int cmdSize = cmd.getSerializedSize();
        int totalSize = cmdSize + 4;
        int frameSize = totalSize + 4;
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(frameSize, frameSize);
        buf.writeInt(totalSize);
        buf.writeInt(cmdSize);
        ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(buf);
        try {
            cmd.writeTo(outStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            outStream.recycle();
        }
        return buf;
    }

    private static ByteBufPair serializeCommandSendWithSize(PulsarApi.BaseCommand.Builder cmdBuilder, ChecksumType checksumType, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload) {
        PulsarApi.BaseCommand cmd = cmdBuilder.build();
        int cmdSize = cmd.getSerializedSize();
        int msgMetadataSize = msgMetadata.getSerializedSize();
        int payloadSize = payload.readableBytes();
        int magicAndChecksumLength = ChecksumType.Crc32c.equals((Object)checksumType) ? 6 : 0;
        boolean includeChecksum = magicAndChecksumLength > 0;
        int headerContentSize = 4 + cmdSize + magicAndChecksumLength + 4 + msgMetadataSize;
        int totalSize = headerContentSize + payloadSize;
        int headersSize = 4 + headerContentSize;
        int checksumReaderIndex = -1;
        ByteBuf headers = PulsarByteBufAllocator.DEFAULT.buffer(headersSize, headersSize);
        headers.writeInt(totalSize);
        try {
            headers.writeInt(cmdSize);
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(headers);
            cmd.writeTo(outStream);
            cmd.recycle();
            cmdBuilder.recycle();
            if (includeChecksum) {
                headers.writeShort(3585);
                checksumReaderIndex = headers.writerIndex();
                headers.writerIndex(headers.writerIndex() + 4);
            }
            headers.writeInt(msgMetadataSize);
            msgMetadata.writeTo(outStream);
            outStream.recycle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBufPair command = ByteBufPair.get(headers, payload);
        if (includeChecksum) {
            headers.markReaderIndex();
            headers.readerIndex(checksumReaderIndex + 4);
            int metadataChecksum = Crc32cIntChecksum.computeChecksum((ByteBuf)headers);
            int computedChecksum = Crc32cIntChecksum.resumeChecksum((int)metadataChecksum, (ByteBuf)payload);
            headers.setInt(checksumReaderIndex, computedChecksum);
            headers.resetReaderIndex();
        }
        return command;
    }

    public static ByteBuf serializeMetadataAndPayload(ChecksumType checksumType, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload) {
        int msgMetadataSize = msgMetadata.getSerializedSize();
        int payloadSize = payload.readableBytes();
        int magicAndChecksumLength = ChecksumType.Crc32c.equals((Object)checksumType) ? 6 : 0;
        boolean includeChecksum = magicAndChecksumLength > 0;
        int headerContentSize = magicAndChecksumLength + 4 + msgMetadataSize;
        int checksumReaderIndex = -1;
        int totalSize = headerContentSize + payloadSize;
        ByteBuf metadataAndPayload = PulsarByteBufAllocator.DEFAULT.buffer(totalSize, totalSize);
        try {
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(metadataAndPayload);
            if (includeChecksum) {
                metadataAndPayload.writeShort(3585);
                checksumReaderIndex = metadataAndPayload.writerIndex();
                metadataAndPayload.writerIndex(metadataAndPayload.writerIndex() + 4);
            }
            metadataAndPayload.writeInt(msgMetadataSize);
            msgMetadata.writeTo(outStream);
            outStream.recycle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (includeChecksum) {
            metadataAndPayload.markReaderIndex();
            metadataAndPayload.readerIndex(checksumReaderIndex + 4);
            int metadataChecksum = Crc32cIntChecksum.computeChecksum((ByteBuf)metadataAndPayload);
            int computedChecksum = Crc32cIntChecksum.resumeChecksum((int)metadataChecksum, (ByteBuf)payload);
            metadataAndPayload.setInt(checksumReaderIndex, computedChecksum);
            metadataAndPayload.resetReaderIndex();
        }
        metadataAndPayload.writeBytes(payload);
        return metadataAndPayload;
    }

    public static long initBatchMessageMetadata(PulsarApi.MessageMetadata.Builder messageMetadata, PulsarApi.MessageMetadata.Builder builder) {
        messageMetadata.setPublishTime(builder.getPublishTime());
        messageMetadata.setProducerName(builder.getProducerName());
        messageMetadata.setSequenceId(builder.getSequenceId());
        if (builder.hasPartitionKey()) {
            messageMetadata.setPartitionKey(builder.getPartitionKey());
            messageMetadata.setPartitionKeyB64Encoded(builder.getPartitionKeyB64Encoded());
        }
        if (builder.hasOrderingKey()) {
            messageMetadata.setOrderingKey(builder.getOrderingKey());
        }
        if (builder.hasReplicatedFrom()) {
            messageMetadata.setReplicatedFrom(builder.getReplicatedFrom());
        }
        if (builder.getReplicateToCount() > 0) {
            messageMetadata.addAllReplicateTo(builder.getReplicateToList());
        }
        if (builder.hasSchemaVersion()) {
            messageMetadata.setSchemaVersion(builder.getSchemaVersion());
        }
        return builder.getSequenceId();
    }

    public static ByteBuf serializeSingleMessageInBatchWithPayload(PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder, ByteBuf payload, ByteBuf batchBuffer) {
        int payLoadSize = payload.readableBytes();
        PulsarApi.SingleMessageMetadata singleMessageMetadata = singleMessageMetadataBuilder.setPayloadSize(payLoadSize).build();
        int singleMsgMetadataSize = singleMessageMetadata.getSerializedSize();
        try {
            batchBuffer.writeInt(singleMsgMetadataSize);
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(batchBuffer);
            singleMessageMetadata.writeTo(outStream);
            singleMessageMetadata.recycle();
            outStream.recycle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return batchBuffer.writeBytes(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf serializeSingleMessageInBatchWithPayload(PulsarApi.MessageMetadata.Builder msgBuilder, ByteBuf payload, ByteBuf batchBuffer) {
        PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
        if (msgBuilder.hasPartitionKey()) {
            singleMessageMetadataBuilder = singleMessageMetadataBuilder.setPartitionKey(msgBuilder.getPartitionKey()).setPartitionKeyB64Encoded(msgBuilder.getPartitionKeyB64Encoded());
        }
        if (msgBuilder.hasOrderingKey()) {
            singleMessageMetadataBuilder = singleMessageMetadataBuilder.setOrderingKey(msgBuilder.getOrderingKey());
        }
        if (!msgBuilder.getPropertiesList().isEmpty()) {
            singleMessageMetadataBuilder = singleMessageMetadataBuilder.addAllProperties(msgBuilder.getPropertiesList());
        }
        if (msgBuilder.hasEventTime()) {
            singleMessageMetadataBuilder.setEventTime(msgBuilder.getEventTime());
        }
        if (msgBuilder.hasSequenceId()) {
            singleMessageMetadataBuilder.setSequenceId(msgBuilder.getSequenceId());
        }
        if (msgBuilder.hasNullValue()) {
            singleMessageMetadataBuilder.setNullValue(msgBuilder.hasNullValue());
        }
        if (msgBuilder.hasNullPartitionKey()) {
            singleMessageMetadataBuilder.setNullPartitionKey(msgBuilder.hasNullPartitionKey());
        }
        try {
            ByteBuf byteBuf = Commands.serializeSingleMessageInBatchWithPayload(singleMessageMetadataBuilder, payload, batchBuffer);
            return byteBuf;
        }
        finally {
            singleMessageMetadataBuilder.recycle();
        }
    }

    public static ByteBuf deSerializeSingleMessageInBatch(ByteBuf uncompressedPayload, PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder, int index, int batchSize) throws IOException {
        int singleMetaSize = (int)uncompressedPayload.readUnsignedInt();
        int writerIndex = uncompressedPayload.writerIndex();
        int beginIndex = uncompressedPayload.readerIndex() + singleMetaSize;
        uncompressedPayload.writerIndex(beginIndex);
        ByteBufCodedInputStream stream = ByteBufCodedInputStream.get(uncompressedPayload);
        singleMessageMetadataBuilder.mergeFrom(stream, null);
        stream.recycle();
        int singleMessagePayloadSize = singleMessageMetadataBuilder.getPayloadSize();
        int readerIndex = uncompressedPayload.readerIndex();
        ByteBuf singleMessagePayload = uncompressedPayload.retainedSlice(readerIndex, singleMessagePayloadSize);
        uncompressedPayload.writerIndex(writerIndex);
        if (index < batchSize) {
            uncompressedPayload.readerIndex(readerIndex + singleMessagePayloadSize);
        }
        return singleMessagePayload;
    }

    public static ByteBufPair serializeCommandMessageWithSize(PulsarApi.BaseCommand cmd, ByteBuf metadataAndPayload) {
        int cmdSize = cmd.getSerializedSize();
        int totalSize = 4 + cmdSize + metadataAndPayload.readableBytes();
        int headersSize = 8 + cmdSize;
        ByteBuf headers = PulsarByteBufAllocator.DEFAULT.buffer(headersSize);
        headers.writeInt(totalSize);
        try {
            headers.writeInt(cmdSize);
            ByteBufCodedOutputStream outStream = ByteBufCodedOutputStream.get(headers);
            cmd.writeTo(outStream);
            outStream.recycle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ByteBufPair.get(headers, metadataAndPayload);
    }

    public static int getNumberOfMessagesInBatch(ByteBuf metadataAndPayload, String subscription, long consumerId) {
        PulsarApi.MessageMetadata msgMetadata = Commands.peekMessageMetadata(metadataAndPayload, subscription, consumerId);
        if (msgMetadata == null) {
            return -1;
        }
        int numMessagesInBatch = msgMetadata.getNumMessagesInBatch();
        msgMetadata.recycle();
        return numMessagesInBatch;
    }

    public static PulsarApi.MessageMetadata peekMessageMetadata(ByteBuf metadataAndPayload, String subscription, long consumerId) {
        try {
            int readerIdx = metadataAndPayload.readerIndex();
            PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata(metadataAndPayload);
            metadataAndPayload.readerIndex(readerIdx);
            return metadata;
        }
        catch (Throwable t) {
            log.error("[{}] [{}] Failed to parse message metadata", new Object[]{subscription, consumerId, t});
            return null;
        }
    }

    public static int getCurrentProtocolVersion() {
        return PulsarApi.ProtocolVersion.values()[PulsarApi.ProtocolVersion.values().length - 1].getNumber();
    }

    public static boolean peerSupportsGetLastMessageId(int peerVersion) {
        return peerVersion >= PulsarApi.ProtocolVersion.v12.getNumber();
    }

    public static boolean peerSupportsActiveConsumerListener(int peerVersion) {
        return peerVersion >= PulsarApi.ProtocolVersion.v12.getNumber();
    }

    public static boolean peerSupportsMultiMessageAcknowledgment(int peerVersion) {
        return peerVersion >= PulsarApi.ProtocolVersion.v12.getNumber();
    }

    public static boolean peerSupportJsonSchemaAvroFormat(int peerVersion) {
        return peerVersion >= PulsarApi.ProtocolVersion.v13.getNumber();
    }

    public static boolean peerSupportsGetOrCreateSchema(int peerVersion) {
        return peerVersion >= PulsarApi.ProtocolVersion.v15.getNumber();
    }

    private Commands() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ByteBuf serializedCmdPing = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PING).setPing(PulsarApi.CommandPing.getDefaultInstance()));
        cmdPing = Unpooled.copiedBuffer((ByteBuf)serializedCmdPing);
        serializedCmdPing.release();
        ByteBuf serializedCmdPong = Commands.serializeWithSize(PulsarApi.BaseCommand.newBuilder().setType(PulsarApi.BaseCommand.Type.PONG).setPong(PulsarApi.CommandPong.getDefaultInstance()));
        cmdPong = Unpooled.copiedBuffer((ByteBuf)serializedCmdPong);
        serializedCmdPong.release();
    }

    public static enum ChecksumType {
        Crc32c,
        None;

    }
}

