/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.pulsar.common.policies.data.TopicType;

public class AutoTopicCreationOverride {
    public boolean allowAutoTopicCreation;
    public String topicType;
    public Integer defaultNumPartitions;

    public AutoTopicCreationOverride() {
    }

    public AutoTopicCreationOverride(boolean allowAutoTopicCreation, String topicType, Integer defaultNumPartitions) {
        this.allowAutoTopicCreation = allowAutoTopicCreation;
        this.topicType = topicType;
        this.defaultNumPartitions = defaultNumPartitions;
    }

    public int hashCode() {
        return Objects.hash(this.allowAutoTopicCreation, this.topicType, this.defaultNumPartitions);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AutoTopicCreationOverride) {
            AutoTopicCreationOverride other = (AutoTopicCreationOverride)obj;
            return Objects.equals(this.allowAutoTopicCreation, other.allowAutoTopicCreation) && Objects.equals(this.topicType, other.topicType) && Objects.equals(this.defaultNumPartitions, other.defaultNumPartitions);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allowAutoTopicCreation", this.allowAutoTopicCreation).add("topicType", (Object)this.topicType).add("defaultNumPartitions", (Object)this.defaultNumPartitions).toString();
    }

    public static boolean isValidOverride(AutoTopicCreationOverride override) {
        if (override == null) {
            return false;
        }
        if (override.allowAutoTopicCreation) {
            if (!TopicType.isValidTopicType(override.topicType)) {
                return false;
            }
            if (TopicType.PARTITIONED.toString().equals(override.topicType)) {
                if (override.defaultNumPartitions == null) {
                    return false;
                }
                if (override.defaultNumPartitions <= 0) {
                    return false;
                }
            } else if (TopicType.NON_PARTITIONED.toString().equals(override.topicType) && override.defaultNumPartitions != null) {
                return false;
            }
        }
        return true;
    }
}

