/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.impl.AutoFailoverPolicyFactory;

@ApiModel(value="AutoFailoverPolicyData", description="The auto failover policy configuration data")
public class AutoFailoverPolicyData {
    @ApiModelProperty(name="policy_type", value="The auto failover policy type", allowableValues="min_available")
    public AutoFailoverPolicyType policy_type;
    @ApiModelProperty(name="parameters", value="The parameters applied to the auto failover policy specified by `policy_type`.\nThe parameters for 'min_available' are :\n  - 'min_limit': the limit of minimal number of available brokers in primary group before auto failover\n  - 'usage_threshold': the resource usage threshold. If the usage of a broker is beyond this value, it would be marked as unavailable\n", example="{\n  \"min_limit\": 3,\n  \"usage_threshold\": 80\n}\n")
    public Map<String, String> parameters;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.policy_type, this.parameters});
    }

    public boolean equals(Object obj) {
        if (obj instanceof AutoFailoverPolicyData) {
            AutoFailoverPolicyData other = (AutoFailoverPolicyData)obj;
            return Objects.equal((Object)((Object)this.policy_type), (Object)((Object)other.policy_type)) && Objects.equal(this.parameters, other.parameters);
        }
        return false;
    }

    public void validate() {
        Preconditions.checkArgument((this.policy_type != null && this.parameters != null ? 1 : 0) != 0);
        AutoFailoverPolicyFactory.create(this);
    }

    public String toString() {
        return String.format("policy_type=%s parameters=%s", new Object[]{this.policy_type, this.parameters});
    }
}

