/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ByteString;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ExtensionRegistryLite;
import org.apache.pulsar.shaded.com.google.protobuf.v241.InvalidProtocolBufferException;
import org.apache.pulsar.shaded.com.google.protobuf.v241.WireFormat;

public class ByteBufCodedInputStream {
    private ByteBuf buf;
    private int lastTag;
    private final Recycler.Handle<ByteBufCodedInputStream> recyclerHandle;
    private static final Recycler<ByteBufCodedInputStream> RECYCLER = new Recycler<ByteBufCodedInputStream>(){

        protected ByteBufCodedInputStream newObject(Recycler.Handle<ByteBufCodedInputStream> handle) {
            return new ByteBufCodedInputStream(handle);
        }
    };
    private static final FastThreadLocal<byte[]> localByteArray = new FastThreadLocal();
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;

    public static ByteBufCodedInputStream get(ByteBuf buf) {
        ByteBufCodedInputStream stream = (ByteBufCodedInputStream)RECYCLER.get();
        stream.buf = buf;
        stream.lastTag = 0;
        return stream;
    }

    private ByteBufCodedInputStream(Recycler.Handle<ByteBufCodedInputStream> handle) {
        this.recyclerHandle = handle;
    }

    public void recycle() {
        this.buf = null;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle((Object)this);
        }
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber((int)this.lastTag) == 0) {
            throw new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
        }
        return this.lastTag;
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public boolean isAtEnd() throws IOException {
        return !this.buf.isReadable();
    }

    public void readMessage(ByteBufMessageBuilder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
        int length = this.readRawVarint32();
        int writerIdx = this.buf.writerIndex();
        this.buf.writerIndex(this.buf.readerIndex() + length);
        builder.mergeFrom(this, extensionRegistry);
        this.checkLastTagWas(0);
        this.buf.writerIndex(writerIdx);
    }

    public ByteString readBytes() throws IOException {
        int size = this.readRawVarint32();
        if (size == 0) {
            return ByteString.EMPTY;
        }
        byte[] localBuf = (byte[])localByteArray.get();
        if (localBuf == null || localBuf.length < size) {
            localBuf = new byte[Math.max(size, 1024)];
            localByteArray.set((Object)localBuf);
        }
        this.buf.readBytes(localBuf, 0, size);
        ByteString res = ByteString.copyFrom((byte[])localBuf, (int)0, (int)size);
        return res;
    }

    static int getTagWireType(int tag) {
        return tag & 7;
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public boolean skipField(int tag) throws IOException {
        switch (ByteBufCodedInputStream.getTagWireType(tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(ByteBufCodedInputStream.makeTag(WireFormat.getTagFieldNumber((int)tag), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw new InvalidProtocolBufferException("Protocol message tag had invalid wire type.");
    }

    public void checkLastTagWas(int value) throws InvalidProtocolBufferException {
        if (this.lastTag != value) {
            throw new InvalidProtocolBufferException("Protocol message end-group tag did not match expected tag.");
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.buf.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.buf.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.buf.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.buf.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.buf.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.buf.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.buf.readByte() < 0) continue;
                            return result;
                        }
                        throw new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    public int readRawLittleEndian32() throws IOException {
        return this.buf.readIntLE();
    }

    public long readRawLittleEndian64() throws IOException {
        return this.buf.readLongLE();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public void skipRawBytes(int size) throws IOException {
        if (size < 0) {
            throw new InvalidProtocolBufferException("CodedInputStream encountered an embedded string or message which claimed to have negative size.");
        }
        if (size > this.buf.readableBytes()) {
            throw new InvalidProtocolBufferException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either than the input has been truncated or that an embedded message misreported its own length.");
        }
        this.buf.readerIndex(this.buf.readerIndex() + size);
    }

    public int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
        int oldLimit;
        if (byteLimit < 0) {
            throw new InvalidProtocolBufferException("CodedInputStream encountered an embedded string or message which claimed to have negative size.");
        }
        if ((byteLimit += this.buf.readerIndex()) > (oldLimit = this.buf.writerIndex())) {
            throw new InvalidProtocolBufferException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either than the input has been truncated or that an embedded message misreported its own length.");
        }
        this.buf.writerIndex(byteLimit);
        return oldLimit;
    }

    public void popLimit(int oldLimit) {
        this.buf.writerIndex(oldLimit);
    }

    public int getBytesUntilLimit() {
        return this.buf.readableBytes();
    }

    public static interface ByteBufMessageBuilder {
        public ByteBufMessageBuilder mergeFrom(ByteBufCodedInputStream var1, ExtensionRegistryLite var2) throws IOException;
    }
}

