/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol.schema;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;

public class SchemaHash {
    private static HashFunction hashFunction = Hashing.sha256();
    private final HashCode hash;

    private SchemaHash(HashCode hash) {
        this.hash = hash;
    }

    public static SchemaHash of(Schema schema) {
        return SchemaHash.of(Optional.ofNullable(schema).map(Schema::getSchemaInfo).map(SchemaInfo::getSchema).orElse(new byte[0]));
    }

    public static SchemaHash of(SchemaData schemaData) {
        return SchemaHash.of(schemaData.getData());
    }

    private static SchemaHash of(byte[] schemaBytes) {
        return new SchemaHash(hashFunction.hashBytes(schemaBytes));
    }

    public byte[] asBytes() {
        return this.hash.asBytes();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaHash)) {
            return false;
        }
        SchemaHash other = (SchemaHash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashCode this$hash = this.hash;
        HashCode other$hash = other.hash;
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaHash;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashCode $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }
}

