/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import io.netty.resolver.dns.DnsNameResolverBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsResolverUtil {
    private static final Logger log = LoggerFactory.getLogger(DnsResolverUtil.class);
    private static final int MIN_TTL = 0;
    private static final int TTL;
    private static final int NEGATIVE_TTL;
    private static final int DEFAULT_TTL = 60;
    private static final int DEFAULT_NEGATIVE_TTL = 10;

    private static int useDefaultTTLWhenSetToForever(int ttl, int defaultTtl) {
        return ttl < 0 ? defaultTtl : ttl;
    }

    private DnsResolverUtil() {
    }

    public static void applyJdkDnsCacheSettings(DnsNameResolverBuilder dnsNameResolverBuilder) {
        dnsNameResolverBuilder.ttl(0, TTL);
        dnsNameResolverBuilder.negativeTtl(NEGATIVE_TTL);
    }

    static {
        int ttl = 60;
        int negativeTtl = 10;
        try {
            Class<?> inetAddressCachePolicyClass = Class.forName("sun.net.InetAddressCachePolicy");
            Method getTTLMethod = inetAddressCachePolicyClass.getMethod("get", new Class[0]);
            ttl = (Integer)getTTLMethod.invoke(null, new Object[0]);
            Method getNegativeTTLMethod = inetAddressCachePolicyClass.getMethod("getNegative", new Class[0]);
            negativeTtl = (Integer)getNegativeTTLMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Cannot get DNS TTL settings from sun.net.InetAddressCachePolicy class", (Throwable)e);
        }
        TTL = DnsResolverUtil.useDefaultTTLWhenSetToForever(ttl, 60);
        NEGATIVE_TTL = DnsResolverUtil.useDefaultTTLWhenSetToForever(negativeTtl, 10);
    }
}

