/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.stats.NonPersistentPublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.NonPersistentSubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class NonPersistentTopicStatsImpl
extends TopicStatsImpl
implements NonPersistentTopicStats {
    public double msgDropRate;
    @JsonIgnore
    public List<PublisherStatsImpl> publishers;
    @JsonIgnore
    public Map<String, SubscriptionStatsImpl> subscriptions;
    @JsonIgnore
    public Map<String, ReplicatorStatsImpl> replication;
    private List<NonPersistentPublisherStats> nonPersistentPublishers = new ArrayList<NonPersistentPublisherStats>();
    private Map<String, NonPersistentPublisherStats> nonPersistentPublishersMap = new ConcurrentHashMap<String, NonPersistentPublisherStats>();
    public Map<String, ? extends NonPersistentSubscriptionStats> nonPersistentSubscriptions = new HashMap<String, NonPersistentSubscriptionStats>();
    public Map<String, ? extends NonPersistentReplicatorStats> nonPersistentReplicators = new TreeMap<String, NonPersistentReplicatorStats>();

    @JsonProperty(value="publishers")
    public List<NonPersistentPublisherStats> getNonPersistentPublishers() {
        return Stream.concat(this.nonPersistentPublishers.stream().sorted(Comparator.comparing(PublisherStats::getProducerName)), this.nonPersistentPublishersMap.values().stream().sorted(Comparator.comparing(PublisherStats::getProducerName))).collect(Collectors.toList());
    }

    @JsonProperty(value="subscriptions")
    public Map<String, NonPersistentSubscriptionStats> getNonPersistentSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @JsonProperty(value="replication")
    public Map<String, NonPersistentReplicatorStats> getNonPersistentReplicators() {
        return this.nonPersistentReplicators;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public List<NonPersistentPublisherStats> getPublishers() {
        return Stream.concat(this.nonPersistentPublishers.stream().sorted(Comparator.comparing(PublisherStats::getProducerName)), this.nonPersistentPublishersMap.values().stream().sorted(Comparator.comparing(PublisherStats::getProducerName))).collect(Collectors.toList());
    }

    @Override
    public void setPublishers(List<? extends PublisherStats> statsList) {
        this.nonPersistentPublishers.clear();
        this.nonPersistentPublishersMap.clear();
        statsList.forEach(s -> this.addPublisher((NonPersistentPublisherStatsImpl)s));
    }

    public void addPublisher(NonPersistentPublisherStatsImpl stats) {
        if (stats.isSupportsPartialProducer()) {
            this.nonPersistentPublishersMap.put(stats.getProducerName(), stats);
        } else {
            this.nonPersistentPublishers.add(stats);
        }
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentSubscriptionStats> getSubscriptions() {
        return this.nonPersistentSubscriptions;
    }

    @SuppressFBWarnings(value={"MF_CLASS_MASKS_FIELD"}, justification="expected to override")
    public Map<String, NonPersistentReplicatorStats> getReplication() {
        return this.nonPersistentReplicators;
    }

    public double getMsgDropRate() {
        return this.msgDropRate;
    }

    @Override
    public void reset() {
        super.reset();
        this.nonPersistentPublishers.clear();
        this.nonPersistentPublishersMap.clear();
        this.nonPersistentSubscriptions.clear();
        this.nonPersistentReplicators.clear();
        this.msgDropRate = 0.0;
    }

    public NonPersistentTopicStatsImpl add(NonPersistentTopicStats ts) {
        NonPersistentReplicatorStatsImpl replStats;
        NonPersistentSubscriptionStatsImpl subscriptionStats;
        NonPersistentTopicStatsImpl stats = (NonPersistentTopicStatsImpl)ts;
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        stats.getNonPersistentPublishers().forEach(s -> {
            if (s.isSupportsPartialProducer()) {
                ((NonPersistentPublisherStatsImpl)this.nonPersistentPublishersMap.computeIfAbsent(s.getProducerName(), key -> {
                    NonPersistentPublisherStatsImpl newStats = new NonPersistentPublisherStatsImpl();
                    newStats.setSupportsPartialProducer(true);
                    newStats.setProducerName(s.getProducerName());
                    return newStats;
                })).add((NonPersistentPublisherStatsImpl)s);
            } else if (this.nonPersistentPublishers.size() != stats.getNonPersistentPublishers().size()) {
                for (int i = 0; i < stats.getNonPersistentPublishers().size(); ++i) {
                    NonPersistentPublisherStatsImpl newStats = new NonPersistentPublisherStatsImpl();
                    newStats.setSupportsPartialProducer(false);
                    this.nonPersistentPublishers.add(newStats.add((NonPersistentPublisherStatsImpl)s));
                }
            } else {
                for (int i = 0; i < stats.getNonPersistentPublishers().size(); ++i) {
                    ((NonPersistentPublisherStatsImpl)this.nonPersistentPublishers.get(i)).add((NonPersistentPublisherStatsImpl)s);
                }
            }
        });
        if (this.getNonPersistentSubscriptions().size() != stats.getNonPersistentSubscriptions().size()) {
            for (String subscription : stats.getNonPersistentSubscriptions().keySet()) {
                subscriptionStats = new NonPersistentSubscriptionStatsImpl();
                this.getNonPersistentSubscriptions().put(subscription, subscriptionStats.add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription)));
            }
        } else {
            for (String subscription : stats.getNonPersistentSubscriptions().keySet()) {
                if (this.getNonPersistentSubscriptions().get(subscription) != null) {
                    ((NonPersistentSubscriptionStatsImpl)this.getNonPersistentSubscriptions().get(subscription)).add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription));
                    continue;
                }
                subscriptionStats = new NonPersistentSubscriptionStatsImpl();
                this.getNonPersistentSubscriptions().put(subscription, subscriptionStats.add((NonPersistentSubscriptionStatsImpl)stats.getNonPersistentSubscriptions().get(subscription)));
            }
        }
        if (this.getNonPersistentReplicators().size() != stats.getNonPersistentReplicators().size()) {
            for (String repl : stats.getNonPersistentReplicators().keySet()) {
                replStats = new NonPersistentReplicatorStatsImpl();
                this.getNonPersistentReplicators().put(repl, replStats.add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl)));
            }
        } else {
            for (String repl : stats.getNonPersistentReplicators().keySet()) {
                if (this.getNonPersistentReplicators().get(repl) != null) {
                    ((NonPersistentReplicatorStatsImpl)this.getNonPersistentReplicators().get(repl)).add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl));
                    continue;
                }
                replStats = new NonPersistentReplicatorStatsImpl();
                this.getNonPersistentReplicators().put(repl, replStats.add((NonPersistentReplicatorStatsImpl)stats.getNonPersistentReplicators().get(repl)));
            }
        }
        return this;
    }
}

