/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import io.netty.handler.ssl.SslContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientSslContextRefresher
extends SslContextAutoRefreshBuilder<SslContext> {
    private static final Logger log = LoggerFactory.getLogger(NettyClientSslContextRefresher.class);
    private volatile SslContext sslNettyContext;
    private boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertsFilePath;
    protected final FileModifiedTimeUpdater tlsPrivateKeyFilePath;
    private AuthenticationDataProvider authData;

    public NettyClientSslContextRefresher(boolean allowInsecure, String trustCertsFilePath, AuthenticationDataProvider authData, long delayInSeconds) throws IOException, GeneralSecurityException {
        super(delayInSeconds);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.authData = authData;
        this.tlsCertsFilePath = new FileModifiedTimeUpdater(authData != null ? authData.getTlsCerificateFilePath() : null);
        this.tlsPrivateKeyFilePath = new FileModifiedTimeUpdater(authData != null ? authData.getTlsPrivateKeyFilePath() : null);
    }

    @Override
    public synchronized SslContext update() throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.sslNettyContext = this.authData != null && this.authData.hasDataForTls() ? (this.authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.authData.getTlsTrustStoreStream(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey())) : SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName());
        return this.sslNettyContext;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslNettyContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertsFilePath.checkAndRefresh() || this.tlsPrivateKeyFilePath.checkAndRefresh();
    }
}

